/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.CallTree;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.CodeMap;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8ProfileCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8TickProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.CodeState;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class V8Profile {
    private final CodeMap myCodeMap;
    private final CallTree myTopDownTree;
    private final CallTree myBottomUpTree;
    private final List<CallTree.CallTreeNode> myFlat;
    @NotNull
    private final V8ProfileCallback myCallback;
    private int myNumTicks;
    private int myUnaccountedTicks;
    private int myIdleTicks;
    private int myGcTicks;
    private V8ProfileLine myBottomUpRoot;
    private V8ProfileLine myTopDownRoot;
    private FlatTopCalls myFlatTopCallsRoot;
    private int myMaxStackSize;

    public V8Profile(@NotNull V8ProfileCallback callback) {
        if (callback == null) {
            V8Profile.$$$reportNull$$$0(0);
        }
        this.myCallback = callback;
        this.myCodeMap = new CodeMap();
        this.myTopDownTree = new CallTree();
        this.myBottomUpTree = new CallTree();
        this.myFlat = new ArrayList<CallTree.CallTreeNode>();
        this.myNumTicks = 0;
    }

    public int getUnaccountedTicks() {
        return this.myUnaccountedTicks;
    }

    public int getIdleTicks() {
        return this.myIdleTicks;
    }

    public int getGcTicks() {
        return this.myGcTicks;
    }

    public int getNumTicks() {
        return this.myNumTicks;
    }

    public int getMaxStackSize() {
        return this.myMaxStackSize;
    }

    private void computeTotalWeights() {
        this.myTopDownTree.computeTotalWeight();
        this.myBottomUpTree.computeTotalWeight();
        this.computeFlatView();
    }

    private void computeFlatView() {
        HashMap<Long, Integer> currentStack = new HashMap<Long, Integer>();
        CallTree.CallTreeNode counters = new CallTree.CallTreeNode(-1L);
        ArrayDeque<Data> queue = new ArrayDeque<Data>();
        queue.add(new Data(State.root, this.myTopDownTree.getRoot()));
        while (!queue.isEmpty()) {
            Data data = (Data)queue.removeFirst();
            Long code = data.myNode.getName();
            if (State.enter.equals((Object)data.myState)) {
                Integer integer;
                CallTree.CallTreeNode child = counters.findOrAddChild(code);
                child.getSelfWeight().add(data.myNode.getSelfWeight().getCnt());
                if (!currentStack.containsKey(code)) {
                    child.getTotalWeight().add(data.myNode.getTotalWeight().getCnt());
                }
                if ((integer = (Integer)currentStack.get(code)) != null) {
                    currentStack.put(code, integer + 1);
                } else {
                    currentStack.put(code, 1);
                }
                queue.addFirst(new Data(State.exit, data.myNode));
                Collection<CallTree.CallTreeNode> values = data.myNode.getChildren().values();
                for (CallTree.CallTreeNode value : values) {
                    queue.addFirst(new Data(State.enter, value));
                }
                continue;
            }
            if (State.exit.equals((Object)data.myState)) {
                Integer integer = (Integer)currentStack.get(code);
                if (integer == null || integer <= 0) continue;
                if (integer == 1) {
                    currentStack.remove(code);
                    continue;
                }
                currentStack.put(code, integer - 1);
                continue;
            }
            Collection<CallTree.CallTreeNode> values = data.myNode.getChildren().values();
            for (CallTree.CallTreeNode value : values) {
                queue.add(new Data(State.enter, value));
            }
        }
        List filtered = ContainerUtil.filter(counters.getChildren().values(), node -> node.getSelfWeight().getCnt() > 0);
        this.myFlat.addAll(filtered);
        this.myFlat.sort(new FlatNodesComparator());
    }

    public void postProcess(int gcTicks, int unknownTicks, int idleTicks, Map<String, V8TickProcessor.CodeType> codeTypeMap, ThrowableConvertor<Long, String, IOException> convertor, int maxStackSize) throws IOException {
        this.myMaxStackSize = maxStackSize;
        ProgressManager.progress((String)NodeJSBundle.message("progress.text.calculating.total.weights.calls", new Object[0]));
        this.computeTotalWeights();
        CallTreeNodeComparator comparator = new CallTreeNodeComparator();
        this.myBottomUpRoot = this.createStructuredStatisticsByProfile(this.myBottomUpTree.getRoot(), convertor, comparator);
        this.correctBottomUpPercentOfParent();
        this.myTopDownRoot = this.createStructuredStatisticsByProfile(this.myTopDownTree.getRoot(), convertor, comparator);
        ProgressManager.progress((String)NodeJSBundle.message("progress.text.creating.top.calls.data", new Object[0]));
        this.myFlatTopCallsRoot = this.createFlat(gcTicks, unknownTicks, codeTypeMap, convertor);
        this.myGcTicks = gcTicks;
        this.myUnaccountedTicks = unknownTicks;
        this.myIdleTicks = idleTicks;
    }

    private void correctBottomUpPercentOfParent() {
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        List<V8ProfileLine> topLevel = this.myBottomUpRoot.getChildren();
        for (V8ProfileLine line : topLevel) {
            queue.add(Pair.create((Object)line, (Object)this.myNumTicks));
        }
        while (!queue.isEmpty()) {
            V8ProfileLine line;
            Pair current = (Pair)queue.removeFirst();
            line = (V8ProfileLine)current.getFirst();
            line.setTotalTensPercent(V8Utils.tensPercent(line.getTotalTicks(), (Integer)current.getSecond()));
            for (V8ProfileLine childLine : line.getChildren()) {
                queue.add(Pair.create((Object)childLine, (Object)line.getTotalTicks()));
            }
        }
    }

    public CallTree getTopDownTree() {
        return this.myTopDownTree;
    }

    public CallTree getBottomUpTree() {
        return this.myBottomUpTree;
    }

    public V8ProfileLine getBottomUpRoot() {
        return this.myBottomUpRoot;
    }

    public V8ProfileLine getTopDownRoot() {
        return this.myTopDownRoot;
    }

    public FlatTopCalls getFlatTopCallsRoot() {
        return this.myFlatTopCallsRoot;
    }

    public CodeMap.CodeEntry addLibrary(String name, BigInteger start, BigInteger end) {
        CodeMap.CodeEntry entry = new CodeMap.CodeEntry(end.subtract(start).intValue(), name);
        this.myCodeMap.addLibrary(start, entry);
        return entry;
    }

    public CodeMap.CodeEntry addStaticCode(String name, BigInteger start, BigInteger end) {
        CodeMap.CodeEntry entry = new CodeMap.CodeEntry(end.subtract(start).intValue(), name);
        this.myCodeMap.addStaticCode(start, entry);
        return entry;
    }

    public CodeMap.DynamicCodeEntry addCode(String type, String name, BigInteger start, int size) {
        CodeMap.DynamicCodeEntry entry = new CodeMap.DynamicCodeEntry(size, name, type);
        this.myCodeMap.addCode(start, entry);
        return entry;
    }

    public CodeMap.DynamicFuncCodeEntry addFuncCode(String type, String name, BigInteger start, int size, BigInteger funcAddress, CodeState state) {
        CodeMap.DynamicCodeEntry func = this.myCodeMap.findDynamicByStart(funcAddress);
        if (func == null) {
            func = new CodeMap.FunctionEntry(0, name);
            this.myCodeMap.addCode(funcAddress, func);
        } else if (!func.getName().equals(name)) {
            this.myCodeMap.editName(func, name);
        }
        CodeMap.DynamicCodeEntry entry = this.myCodeMap.findDynamicByStart(start);
        if (entry instanceof CodeMap.DynamicFuncCodeEntry) {
            CodeMap.DynamicFuncCodeEntry funcCodeEntry = (CodeMap.DynamicFuncCodeEntry)entry;
            if (funcCodeEntry.getSize() == size && funcCodeEntry.getFunctionCodeEntry().getName().equals(func.getName())) {
                funcCodeEntry.setState(state);
            }
        } else {
            entry = new CodeMap.DynamicFuncCodeEntry(size, name, type, state, func);
            this.myCodeMap.addCode(start, entry);
        }
        return (CodeMap.DynamicFuncCodeEntry)entry;
    }

    public void moveCode(BigInteger from, BigInteger to) {
        if (!this.myCodeMap.moveCode(from, to)) {
            this.myCallback.onUnknownMove(from);
        }
    }

    public void deleteCode(BigInteger from) {
        if (!this.myCodeMap.deleteCode(from)) {
            this.myCallback.onUnknownDelete(from);
        }
    }

    public CodeMap.CodeEntry findEntry(BigInteger addr) {
        return this.myCodeMap.findEntry(addr);
    }

    public void moveFunc(BigInteger from, BigInteger to) {
        if (this.myCodeMap.findDynamicByStart(from) != null) {
            this.myCodeMap.moveCode(from, to);
        } else {
            this.myCallback.onUnknownMove(from);
        }
    }

    public void recordTick(List<Long> symbolicStack) {
        if (symbolicStack.isEmpty()) {
            ++this.myNumTicks;
            return;
        }
        Iterator<Long> iterator = symbolicStack.iterator();
        while (iterator.hasNext()) {
            Long id = iterator.next();
            if (id != 0L && id != 1L) continue;
            iterator.remove();
        }
        this.myBottomUpTree.addPath(symbolicStack);
        Collections.reverse(symbolicStack);
        this.myTopDownTree.addPath(symbolicStack);
        ++this.myNumTicks;
    }

    public List<Long> resolveAndFilterFuncs(List<BigInteger> stack) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < stack.size(); ++i) {
            BigInteger stackAddr = stack.get(i);
            CodeMap.CodeEntry entry = this.myCodeMap.findEntry(stackAddr);
            if (entry != null) {
                String name = entry.getName();
                Long code = this.myCodeMap.getStringCode(name);
                if (!this.myCallback.processFunction(name)) continue;
                result.add(code);
                continue;
            }
            if (i == stack.size() - 1 && stack.size() > 40) {
                result.add(2L);
                this.myCallback.processFunction(this.myCodeMap.getStringByCode(2L));
                continue;
            }
            result.add(1L);
            this.myCallback.onUnknownTick(stackAddr, i);
        }
        return result;
    }

    public CodeMap getCodeMap() {
        return this.myCodeMap;
    }

    @NotNull
    private FlatTopCalls createFlat(int gcTicks, int unknownTicks, Map<String, V8TickProcessor.CodeType> codeTypeMap, ThrowableConvertor<Long, String, IOException> convertor) throws IOException {
        CallTree.CallTreeNode fictive = new CallTree.CallTreeNode(-1L);
        for (CallTree.CallTreeNode node : this.myFlat) {
            fictive.getChildren().put(node.getName(), node);
        }
        V8ProfileLine flat = this.createStructuredStatisticsByProfile(fictive, convertor, new FlatNodesComparator());
        FlatTopCalls flatTopCalls = new FlatTopCalls();
        for (V8ProfileLine line : flat.getChildren()) {
            V8TickProcessor.CodeType codeType;
            String code = (String)convertor.convert((Object)line.getCall().getStringId());
            V8TickProcessor.CodeType codeType2 = codeType = code == null ? null : codeTypeMap.get(code);
            if (V8TickProcessor.CodeType.SHARED_LIB.equals((Object)codeType)) {
                flatTopCalls.getSharedLibraries().add(line);
                continue;
            }
            if (V8TickProcessor.CodeType.CPP.equals((Object)codeType)) {
                flatTopCalls.getCpp().add(line);
                continue;
            }
            flatTopCalls.getJavaScript().add(line);
        }
        V8ProfileLine gcLine = V8ProfileLine.createLine("", null, -1L);
        gcLine.setTotalTicks(gcTicks);
        gcLine.setTotalTensPercent((int)Math.round((double)gcTicks * 1000.0 / (double)this.myNumTicks));
        flatTopCalls.getGc().add(gcLine);
        V8ProfileLine unknownLine = V8ProfileLine.createLine("", null, -1L);
        unknownLine.setTotalTicks(unknownTicks);
        unknownLine.setTotalTensPercent((int)Math.round((double)unknownTicks * 1000.0 / (double)this.myNumTicks));
        flatTopCalls.getUnknown().add(unknownLine);
        FlatTopCalls flatTopCalls2 = flatTopCalls;
        if (flatTopCalls2 == null) {
            V8Profile.$$$reportNull$$$0(1);
        }
        return flatTopCalls2;
    }

    public V8ProfileLine createStructuredStatisticsByProfile(@NotNull CallTree.CallTreeNode root, ThrowableConvertor<Long, String, IOException> stringConvertor, Comparator<CallTree.CallTreeNode> comparator) throws IOException {
        if (root == null) {
            V8Profile.$$$reportNull$$$0(2);
        }
        V8ProfileLine rootLine = V8ProfileLine.createLine("", null, -1L);
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.create((Object)root, (Object)rootLine));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            CallTree.CallTreeNode node = (CallTree.CallTreeNode)pair.getFirst();
            V8ProfileLine line = (V8ProfileLine)pair.getSecond();
            Map<Long, CallTree.CallTreeNode> children = node.getChildren();
            ArrayList<CallTree.CallTreeNode> list = new ArrayList<CallTree.CallTreeNode>(children.values());
            list.sort(comparator);
            for (CallTree.CallTreeNode treeNode : list) {
                Long stringId = treeNode.getName();
                String code = (String)stringConvertor.convert((Object)stringId);
                V8ProfileLine profileLine = V8ProfileLine.createLine(code, line, stringId);
                int total = treeNode.getTotalWeight().getCnt();
                int self = treeNode.getSelfWeight().getCnt();
                profileLine.setTotalTicks(total);
                profileLine.setSelfTicks(self);
                profileLine.setTotalTensPercent(V8Utils.tensPercent(total, this.myNumTicks));
                profileLine.setSelfTensPercent(V8Utils.tensPercent(self, this.myNumTicks));
                queue.add(Pair.create((Object)treeNode, (Object)profileLine));
            }
        }
        return rootLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8Profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8Profile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFlat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStructuredStatisticsByProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlatNodesComparator
    implements Comparator<CallTree.CallTreeNode> {
        private FlatNodesComparator() {
        }

        @Override
        public int compare(CallTree.CallTreeNode o1, CallTree.CallTreeNode o2) {
            int selfCompare = Integer.compare(o2.getSelfWeight().getCnt(), o1.getSelfWeight().getCnt());
            if (selfCompare != 0) {
                return selfCompare;
            }
            int totalCompare = Integer.compare(o2.getTotalWeight().getCnt(), o1.getTotalWeight().getCnt());
            if (totalCompare != 0) {
                return totalCompare;
            }
            return o2.getName().compareTo(o1.getName());
        }
    }

    public static class CallTreeNodeComparator
    implements Comparator<CallTree.CallTreeNode> {
        @Override
        public int compare(CallTree.CallTreeNode o1, CallTree.CallTreeNode o2) {
            int total = Integer.compare(o2.getTotalWeight().getCnt(), o1.getTotalWeight().getCnt());
            if (total != 0) {
                return total;
            }
            int self = Integer.compare(o2.getSelfWeight().getCnt(), o1.getSelfWeight().getCnt());
            if (self != 0) {
                return self;
            }
            return o2.getName().compareTo(o1.getName());
        }
    }

    public static enum Operation {
        move(0),
        delete(1),
        tick(2);

        private final int myCode;

        private Operation(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }

    private static class Data {
        private final State myState;
        private final CallTree.CallTreeNode myNode;

        Data(State state, CallTree.CallTreeNode node) {
            this.myState = state;
            this.myNode = node;
        }
    }

    private static enum State {
        enter,
        exit,
        root;

    }
}

