/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MochaRunSettingsSerializationUtil {
    private static final String NODE_INTERPRETER__KEY = "node-interpreter";
    private static final String NODE_OPTIONS__KEY = "node-options";
    private static final String MOCHA_PACKAGE___KEY = "mocha-package";
    private static final String WORKING_DIRECTORY__KEY = "working-directory";
    private static final String PASS_PARENT_ENV__KEY = "pass-parent-env";
    private static final String UI__KEY = "ui";
    private static final String EXTRA_MOCHA_OPTIONS__KEY = "extra-mocha-options";
    private static final String TEST_KIND__KEY = "test-kind";
    private static final String TEST_DIRECTORY__KEY = "test-directory";
    private static final String RECURSIVE__KEY = "recursive";
    private static final String TEST_FILE_PATTERN__KEY = "test-pattern";
    private static final String TEST_FILE__KEY = "test-file";
    private static final String TEST_NAMES__KEY = "test-names";
    private static final String TEST_NAME__KEY = "name";

    private MochaRunSettingsSerializationUtil() {
    }

    @NotNull
    public static MochaRunSettings readFromXml(@NotNull Element parent) {
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(0);
        }
        MochaRunSettings.Builder builder = new MochaRunSettings.Builder();
        String interpreterRefName = MochaRunSettingsSerializationUtil.readTagNullable(parent, NODE_INTERPRETER__KEY);
        builder.setInterpreterRef(NodeJsInterpreterRef.create((String)StringUtil.notNullize((String)interpreterRefName)));
        String nodeOptions = MochaRunSettingsSerializationUtil.readTag(parent, NODE_OPTIONS__KEY);
        builder.setNodeOptions(nodeOptions);
        String pkg = MochaRunSettingsSerializationUtil.readTagNullable(parent, MOCHA_PACKAGE___KEY);
        if (pkg != null) {
            builder.setMochaPackage(MochaUtil.PACKAGE_DESCRIPTOR.createPackage(pkg));
        }
        String workingDirPath = MochaRunSettingsSerializationUtil.readTag(parent, WORKING_DIRECTORY__KEY);
        builder.setWorkingDir(FileUtil.toSystemDependentName((String)workingDirPath));
        EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)parent);
        String passParentEnvStr = MochaRunSettingsSerializationUtil.readTag(parent, PASS_PARENT_ENV__KEY);
        if (StringUtil.isNotEmpty((String)passParentEnvStr)) {
            envData = EnvironmentVariablesData.create((Map)envData.getEnvs(), (boolean)Boolean.parseBoolean(passParentEnvStr));
        }
        builder.setEnvData(envData);
        builder.setUi(MochaRunSettingsSerializationUtil.readTag(parent, UI__KEY));
        String extraMochaOptions = MochaRunSettingsSerializationUtil.readTag(parent, EXTRA_MOCHA_OPTIONS__KEY);
        builder.setExtraMochaOptions(extraMochaOptions);
        MochaTestKind testKind = MochaRunSettingsSerializationUtil.deserializeTestKind(MochaRunSettingsSerializationUtil.readTag(parent, TEST_KIND__KEY));
        builder.setTestKind(testKind);
        if (MochaTestKind.DIRECTORY == testKind) {
            String testDirPath = MochaRunSettingsSerializationUtil.readTag(parent, TEST_DIRECTORY__KEY);
            builder.setTestDirPath(FileUtil.toSystemDependentName((String)testDirPath));
            String recursiveStr = MochaRunSettingsSerializationUtil.readTag(parent, RECURSIVE__KEY);
            builder.setRecursive(Boolean.parseBoolean(recursiveStr));
        } else if (MochaTestKind.PATTERN == testKind) {
            builder.setTestFilePattern(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)MochaRunSettingsSerializationUtil.readTag(parent, TEST_FILE_PATTERN__KEY))));
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            builder.setTestFilePath(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)MochaRunSettingsSerializationUtil.readTag(parent, TEST_FILE__KEY))));
            if (MochaTestKind.SUITE == testKind) {
                builder.setSuiteNames(MochaRunSettingsSerializationUtil.readTestNames(parent));
            } else if (MochaTestKind.TEST == testKind) {
                builder.setTestNames(MochaRunSettingsSerializationUtil.readTestNames(parent));
            }
        }
        MochaRunSettings mochaRunSettings = builder.build();
        if (mochaRunSettings == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(1);
        }
        return mochaRunSettings;
    }

    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(2);
        }
        if ((testNamesElement = parent.getChild(TEST_NAMES__KEY)) == null) {
            return Collections.emptyList();
        }
        return JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TEST_NAME__KEY);
    }

    @NotNull
    private static MochaTestKind deserializeTestKind(@Nullable String testKindStr) {
        MochaTestKind mochaTestKind;
        try {
            mochaTestKind = MochaTestKind.valueOf(testKindStr);
        }
        catch (Exception ignored) {
            MochaTestKind mochaTestKind2 = MochaTestKind.DIRECTORY;
            if (mochaTestKind2 == null) {
                MochaRunSettingsSerializationUtil.$$$reportNull$$$0(4);
            }
            return mochaTestKind2;
        }
        if (mochaTestKind == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(3);
        }
        return mochaTestKind;
    }

    @NotNull
    private static String readTag(@NotNull Element parent, @NotNull String tagName) {
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(5);
        }
        if (tagName == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.notNullize((String)MochaRunSettingsSerializationUtil.readTagNullable(parent, tagName));
        if (string == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String readTagNullable(@NotNull Element parent, @NotNull String tagName) {
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(8);
        }
        if (tagName == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(9);
        }
        Element child = parent.getChild(tagName);
        String value = null;
        if (child != null) {
            value = child.getText();
        }
        return value;
    }

    public static void writeToXml(@NotNull Element parent, @NotNull MochaRunSettings runSettings) {
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(10);
        }
        if (runSettings == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(11);
        }
        NodeJsInterpreterRef interpreterRef2 = runSettings.getInterpreterRef();
        MochaRunSettingsSerializationUtil.writeTag(parent, NODE_INTERPRETER__KEY, interpreterRef2.getReferenceName());
        MochaRunSettingsSerializationUtil.writeTag(parent, NODE_OPTIONS__KEY, runSettings.getNodeOptions());
        if (runSettings.getMochaPackage() != null) {
            MochaRunSettingsSerializationUtil.writeTag(parent, MOCHA_PACKAGE___KEY, runSettings.getMochaPackage().getSystemIndependentPath());
        }
        String workingDirPath = FileUtil.toSystemIndependentName((String)runSettings.getWorkingDir());
        MochaRunSettingsSerializationUtil.writeTag(parent, WORKING_DIRECTORY__KEY, workingDirPath);
        MochaRunSettingsSerializationUtil.writeTag(parent, PASS_PARENT_ENV__KEY, String.valueOf(runSettings.getEnvData().isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal((Element)parent, (Map)runSettings.getEnvData().getEnvs());
        MochaRunSettingsSerializationUtil.writeTag(parent, UI__KEY, runSettings.getUi());
        MochaRunSettingsSerializationUtil.writeTag(parent, EXTRA_MOCHA_OPTIONS__KEY, runSettings.getExtraMochaOptions());
        MochaTestKind testKind = runSettings.getTestKind();
        MochaRunSettingsSerializationUtil.writeTag(parent, TEST_KIND__KEY, testKind.name());
        if (MochaTestKind.DIRECTORY == testKind) {
            MochaRunSettingsSerializationUtil.writeTag(parent, TEST_DIRECTORY__KEY, FileUtil.toSystemIndependentName((String)runSettings.getTestDirPath()));
            MochaRunSettingsSerializationUtil.writeTag(parent, RECURSIVE__KEY, String.valueOf(runSettings.isRecursive()));
        } else if (MochaTestKind.PATTERN == testKind) {
            MochaRunSettingsSerializationUtil.writeTag(parent, TEST_FILE_PATTERN__KEY, FileUtil.toSystemIndependentName((String)runSettings.getTestFilePattern()));
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            MochaRunSettingsSerializationUtil.writeTag(parent, TEST_FILE__KEY, FileUtil.toSystemIndependentName((String)runSettings.getTestFilePath()));
            if (MochaTestKind.SUITE == testKind) {
                MochaRunSettingsSerializationUtil.writeTestNames(parent, runSettings.getSuiteNames());
            } else if (MochaTestKind.TEST == testKind) {
                MochaRunSettingsSerializationUtil.writeTestNames(parent, runSettings.getTestNames());
            }
        }
    }

    private static void writeTestNames(@NotNull Element parent, @NotNull List<String> testNames) {
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(12);
        }
        if (testNames == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(13);
        }
        if (!testNames.isEmpty()) {
            Element testNamesElement = new Element(TEST_NAMES__KEY);
            JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TEST_NAME__KEY, testNames);
            parent.addContent(testNamesElement);
        }
    }

    private static void writeTag(@NotNull Element parent, @NotNull String tagName, @NotNull String value) {
        if (parent == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(14);
        }
        if (tagName == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(15);
        }
        if (value == null) {
            MochaRunSettingsSerializationUtil.$$$reportNull$$$0(16);
        }
        Element element = new Element(tagName);
        element.setText(value);
        parent.addContent(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil";
                break;
            }
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromXml";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeTestKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromXml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readTag";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readTagNullable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeToXml";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeTestNames";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

