/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebuggableRunProfileStateSync;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testing.JSTestRunnerUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.coverage.MochaCoverageRunState;
import com.jetbrains.nodejs.mocha.execution.MochaConsoleProperties;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunProfileState
extends NodeLocalDebuggableRunProfileStateSync {
    private final Project myProject;
    private final MochaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnv;
    private final NodePackage myMochaPackage;
    private final MochaRunSettings myRunSettings;
    private final MochaCoverageRunState myCoverageRunState;
    private List<List<String>> myRerunActionFailedTests;

    public MochaRunProfileState(@NotNull Project project, @NotNull MochaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment env, @NotNull NodePackage mochaPackage, @NotNull MochaRunSettings runSettings) {
        if (project == null) {
            MochaRunProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            MochaRunProfileState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            MochaRunProfileState.$$$reportNull$$$0(2);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(3);
        }
        if (runSettings == null) {
            MochaRunProfileState.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnv = env;
        this.myMochaPackage = mochaPackage;
        this.myRunSettings = runSettings;
        this.myCoverageRunState = MochaCoverageRunState.create(env, this.myMochaPackage, runSettings);
    }

    @NotNull
    protected ExecutionResult executeSync(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLineForTestTools();
        NodeCommandLineUtil.configureCommandLine((GeneralCommandLine)commandLine, (CommandLineDebugConfigurator)configurator, (NodeJsInterpreter)interpreter, debugMode -> this.configureCommandLine(commandLine, interpreter, (boolean)debugMode));
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        MochaConsoleProperties consoleProperties = this.myRunConfiguration.createTestConsoleProperties(this.myEnv.getExecutor(), this.myRunSettings.getUi(), NodeCommandLineUtil.shouldUseTerminalConsole((ProcessHandler)processHandler));
        ConsoleView consoleView = this.createSMTRunnerConsoleView(commandLine.getWorkDirectory(), consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{consoleProperties.createRerunFailedTestsAction(consoleView)});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            MochaRunProfileState.$$$reportNull$$$0(5);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ConsoleView createSMTRunnerConsoleView(@Nullable File workingDirectory, @NotNull MochaConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            MochaRunProfileState.$$$reportNull$$$0(6);
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)consoleProperties.getTestFrameworkName(), (TestConsoleProperties)consoleProperties);
        consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        for (Filter filter : consoleProperties.getStackTrackFilters()) {
            consoleView.addMessageFilter(filter);
        }
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            MochaRunProfileState.$$$reportNull$$$0(7);
        }
        return baseTestsOutputConsoleView;
    }

    private void configureCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter, boolean debugMode) throws ExecutionException {
        String grepPattern;
        if (commandLine == null) {
            MochaRunProfileState.$$$reportNull$$$0(8);
        }
        if (interpreter == null) {
            MochaRunProfileState.$$$reportNull$$$0(9);
        }
        ArrayList nodeOptions = new ArrayList(commandLine.getParametersList().getParameters());
        commandLine.getParametersList().clearAll();
        commandLine.setCharset(StandardCharsets.UTF_8);
        if (!StringUtil.isEmptyOrSpaces((String)this.myRunSettings.getWorkingDir())) {
            commandLine.withWorkDirectory(this.myRunSettings.getWorkingDir());
        }
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)commandLine);
        NodeCommandLineUtil.prependNodeDirToPATH((GeneralCommandLine)commandLine, (NodeJsInterpreter)interpreter);
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        boolean separateMochaArgs = false;
        if (this.myCoverageRunState != null) {
            separateMochaArgs = this.myCoverageRunState.configure(commandLine, interpreter);
        }
        if (this.myMochaPackage instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)this.myMochaPackage).addYarnRunToCommandLine(commandLine, this.myProject, interpreter, null);
        } else {
            commandLine.addParameter(MochaRunProfileState.getMochaMainJsFile(interpreter, this.myMochaPackage).getAbsolutePath());
        }
        if (MochaUtil.isVueCliService(this.myMochaPackage)) {
            commandLine.addParameter("test:unit");
        }
        commandLine.addParameters(nodeOptions);
        commandLine.addParameters(ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim()));
        if (separateMochaArgs) {
            commandLine.addParameter("--");
        }
        List extraMochaOptionList = ParametersListUtil.parse((String)this.myRunSettings.getExtraMochaOptions().trim());
        commandLine.addParameters(extraMochaOptionList);
        if (debugMode) {
            commandLine.addParameter("--timeout");
            commandLine.addParameter("0");
        }
        commandLine.addParameter("--ui");
        commandLine.addParameter(this.myRunSettings.getUi());
        commandLine.addParameter("--reporter");
        commandLine.addParameter(MochaRunProfileState.getMochaReporterFile().getAbsolutePath());
        MochaTestKind testKind = this.myRunSettings.getTestKind();
        if (MochaTestKind.DIRECTORY == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestDirPath()));
            if (this.myRunSettings.isRecursive()) {
                commandLine.addParameter("--recursive");
            }
        } else if (MochaTestKind.PATTERN == testKind) {
            String pattern = this.myRunSettings.getTestFilePattern();
            if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
                commandLine.addParameters(ParametersList.parse((String)NodeInterpreterUtil.toRemoteName((String)pattern, (NodeJsInterpreter)interpreter)));
            }
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestFilePath()));
        }
        if ((grepPattern = this.getGrepPattern(testKind)) != null) {
            commandLine.addParameter("--grep");
            commandLine.addParameter(grepPattern);
        }
    }

    @Nullable
    private String getGrepPattern(@NotNull MochaTestKind testKind) {
        if (testKind == null) {
            MochaRunProfileState.$$$reportNull$$$0(10);
        }
        if (this.myRerunActionFailedTests != null) {
            return JSTestRunnerUtil.getTestsPattern(this.myRerunActionFailedTests, (boolean)false);
        }
        if (MochaTestKind.SUITE == testKind) {
            return JSTestRunnerUtil.buildTestNamesPattern((Project)this.myProject, (String)this.myRunSettings.getTestFilePath(), this.myRunSettings.getSuiteNames(), (boolean)true);
        }
        if (MochaTestKind.TEST == testKind) {
            return JSTestRunnerUtil.buildTestNamesPattern((Project)this.myProject, (String)this.myRunSettings.getTestFilePath(), this.myRunSettings.getTestNames(), (boolean)false);
        }
        return null;
    }

    @NotNull
    public MochaRunSettings getRunSettings() {
        MochaRunSettings mochaRunSettings = this.myRunSettings;
        if (mochaRunSettings == null) {
            MochaRunProfileState.$$$reportNull$$$0(11);
        }
        return mochaRunSettings;
    }

    @Nullable
    public MochaCoverageRunState getCoverageRunState() {
        return this.myCoverageRunState;
    }

    public void setFailedTests(@NotNull List<List<String>> rerunActionFailedTests) {
        if (rerunActionFailedTests == null) {
            MochaRunProfileState.$$$reportNull$$$0(12);
        }
        this.myRerunActionFailedTests = rerunActionFailedTests;
    }

    @NotNull
    public static File getMochaMainJsFile(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage mochaPackage) throws ExecutionException {
        File mainJsFile;
        String packageName;
        if (interpreter == null) {
            MochaRunProfileState.$$$reportNull$$$0(13);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(14);
        }
        if ("electron-mocha".equals(packageName = mochaPackage.getName()) && (mainJsFile = interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron() ? new File(mochaPackage.getSystemDependentPath(), "index.js") : new File(mochaPackage.getSystemDependentPath(), "bin" + File.separator + "electron-mocha")).isFile()) {
            File file = mainJsFile;
            if (file == null) {
                MochaRunProfileState.$$$reportNull$$$0(15);
            }
            return file;
        }
        ArrayList<Pair> binaries = new ArrayList<Pair>();
        if (MochaUtil.isVueCliService(mochaPackage)) {
            binaries.add(Pair.create((Object)"vue-cli-service", (Object)"bin/vue-cli-service.js"));
        } else if ("mocha-webpack".equals(packageName)) {
            binaries.add(Pair.create((Object)"mocha-webpack", (Object)"bin/mocha-webpack"));
        } else {
            binaries.add(Pair.create((Object)PackageJsonUtil.guessDefaultBinaryNameOfDependency((NodePackage)mochaPackage), null));
        }
        binaries.add(Pair.create((Object)"mocha", (Object)"bin/mocha"));
        for (Pair binary : binaries) {
            File mainJsFile2 = mochaPackage.findBinFile((String)binary.first, (String)binary.second);
            if (mainJsFile2 == null || !mainJsFile2.isFile()) continue;
            File file = mainJsFile2;
            if (file == null) {
                MochaRunProfileState.$$$reportNull$$$0(16);
            }
            return file;
        }
        throw new ExecutionException(NodeJSBundle.message("rc.mocha.package_bin_file_not_found.message", packageName));
    }

    @NotNull
    private static File getMochaReporterFile() throws ExecutionException {
        File file;
        try {
            file = NodeJsCodeLocator.getFileRelativeToJsDir("mocha-intellij/lib/mochaIntellijReporter.js");
        }
        catch (IOException e) {
            throw new ExecutionException(NodeJSBundle.message("rc.mocha.intellij_mocha_reporter_not_found.message", new Object[0]), (Throwable)e);
        }
        if (file == null) {
            MochaRunProfileState.$$$reportNull$$$0(17);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunActionFailedTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executeSync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSMTRunnerConsoleView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaMainJsFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaReporterFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSMTRunnerConsoleView";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGrepPattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMochaMainJsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

