/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.jetbrains.nodejs.NodeJSBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MochaCoveragePackageNotFoundException
extends ExecutionException
implements HyperlinkListener {
    private final ExecutionEnvironment myEnv;
    private final NodeJsInterpreter myInterpreter;
    private final String myInstallWorkingDirectory;
    private final boolean mySaveDev;

    private MochaCoveragePackageNotFoundException(@NotNull @Nls String reason, @NotNull ExecutionEnvironment env, @NotNull NodeJsInterpreter interpreter, @NotNull String installWorkingDirectory, boolean saveDev) {
        if (reason == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(0);
        }
        if (env == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(1);
        }
        if (interpreter == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(2);
        }
        if (installWorkingDirectory == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(3);
        }
        super(reason);
        this.myEnv = env;
        this.myInterpreter = interpreter;
        this.myInstallWorkingDirectory = installWorkingDirectory;
        this.mySaveDev = saveDev;
    }

    public static MochaCoveragePackageNotFoundException create(@NotNull Project project, @NotNull NodePackage mochaPackage, @NotNull ExecutionEnvironment env, @NotNull NodeJsInterpreter interpreter, @NotNull String workingDirectory) {
        String installWorkingDirectory;
        boolean saveDev;
        String mochaRootPath;
        if (project == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(4);
        }
        if (mochaPackage == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(5);
        }
        if (env == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(6);
        }
        if (interpreter == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(7);
        }
        if (workingDirectory == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(8);
        }
        if (new File(mochaRootPath = PathUtil.getParentPath((String)PathUtil.getParentPath((String)mochaPackage.getSystemDependentPath())), "package.json").isFile()) {
            saveDev = true;
            installWorkingDirectory = mochaRootPath;
        } else if (new File(workingDirectory, "package.json").isFile()) {
            saveDev = true;
            installWorkingDirectory = workingDirectory;
        } else {
            saveDev = false;
            installWorkingDirectory = mochaRootPath;
        }
        String text = NodeJSBundle.message("mocha.coverage.cannot_find_coverage_package.text", MochaCoveragePackageNotFoundException.createNpmInstallLink(project, saveDev));
        return new MochaCoveragePackageNotFoundException(text, env, interpreter, installWorkingDirectory, saveDev);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nls
    private static String createNpmInstallLink(@NotNull Project project, boolean saveDev) {
        if (project == null) {
            MochaCoveragePackageNotFoundException.$$$reportNull$$$0(9);
        }
        NodePackageRef npmPkgRef = NpmManager.getInstance((Project)project).getPackageRef();
        @Nls ArrayList commandParts = ContainerUtil.newArrayList((Object[])new String[]{NpmManager.getNpmPackagePresentableName((NodePackageRef)npmPkgRef), NpmCommand.ADD.getCliOption(NpmUtil.isYarnAlikePackageRef((NodePackageRef)npmPkgRef)), "nyc"});
        ContainerUtil.addIfNotNull((Collection)commandParts, saveDev ? NpmUtil.getInstallSaveOption((NodePackageRef)npmPkgRef, (boolean)true) : null);
        return HtmlChunk.link((String)"", (String)StringUtil.join((Collection)commandParts, (String)" ")).toString();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Project project = this.myEnv.getProject();
            NpmPackageInstallerLight installerLight = (NpmPackageInstallerLight)ApplicationManager.getApplication().getService(NpmPackageInstallerLight.class);
            NodePackageRef npmPkgRef = NpmManager.getInstance((Project)project).getPackageRef();
            installerLight.installPackage(project, this.myInterpreter, "nyc", null, new File(this.myInstallWorkingDirectory), new PackageManagementService.Listener(){

                public void operationStarted(String packageName) {
                }

                public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (errorDescription == null) {
                            ExecutionUtil.restart((ExecutionEnvironment)MochaCoveragePackageNotFoundException.this.myEnv);
                        }
                    });
                }
            }, this.mySaveDev ? NpmUtil.getInstallSaveOption((NodePackageRef)npmPkgRef, (boolean)true) : "");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installWorkingDirectory";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/mocha/coverage/MochaCoveragePackageNotFoundException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createNpmInstallLink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

