/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MochaUtil {
    public static final String UI_BDD = "bdd";
    public static final String UI_TDD = "tdd";
    public static final String UI_EXPORTS = "exports";
    public static final String UI_QUNIT = "qunit";
    public static final String UI_REQUIRE = "require";
    public static final String UI_MOCHA_TYPESCRIPT = "mocha-typescript";
    public static final String MOCHA_COFFEE_COMPILER = "--compilers coffee:coffee-script/register";
    public static final String NODE_PACKAGE_NAME = "mocha";
    private static final String VUE_CLI_SERVICE = "@vue/cli-service";
    public static final String ELECTRON_MOCHA_PACKAGE_NAME = "electron-mocha";
    public static final String MOCHA_WEBPACK_PACKAGE_NAME = "mocha-webpack";
    public static final NodePackageDescriptor PACKAGE_DESCRIPTOR = new NodePackageDescriptor((List)ContainerUtil.newArrayList((Object[])new String[]{"mocha-webpack", "electron-mocha", "mocha", "@vue/cli-service"}), Collections.singletonMap("@vue/cli-service", "@vue/cli-plugin-unit-mocha"), null);
    private static final String MOCHA_PACKAGE_DIR__KEY = "nodejs.mocha.mocha_node_package_dir";

    private MochaUtil() {
    }

    @NotNull
    public static List<String> getMochaUiList() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{UI_BDD, UI_TDD, UI_EXPORTS, UI_QUNIT, UI_REQUIRE, UI_MOCHA_TYPESCRIPT});
        if (arrayList == null) {
            MochaUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public static String findUi(@NotNull JSFile file) {
        JSTestFileType testFileType;
        if (file == null) {
            MochaUtil.$$$reportNull$$$0(1);
        }
        if ((testFileType = file.getTestFileType()) == JSTestFileType.JASMINE) {
            return UI_BDD;
        }
        if (testFileType == JSTestFileType.QUNIT) {
            return UI_QUNIT;
        }
        if (testFileType == JSTestFileType.TDD) {
            MochaTddFileStructure structure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(file);
            if (structure.hasMochaTypeScriptDeclarations()) {
                return UI_MOCHA_TYPESCRIPT;
            }
            return UI_TDD;
        }
        return null;
    }

    @NotNull
    public static NodePackage getMochaPackage(@NotNull Project project) {
        if (project == null) {
            MochaUtil.$$$reportNull$$$0(2);
        }
        String packageDir = PropertiesComponent.getInstance((Project)project).getValue(MOCHA_PACKAGE_DIR__KEY);
        NodePackage nodePackage = PACKAGE_DESCRIPTOR.createPackage(StringUtil.notNullize((String)packageDir));
        if (nodePackage == null) {
            MochaUtil.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    public static void setMochaPackage(@NotNull Project project, @NotNull NodePackage mochaPackage) {
        if (project == null) {
            MochaUtil.$$$reportNull$$$0(4);
        }
        if (mochaPackage == null) {
            MochaUtil.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance((Project)project).setValue(MOCHA_PACKAGE_DIR__KEY, mochaPackage.getSystemIndependentPath());
    }

    public static boolean isVueCliService(@NotNull NodePackage pkg) {
        if (pkg == null) {
            MochaUtil.$$$reportNull$$$0(6);
        }
        return pkg.nameMatches(VUE_CLI_SERVICE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/MochaUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaUiList";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/MochaUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaPackage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMochaPackage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMochaPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVueCliService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

