/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.library;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeTypingsDownloadSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsStartupActivity
implements StartupActivity.Background {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(0);
        }
        NodeJsStartupActivity.reconfigureCodeLibraryIfNeeded(project);
    }

    private static void reconfigureCodeLibraryIfNeeded(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(1);
        }
        ReadAction.run(() -> {
            if (!project.isDisposed()) {
                NodeJsStartupActivity.reconfigureNodeCoreLibraryIfFilesMissing(project);
            }
        });
    }

    private static void reconfigureNodeCoreLibraryIfFilesMissing(@NotNull Project project) {
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(2);
        }
        if (NodeJsStartupActivity.isNodeCoreReconfigurationNeeded(NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersion((Project)project))) {
            List roots = NodeCoreLibraryManager.getInstance((Project)project).getAssociatedRoots();
            NodeJsStartupActivity.doReconfigure(project, roots);
        }
    }

    private static boolean isNodeCoreReconfigurationNeeded(@Nullable NodeCoreLibraryConfigurator.NodeLibraryVersion version) {
        if (version == null) {
            return false;
        }
        File coreModulesSrcDir = NodeCoreLibraryConfigurator.getCoreModulesSrcDir((SemVer)version.getNodeVersion());
        return !coreModulesSrcDir.isDirectory() || NodeTypingsDownloadSession.isReconfigurationNeeded((NodeCoreLibraryConfigurator.NodeLibraryVersion)version);
    }

    private static void doReconfigure(@NotNull Project project, @NotNull List<VirtualFile> rootsToAssociateWith) {
        NodeJsInterpreter interpreter;
        if (project == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(3);
        }
        if (rootsToAssociateWith == null) {
            NodeJsStartupActivity.$$$reportNull$$$0(4);
        }
        if ((interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter()) instanceof NodeJsLocalInterpreter) {
            interpreter.provideCachedVersionOrFetch(version -> {
                if (version != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        NodeCoreLibraryConfigurator configurator = NodeCoreLibraryConfigurator.getInstance((Project)project);
                        configurator.configureAndAssociateWith(interpreter, version, rootsToAssociateWith, null);
                    }, ModalityState.NON_MODAL, project.getDisposed());
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAssociateWith";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/library/NodeJsStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reconfigureCodeLibraryIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reconfigureNodeCoreLibraryIfFilesMissing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doReconfigure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

