/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.npmInit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.Filter;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NpmInitProjectGenerator
extends NpmPackageProjectGenerator {
    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings, @NotNull Module module) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(3);
        }
        super.generateProject(project, baseDir, settings, module);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> NpmManager.getInstance((Project)project).setPackageRef(settings.myPackageRef));
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(5);
        }
        super.postInstall(project, baseDir, workingDir).run();
        Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
            NodeJsInterpreter interpreter;
            VirtualFile packageJsonFile = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)baseDir);
            if (packageJsonFile != null) {
                PsiNavigationSupport.getInstance().createNavigatable(project, packageJsonFile, -1).navigate(true);
            }
            if ((interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter()) != null) {
                interpreter.provideCachedVersionOrFetch(version -> {
                    if (version != null) {
                        ApplicationManager.getApplication().invokeLater(() -> NodeCoreLibraryConfigurator.getInstance((Project)project).configureAndAssociateWithProject(interpreter, version, null));
                    }
                });
            }
        });
        if (runnable == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = NodeJSBundle.message("npm.init.generator.name", new Object[0]);
        if (string == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getDescription() {
        return NodeJSBundle.message("npm.init.generator.description", new Object[0]);
    }

    protected Filter @NotNull [] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(8);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(9);
        }
        if (Filter.EMPTY_ARRAY == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(10);
        }
        return Filter.EMPTY_ARRAY;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        String string;
        if (pkg == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(11);
        }
        try {
            string = NpmUtil.getValidNpmCliJsFilePath((NodePackage)pkg);
        }
        catch (ExecutionException e) {
            return "";
        }
        if (string == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(13);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(14);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(15);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(16);
        }
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(17);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(18);
        }
        if (settings == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(19);
        }
        String[] stringArray = new String[]{"init", "-y"};
        if (stringArray == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    protected String validateProjectPath(@NotNull String path) {
        String error;
        if (path == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(21);
        }
        if ((error = NodePackageUtil.validateNpmPackageName((String)PathUtil.getFileName((String)path))) != null) {
            return error;
        }
        return super.validateProjectPath(path);
    }

    @NotNull
    protected String packageName() {
        return "npm";
    }

    @NotNull
    protected String presentablePackageName() {
        String string = NpmUtil.getPackageManagerPackageFieldLabelText();
        if (string == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.emptyList();
        if (list == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(23);
        }
        return list;
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Nodejs.Nodejs;
    }

    @NotNull
    public ProjectGeneratorPeer<NpmPackageProjectGenerator.Settings> createPeer() {
        return new NpmPackageProjectGenerator.NpmPackageGeneratorPeer(){

            @NotNull
            protected NodePackageField createAndInitPackageField(@NotNull NodeJsInterpreterField interpreterField) {
                if (interpreterField == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodePackageField field = NpmUtil.createPackageManagerPackageField((NodeJsInterpreterField)interpreterField, (boolean)true);
                field.setSelectedRef(NodePackageRef.create((String)"npm"));
                NodePackageField nodePackageField = field;
                if (nodePackageField == null) {
                    1.$$$reportNull$$$0(1);
                }
                return nodePackageField;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreterField";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAndInitPackageField";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAndInitPackageField";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

