/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.boilerplate.express.ExpressAppSettings;
import com.jetbrains.nodejs.boilerplate.express.ExpressStylesheetEngine;
import com.jetbrains.nodejs.boilerplate.express.ExpressTemplateEngine;
import com.jetbrains.nodejs.util.ui.UIHelper;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class ExpressAppGeneratorPeerHelper {
    private static final Key<ExpressAppSettings> EXTRA_SETTINGS = Key.create((String)ExpressAppGeneratorPeerHelper.class.getName());
    public static final SemVer LATEST_VERSION = new SemVer("4.16.0", 4, 16, 0);
    private final ComboBox<ExpressTemplateEngine> myTemplateEngine = UIHelper.createCombobox(UIHelper.getUnavailableText());
    private final ComboBox<ExpressStylesheetEngine> myStylesheetEngine;
    private final JPanel myOptionsPanel;
    private SemVer myLatestVersion;

    ExpressAppGeneratorPeerHelper() {
        this.myTemplateEngine.setPrototypeDisplayValue((Object)ExpressTemplateEngine.NO_VIEW);
        this.myStylesheetEngine = UIHelper.createCombobox(UIHelper.getUnavailableText());
        this.myOptionsPanel = ExpressAppGeneratorPeerHelper.createOptionsPanel(this.myTemplateEngine, this.myStylesheetEngine);
        this.updateVersion(null);
    }

    @NotNull
    public JPanel getOptionsPanel() {
        JPanel jPanel = this.myOptionsPanel;
        if (jPanel == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(1);
        }
        settingsStep.addSettingsComponent((JComponent)this.myOptionsPanel);
    }

    @NotNull
    public NpmPackageProjectGenerator.Settings getSettings(@NotNull NpmPackageProjectGenerator.Settings settings) {
        if (settings == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(2);
        }
        SemVer version = ExpressAppGeneratorPeerHelper.getPackageVersion(settings);
        ExpressTemplateEngine templateEngine = (ExpressTemplateEngine)ObjectUtils.notNull((Object)((ExpressTemplateEngine)this.myTemplateEngine.getSelectedItem()), (Object)ExpressAppGeneratorPeerHelper.getDefaultTemplateEngine(version));
        ExpressStylesheetEngine cssEngine = (ExpressStylesheetEngine)ObjectUtils.notNull((Object)((ExpressStylesheetEngine)this.myStylesheetEngine.getSelectedItem()), (Object)ExpressStylesheetEngine.PLAIN_CSS);
        settings.putUserData(EXTRA_SETTINGS, (Object)new ExpressAppSettings(version, templateEngine, cssEngine));
        NpmPackageProjectGenerator.Settings settings2 = settings;
        if (settings2 == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(3);
        }
        return settings2;
    }

    public void setPackageField(@NotNull NodePackageField packageField) {
        if (packageField == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(4);
        }
        packageField.addSelectionListener(this::onPackageSelected);
        this.onPackageSelected(packageField.getSelected());
    }

    private void onPackageSelected(@Nullable NodePackage pkg) {
        if (pkg != null) {
            pkg.getVersionPromise(null).onProcessed(version -> this.updateVersion((SemVer)version));
        } else {
            this.updateVersion(null);
        }
    }

    private void updateVersion(@Nullable SemVer version) {
        if (Objects.equals(this.myLatestVersion, version)) {
            return;
        }
        this.myLatestVersion = version;
        if (version == null) {
            version = LATEST_VERSION;
        }
        ArrayList templates = ContainerUtil.newArrayList((Object[])new ExpressTemplateEngine[]{ExpressTemplateEngine.JADE, ExpressTemplateEngine.EJS});
        ArrayList stylesheets = ContainerUtil.newArrayList((Object[])new ExpressStylesheetEngine[]{ExpressStylesheetEngine.PLAIN_CSS, ExpressStylesheetEngine.STYLUS});
        if (version.isGreaterOrEqualThan(3, 0, 0)) {
            templates.add(ExpressTemplateEngine.HBS);
            templates.add(ExpressTemplateEngine.HOGAN);
            stylesheets.add(ExpressStylesheetEngine.LESS);
            stylesheets.add(ExpressStylesheetEngine.COMPASS);
        }
        if (version.isGreaterOrEqualThan(4, 16, 0)) {
            templates = ContainerUtil.newArrayList((Object[])ExpressTemplateEngine.values());
            templates.remove(ExpressTemplateEngine.JADE);
        } else if (version.isGreaterOrEqualThan(4, 15, 0)) {
            templates = ContainerUtil.newArrayList((Object[])ExpressTemplateEngine.values());
            templates.remove(ExpressTemplateEngine.JADE);
            templates.remove(ExpressTemplateEngine.NO_VIEW);
        }
        if (version.isGreaterOrEqualThan(4, 13, 0)) {
            stylesheets.add(ExpressStylesheetEngine.SASS);
        }
        SwingHelper.updateItems(this.myTemplateEngine, (List)templates, (Object)ExpressAppGeneratorPeerHelper.getDefaultTemplateEngine(version));
        SwingHelper.updateItems(this.myStylesheetEngine, (List)stylesheets, (Object)ExpressStylesheetEngine.PLAIN_CSS);
    }

    @NotNull
    private static ExpressTemplateEngine getDefaultTemplateEngine(@Nullable SemVer version) {
        ExpressTemplateEngine expressTemplateEngine = version == null || version.isGreaterOrEqualThan(4, 15, 0) ? ExpressTemplateEngine.PUG : ExpressTemplateEngine.JADE;
        if (expressTemplateEngine == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(5);
        }
        return expressTemplateEngine;
    }

    @NotNull
    static ExpressAppSettings getExpressSettings(@NotNull NpmPackageProjectGenerator.Settings settings) {
        if (settings == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(6);
        }
        ExpressAppSettings expressAppSettings = Objects.requireNonNull((ExpressAppSettings)settings.getUserData(EXTRA_SETTINGS));
        if (expressAppSettings == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(7);
        }
        return expressAppSettings;
    }

    @Nullable
    static SemVer getPackageVersion(@NotNull NpmPackageProjectGenerator.Settings settings) {
        if (settings == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(8);
        }
        Promise versionPromise = settings.myPackage.getVersionPromise(null);
        try {
            return (SemVer)versionPromise.blockingGet(5, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public ValidationInfo validate() {
        ExpressTemplateEngine templateEngine = (ExpressTemplateEngine)ObjectUtils.tryCast((Object)this.myTemplateEngine.getSelectedItem(), ExpressTemplateEngine.class);
        if (templateEngine == null) {
            return new ValidationInfo(NodeJSBundle.message("dialog.message.template.engine.unavailable", new Object[0]), this.myTemplateEngine);
        }
        ExpressStylesheetEngine stylesheetEngine = (ExpressStylesheetEngine)ObjectUtils.tryCast((Object)this.myStylesheetEngine.getSelectedItem(), ExpressStylesheetEngine.class);
        if (stylesheetEngine == null) {
            return new ValidationInfo(NodeJSBundle.message("dialog.message.stylesheet.engine.unavailable", new Object[0]), this.myStylesheetEngine);
        }
        return null;
    }

    @NotNull
    private static JPanel createOptionsPanel(@NotNull ComboBox<?> templateEngine, @NotNull ComboBox<?> cssEngine) {
        if (templateEngine == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(9);
        }
        if (cssEngine == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(10);
        }
        LabeledComponent<JComponent> templateLabeledComponent = ExpressAppGeneratorPeerHelper.createLabeledComponent(NodeJSBundle.message("express.generator.view.engine.label", new Object[0]), templateEngine);
        LabeledComponent<JComponent> cssLabeledComponent = ExpressAppGeneratorPeerHelper.createLabeledComponent(NodeJSBundle.message("express.generator.stylesheet.engine.label", new Object[0]), cssEngine);
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{templateLabeledComponent, cssLabeledComponent});
        ExpressAppGeneratorPeerHelper.setMaxPreferredWidth(templateEngine, cssEngine);
        JPanel optionsPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{templateLabeledComponent, Box.createVerticalStrut(JBUI.scale((int)4)), cssLabeledComponent});
        optionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)NodeJSBundle.message("express.generator.options.delimiter.name", new Object[0])));
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{Box.createVerticalStrut(JBUI.scale((int)10)), Box.createVerticalStrut(JBUI.scale((int)4)), optionsPanel});
        if (jPanel == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    private static void setMaxPreferredWidth(ComboBox<?> ... comboBoxes) {
        int maxWidth = 0;
        for (ComboBox<?> box : comboBoxes) {
            maxWidth = Math.max(maxWidth, box.getPreferredSize().width);
        }
        for (ComboBox<?> box : comboBoxes) {
            SwingHelper.setPreferredWidth(box, (int)maxWidth);
        }
    }

    @NotNull
    private static LabeledComponent<JComponent> createLabeledComponent(@NotNull @Nls String text, @NotNull JComponent comp) {
        if (text == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(12);
        }
        if (comp == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(13);
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(comp);
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)panel, (String)text);
        labeledComponent.setLabelLocation("West");
        LabeledComponent labeledComponent2 = labeledComponent;
        if (labeledComponent2 == null) {
            ExpressAppGeneratorPeerHelper.$$$reportNull$$$0(14);
        }
        return labeledComponent2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/ExpressAppGeneratorPeerHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateEngine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssEngine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPanel";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/ExpressAppGeneratorPeerHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTemplateEngine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabeledComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPackageField";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpressSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsPanel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLabeledComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

