/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve.impl;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlLinkUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public final class XhtmlFileInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.resolve.impl.XhtmlFileInfo");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    private final XmlFile myXhtmlFile;
    private final long myModificationStamp;
    private final Pair[] myPairs;
    private final List<StylesheetInfo> myStylesheetInfos;
    private String myPreferredStylesheetName;
    @NonNls
    public static final String DEFAULT_STYLESHEET_FILE_NAME = "css2default_.css";
    @NonNls
    private static final String _INTERNAL_DEFAULT_CSS_NAME = "css2default.css.txt";
    private boolean myUseAgentStylesheet;
    @NonNls
    private static final Pattern CSS_SUFFIX_PATTERN = Pattern.compile(".css(\\?.*)?$");
    @NonNls
    private static final String TEXT_CSS_TYPE = "text/css";

    private XhtmlFileInfo(@NotNull XmlFile xhtmlFile) {
        if (xhtmlFile == null) {
            XhtmlFileInfo.$$$reportNull$$$0(0);
        }
        this.myStylesheetInfos = new SmartList();
        this.myPreferredStylesheetName = null;
        this.myXhtmlFile = xhtmlFile;
        this.myModificationStamp = xhtmlFile.getModificationStamp();
        this.initStylesheets();
        this.myPairs = this.getPairs();
    }

    @Nullable
    private static CssStylesheet getPredefinedStylesheet(@NotNull Project project) {
        if (project == null) {
            XhtmlFileInfo.$$$reportNull$$$0(1);
        }
        return (CssStylesheet)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            String s = XhtmlFileInfo.loadDefaultCssContent();
            CssStylesheet stylesheet = s != null ? CssElementFactory.getInstance((Project)project).createStylesheet(s, (Language)CSSLanguage.INSTANCE) : null;
            return CachedValueProvider.Result.create((Object)stylesheet, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String loadDefaultCssContent() {
        InputStream stream = XhtmlFileInfo.class.getResourceAsStream(_INTERNAL_DEFAULT_CSS_NAME);
        if (stream == null) {
            LOG.error("Cannot open find internal default css file", new String[]{_INTERNAL_DEFAULT_CSS_NAME});
            return null;
        }
        InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            String string = FileUtil.loadTextAndClose((Reader)streamReader);
            return string;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                streamReader.close();
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private void initStylesheets() {
        this.myStylesheetInfos.clear();
        MyLinkTagProcessor processor = new MyLinkTagProcessor(this.myStylesheetInfos);
        HtmlLinkUtil.processLinks((XmlFile)this.myXhtmlFile, (Processor)processor);
        this.myPreferredStylesheetName = processor.myPreferredStylesheetName;
    }

    public static PsiElement[] gatherLinks(XmlFile xhtmlFile, boolean allMedias) {
        ArrayList result = new ArrayList();
        HtmlLinkUtil.processLinks((XmlFile)xhtmlFile, xmlTag -> {
            XhtmlFileInfo.processLinkTag(xmlTag, result, allMedias);
            return true;
        });
        return PsiUtilCore.toPsiElementArray(result);
    }

    @NotNull
    private static SmartList<String> getOriginalPathsFromSourceMap(@NotNull String json) {
        if (json == null) {
            XhtmlFileInfo.$$$reportNull$$$0(2);
        }
        SmartList result = new SmartList();
        try (JsonReaderEx reader = new JsonReaderEx((CharSequence)json);){
            reader.beginObject();
            while (reader.hasNext()) {
                if ("sources".equals(reader.nextName())) {
                    reader.beginArray();
                    while (reader.peek() != JsonToken.END_ARRAY) {
                        String s = reader.nextString().trim();
                        if (s.isEmpty()) continue;
                        result.add((Object)s);
                    }
                    break;
                }
                reader.skipValue();
            }
        }
        catch (JsonParseException | IllegalStateException throwable) {
            // empty catch block
        }
        SmartList smartList = result;
        if (smartList == null) {
            XhtmlFileInfo.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static boolean isSpecificMedia(@Nullable String mediaTypes) {
        if (mediaTypes == null) {
            return false;
        }
        for (String mediaType : StringUtil.split((String)mediaTypes, (String)",")) {
            if (!(mediaType = StringUtil.toUpperCase((String)mediaType.trim())).equals(CssMediaType.SCREEN.toString()) && !mediaType.equals(CssMediaType.ALL.toString())) continue;
            return false;
        }
        return true;
    }

    private static void processLinkTag(@NotNull XmlTag tag, @NotNull List<PsiElement> result, boolean allMedias) {
        XmlAttributeValue valueElement;
        XmlAttribute attribute;
        if (tag == null) {
            XhtmlFileInfo.$$$reportNull$$$0(4);
        }
        if (result == null) {
            XhtmlFileInfo.$$$reportNull$$$0(5);
        }
        String type = tag.getAttributeValue("type");
        String href = tag.getAttributeValue("href");
        if (href == null) {
            return;
        }
        if (type == null && !CSS_SUFFIX_PATTERN.matcher(href).find()) {
            return;
        }
        String media = tag.getAttributeValue("media");
        HashSet mediaTypes = Sets.newHashSet((Iterable)COMMA_SPLITTER.split((CharSequence)StringUtil.toUpperCase((String)Strings.nullToEmpty((String)media))));
        if ((type == null || TEXT_CSS_TYPE.equals(type)) && (allMedias || media == null || mediaTypes.contains(CssMediaType.SCREEN.toString()) || mediaTypes.contains(CssMediaType.ALL.toString())) && (attribute = tag.getAttribute("href")) != null && (valueElement = attribute.getValueElement()) != null) {
            result.add((PsiElement)valueElement);
        }
    }

    List<StylesheetInfo> getStylesheetInfos() {
        CssStylesheet predefinedStylesheet;
        this.ensureUpToDate();
        if (this.myUseAgentStylesheet && (predefinedStylesheet = XhtmlFileInfo.getPredefinedStylesheet(this.myXhtmlFile.getProject())) != null) {
            ArrayList<StylesheetInfo> result = new ArrayList<StylesheetInfo>(this.myStylesheetInfos.size() + 1);
            result.add(new StylesheetInfo(predefinedStylesheet, false, false, null));
            result.addAll(this.myStylesheetInfos);
            return result;
        }
        return this.myStylesheetInfos;
    }

    @Nullable
    String getPreferredStylesheetName() {
        this.ensureUpToDate();
        return this.myPreferredStylesheetName;
    }

    private void ensureUpToDate() {
        boolean modified = false;
        if (this.myModificationStamp != this.myXhtmlFile.getModificationStamp()) {
            modified = true;
        } else {
            for (Pair pair : this.myPairs) {
                if (pair.getModificationStamp() == pair.getFile().getModificationStamp()) continue;
                modified = true;
                break;
            }
        }
        if (modified) {
            this.initStylesheets();
        }
    }

    private Pair[] getPairs() {
        return (Pair[])ContainerUtil.map2Array(this.myStylesheetInfos, Pair.class, info -> {
            PsiFile containingFile = info.getStylesheet().getContainingFile();
            return new Pair(containingFile, containingFile.getModificationStamp());
        });
    }

    @Nullable
    public static XhtmlFileInfo getInfo(@NotNull XmlFile file, boolean useAgentStylesheets) {
        XhtmlFileInfo info;
        if (file == null) {
            XhtmlFileInfo.$$$reportNull$$$0(6);
        }
        if ((info = (XhtmlFileInfo)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            XhtmlFileInfo result = new XhtmlFileInfo(file);
            HashSet dependencies = ContainerUtil.newHashSet((Object[])new Object[]{file});
            for (StylesheetInfo stylesheetInfo : result.getStylesheetInfos()) {
                dependencies.add(stylesheetInfo.getStylesheet().getContainingFile());
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])ArrayUtil.toObjectArray((Collection)dependencies));
        })) != null) {
            info.myUseAgentStylesheet = useAgentStylesheets;
        }
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xhtmlFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/impl/XhtmlFileInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/impl/XhtmlFileInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalPathsFromSourceMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedStylesheet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalPathsFromSourceMap";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processLinkTag";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class StylesheetInfo {
        @NotNull
        private final CssStylesheet myStylesheet;
        private final boolean myIsDirectlyReferenced;
        private final boolean mySpecificMedia;
        private final String myReferencedStylesheetName;

        StylesheetInfo(@NotNull CssStylesheet stylesheet, boolean isDirectlyReferenced, boolean specificMedia, String referencedStylesheetName) {
            if (stylesheet == null) {
                StylesheetInfo.$$$reportNull$$$0(0);
            }
            assert (isDirectlyReferenced == (referencedStylesheetName != null));
            this.myStylesheet = stylesheet;
            this.myIsDirectlyReferenced = isDirectlyReferenced;
            this.mySpecificMedia = specificMedia;
            this.myReferencedStylesheetName = referencedStylesheetName;
        }

        @NotNull
        public CssStylesheet getStylesheet() {
            CssStylesheet cssStylesheet = this.myStylesheet;
            if (cssStylesheet == null) {
                StylesheetInfo.$$$reportNull$$$0(1);
            }
            return cssStylesheet;
        }

        public boolean isDirectlyReferenced() {
            return this.myIsDirectlyReferenced;
        }

        public boolean isSpecificMedia() {
            return this.mySpecificMedia;
        }

        public String getReferencedStylesheetName() {
            return this.myReferencedStylesheetName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stylesheet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/resolve/impl/XhtmlFileInfo$StylesheetInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/resolve/impl/XhtmlFileInfo$StylesheetInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStylesheet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Pair {
        private final PsiFile myFile;
        private final long myModificationStamp;

        private Pair(PsiFile file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
        }

        private PsiFile getFile() {
            return this.myFile;
        }

        private long getModificationStamp() {
            return this.myModificationStamp;
        }
    }

    private static class MyLinkTagProcessor
    implements Processor<XmlTag> {
        @NotNull
        private final List<? super StylesheetInfo> myStylesheetInfos;
        private int myAlternateNameCounter;
        private String myPreferredStylesheetName;
        private final Set<PsiFile> myVisitedFiles;

        MyLinkTagProcessor(@NotNull List<? super StylesheetInfo> stylesheetInfos) {
            if (stylesheetInfos == null) {
                MyLinkTagProcessor.$$$reportNull$$$0(0);
            }
            this.myAlternateNameCounter = 0;
            this.myPreferredStylesheetName = null;
            this.myVisitedFiles = new HashSet<PsiFile>();
            this.myStylesheetInfos = stylesheetInfos;
        }

        public boolean process(@NotNull XmlTag tag) {
            String stylesheetName;
            boolean isAlternate;
            String href;
            if (tag == null) {
                MyLinkTagProcessor.$$$reportNull$$$0(1);
            }
            String type = tag.getAttributeValue("type");
            XmlAttribute hrefAttribute = tag.getAttribute("href");
            XmlAttributeValue hrefAttributeValue = hrefAttribute != null ? hrefAttribute.getValueElement() : null;
            String string = href = hrefAttributeValue != null ? hrefAttributeValue.getValue() : null;
            if (href == null) {
                return true;
            }
            String lowercaseHref = StringUtil.toLowerCase((String)href);
            if (type == null && !lowercaseHref.endsWith(".css") && !lowercaseHref.contains(".css?")) {
                return true;
            }
            if (type != null && !type.equals(XhtmlFileInfo.TEXT_CSS_TYPE)) {
                return true;
            }
            boolean specificMedia = XhtmlFileInfo.isSpecificMedia(tag.getAttributeValue("media"));
            Object title = tag.getAttributeValue("title");
            String rel = tag.getAttributeValue("rel");
            boolean bl = isAlternate = rel != null && rel.contains("alternate");
            if (title == null && rel != null && isAlternate) {
                ++this.myAlternateNameCounter;
                title = "alternate" + (this.myAlternateNameCounter != 1 ? String.valueOf(this.myAlternateNameCounter) : "");
            }
            String string2 = stylesheetName = title == null ? "__$persistent$__" : title;
            if (!isAlternate && title != null && this.myPreferredStylesheetName == null) {
                this.myPreferredStylesheetName = stylesheetName;
            }
            PsiFile[] psiFiles = CssResolveManager.getInstance().resolveFiles((PsiElement)hrefAttributeValue);
            this.processPsiFiles(psiFiles, specificMedia, stylesheetName);
            return true;
        }

        private void processPsiFiles(PsiFile @NotNull [] psiFiles, boolean specificMedia, @Nullable String stylesheetName) {
            if (psiFiles == null) {
                MyLinkTagProcessor.$$$reportNull$$$0(2);
            }
            boolean directlyReferenced = stylesheetName != null;
            for (PsiFile psiFile : psiFiles) {
                VirtualFile dir;
                CssStylesheet stylesheet;
                if (!(psiFile instanceof StylesheetFile) || !this.myVisitedFiles.add(psiFile) || (stylesheet = ((StylesheetFile)psiFile).getStylesheet()) == null) continue;
                this.myStylesheetInfos.add(new StylesheetInfo(stylesheet, directlyReferenced, specificMedia, stylesheetName));
                for (CssImport anImport : stylesheet.getImports()) {
                    boolean specificImport = specificMedia || !anImport.isScreen();
                    this.processPsiFiles(anImport.resolve(), specificImport, null);
                }
                if (!(psiFile instanceof CssFile)) continue;
                VirtualFile vFile = psiFile.getVirtualFile();
                VirtualFile virtualFile = dir = vFile != null ? vFile.getParent() : null;
                if (dir == null) continue;
                String nameWithoutExtension = vFile.getNameWithoutExtension();
                for (VirtualFile childVFile : dir.getChildren()) {
                    PsiFile childPsiFile;
                    if (!childVFile.equals(vFile) && nameWithoutExtension.equals(childVFile.getNameWithoutExtension())) {
                        childPsiFile = psiFile.getManager().findFile(childVFile);
                        if (!(childPsiFile instanceof StylesheetFile)) continue;
                        this.processPsiFiles(new PsiFile[]{childPsiFile}, specificMedia, stylesheetName);
                        continue;
                    }
                    if (!childVFile.getName().equals(vFile.getName() + ".map") || (childPsiFile = psiFile.getManager().findFile(childVFile)) == null) continue;
                    this.processPsiFiles(MyLinkTagProcessor.getOriginalFilesFromSourceMap(childPsiFile).toArray(PsiFile.EMPTY_ARRAY), specificMedia, stylesheetName);
                }
            }
        }

        private static List<PsiFile> getOriginalFilesFromSourceMap(@NotNull PsiFile sourceMapFile) {
            if (sourceMapFile == null) {
                MyLinkTagProcessor.$$$reportNull$$$0(3);
            }
            List paths = (List)CachedValuesManager.getCachedValue((PsiElement)sourceMapFile, () -> {
                SmartList<String> result = XhtmlFileInfo.getOriginalPathsFromSourceMap(sourceMapFile.getText());
                return new CachedValueProvider.Result(result, new Object[]{sourceMapFile});
            });
            return ContainerUtil.mapNotNull((Collection)paths, s -> {
                VirtualFile file = sourceMapFile.getVirtualFile().getParent().findFileByRelativePath(s);
                return file != null ? sourceMapFile.getManager().findFile(file) : null;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stylesheetInfos";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFiles";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceMapFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/resolve/impl/XhtmlFileInfo$MyLinkTagProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processPsiFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOriginalFilesFromSourceMap";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

