/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.parameterinfo;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;

public class CssParameterInfoValueDescriptorComparator
implements Comparator<CssValueDescriptor> {
    @Override
    public int compare(CssValueDescriptor o1, CssValueDescriptor o2) {
        if (o1 == o2) {
            return 0;
        }
        int compareMin = Comparing.compare((int)o1.getMinOccur(), (int)o2.getMinOccur());
        if (compareMin != 0) {
            return compareMin;
        }
        int compareMax = Comparing.compare((int)o1.getMaxOccur(), (int)o2.getMaxOccur());
        if (compareMax != 0) {
            return compareMax;
        }
        String presentableName1 = o1.getPresentableName();
        String presentableName2 = o2.getPresentableName();
        int compareCommaSeparated = Comparing.compare((boolean)o1.isCommaSeparated(), (boolean)o2.isCommaSeparated());
        if (compareCommaSeparated != 0) {
            return compareCommaSeparated;
        }
        if (o1 instanceof CssGroupValue && o2 instanceof CssGroupValue && presentableName1.isEmpty() && presentableName2.isEmpty()) {
            int compareType = ((CssGroupValue)o1).getType().compareTo(((CssGroupValue)o2).getType());
            if (compareType != 0) {
                return compareType;
            }
            CssValueDescriptor separator1 = ((CssGroupValue)o1).getValuesSeparator();
            CssValueDescriptor separator2 = ((CssGroupValue)o1).getValuesSeparator();
            if (separator1 != null && separator2 != null) {
                int compareSeparator = Comparing.compare((Comparable)((Object)separator1.getPresentableName()), (Comparable)((Object)separator2.getPresentableName()));
                if (compareSeparator != 0) {
                    return compareSeparator;
                }
            } else {
                if (separator1 != null) {
                    return 1;
                }
                if (separator2 != null) {
                    return -1;
                }
            }
            ArrayList<CssValueDescriptor> children1 = new ArrayList<CssValueDescriptor>(((CssGroupValue)o1).getChildren());
            ArrayList<CssValueDescriptor> children2 = new ArrayList<CssValueDescriptor>(((CssGroupValue)o2).getChildren());
            if (((CssGroupValue)o1).getType() != CssGroupValue.Type.ALL) {
                children1.sort(this);
                children2.sort(this);
            }
            return ContainerUtil.compareLexicographically(children1, children2, (Comparator)this);
        }
        if (o1 instanceof CssGroupValue) {
            return 1;
        }
        if (o2 instanceof CssGroupValue) {
            return -1;
        }
        return Comparing.compare((Comparable)((Object)presentableName1), (Comparable)((Object)presentableName2));
    }
}

