/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class CssInvalidCharsetRuleInspection
extends CssBaseInspection {
    private static final LocalQuickFix REMOVE_MISPLACED_CHARSET = new LocalQuickFix(){

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssCharset) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> element.delete());
            }
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.inspections.remove.charset.fix", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LocalQuickFix CHANGE_QUOTES_FIX = new LocalQuickFix(){

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.intentions.replace.quotes", (Object[])new Object[0]);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String text;
            PsiElement element;
            if (project == null) {
                2.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                2.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssString && StringUtil.isQuotedString((String)(text = element.getText())) && StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                CssString newString = CssElementFactory.getInstance((Project)project).createString('\"', StringUtil.unquoteString((String)text), CssPsiUtil.getStylesheetLanguage((PsiElement)element));
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> element.replace((PsiElement)newString));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final LocalQuickFix MOVE_CHARSET_AT_THE_BEGINNING_FIX = new LocalQuickFix(){

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message((String)"css.inspections.move.charset.fix", (Object[])new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            CssStylesheet stylesheet;
            PsiElement element;
            if (project == null) {
                3.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                3.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof CssCharset && (stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class)) != null) {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> {
                    stylesheet.addBefore(element, stylesheet.getFirstChild());
                    element.delete();
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidCharsetRuleInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitCssCharset(CssCharset charset) {
                PsiElement parent = charset.getParent();
                CssString valueElement = charset.getValueElement();
                if (valueElement != null && valueElement.getChildren().length > 1) {
                    return;
                }
                if (!(charset.getContainingFile() instanceof StylesheetFile)) {
                    holder.registerProblem((PsiElement)charset, CssBundle.message((String)"css.inspections.charset.wrong.file", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{REMOVE_MISPLACED_CHARSET});
                } else if (!(parent instanceof CssStylesheet) || parent.getPrevSibling() != null || charset.getPrevSibling() != null) {
                    holder.registerProblem((PsiElement)charset, CssBundle.message((String)"css.inspections.charset.wrong.position", (Object[])new Object[0]), new LocalQuickFix[]{MOVE_CHARSET_AT_THE_BEGINNING_FIX, REMOVE_MISPLACED_CHARSET});
                }
                if (valueElement != null) {
                    String text = valueElement.getText();
                    if (StringUtil.isQuotedString((String)text) && StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                        holder.registerProblem((PsiElement)valueElement, CssBundle.message((String)"css.inspections.charset.wrong.quotes", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{CHANGE_QUOTES_FIX});
                    }
                    if (!Charset.availableCharsets().containsKey(StringUtil.unquoteString((String)text))) {
                        holder.registerProblem((PsiElement)valueElement, CssBundle.message((String)"css.inspections.charset.unknown.value", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidCharsetRuleInspection", "buildVisitor"));
    }
}

