/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CssTemplateSelectorsIndex
extends FileBasedIndexExtension<String, SelectorInfo> {
    public static final ID<String, SelectorInfo> KEY = ID.create((String)"css.template.selectors");
    public static final DataExternalizer<SelectorInfo> DATA_EXTERNALIZER = new DataExternalizer<SelectorInfo>(){

        public void save(@NotNull DataOutput out, SelectorInfo value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.offset);
            IOUtil.writeUTF((DataOutput)out, (String)value.name);
            IOUtil.writeUTF((DataOutput)out, (String)value.tagName);
        }

        public SelectorInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int offset = DataInputOutputUtil.readINT((DataInput)in);
            String name = IOUtil.readUTF((DataInput)in);
            String tagName = IOUtil.readUTF((DataInput)in);
            return new SelectorInfo(name, tagName, offset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/index/CssTemplateSelectorsIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DataIndexer<String, SelectorInfo, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, SelectorInfo> getName() {
        ID<String, SelectorInfo> iD = KEY;
        if (iD == null) {
            CssTemplateSelectorsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, SelectorInfo, FileContent> getIndexer() {
        DataIndexer<String, SelectorInfo, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            CssTemplateSelectorsIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            CssTemplateSelectorsIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<SelectorInfo> getValueExternalizer() {
        DataExternalizer<SelectorInfo> dataExternalizer = DATA_EXTERNALIZER;
        if (dataExternalizer == null) {
            CssTemplateSelectorsIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.FileTypeSpecificInputFilter(){

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    2.$$$reportNull$$$0(0);
                }
                fileTypeSink.consume((Object)XHtmlFileType.INSTANCE);
                fileTypeSink.consume((Object)HtmlFileType.INSTANCE);
                for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                    if (!CssIndex.isHtmlLikeOrSupportedTemplateLanguage(fileType)) continue;
                    fileTypeSink.consume((Object)fileType);
                }
            }

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                return !(file.getFileSystem() instanceof JarFileSystem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeSink";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/css/index/CssTemplateSelectorsIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerFileTypesUsedForIndexing";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 30;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/css/index/CssTemplateSelectorsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class SelectorInfo {
        @NotNull
        public final String name;
        @NotNull
        public final String tagName;
        public final int offset;

        public SelectorInfo(@NotNull String name, @NotNull String tagName, int offset) {
            if (name == null) {
                SelectorInfo.$$$reportNull$$$0(0);
            }
            if (tagName == null) {
                SelectorInfo.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.offset = offset;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectorInfo info = (SelectorInfo)o;
            if (this.offset != info.offset) {
                return false;
            }
            if (!this.name.equals(info.name)) {
                return false;
            }
            return this.tagName.equals(info.tagName);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.tagName.hashCode();
            result = 31 * result + this.offset;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tagName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/index/CssTemplateSelectorsIndex$SelectorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, SelectorInfo, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, SelectorInfo> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                MyDataIndexer.$$$reportNull$$$0(0);
            }
            THashMap result = new THashMap();
            FileViewProvider viewProvider = inputData.getPsiFile().getViewProvider();
            PsiFile psi = (PsiFile)ContainerUtil.find((Iterable)viewProvider.getAllFiles(), f -> f.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE) || f.getLanguage().is((Language)XHTMLLanguage.INSTANCE));
            if (psi != null) {
                psi.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor((Map)result){
                    final /* synthetic */ Map val$result;
                    {
                        this.val$result = map;
                    }

                    public void visitXmlAttribute(XmlAttribute attribute) {
                        String value;
                        XmlAttributeValue valueElement;
                        XmlTag tag = attribute.getParent();
                        String tagName = tag != null ? tag.getName() : "";
                        String attributeName = attribute.getName();
                        if (Comparing.strEqual((String)"class", (String)attributeName, (boolean)false)) {
                            String value2;
                            XmlAttributeValue valueElement2 = attribute.getValueElement();
                            if (valueElement2 != null && (value2 = attribute.getValue()) != null) {
                                int startOffset = valueElement2.getTextRange().getStartOffset() + ElementManipulators.getValueTextRange((PsiElement)valueElement2).getStartOffset();
                                PairConsumer consumer = (name, range) -> {
                                    String className = range.substring(value2);
                                    if (!className.isEmpty()) {
                                        int offset = startOffset + range.getStartOffset();
                                        SelectorInfo selectorInfo = new SelectorInfo("." + className, tagName, offset);
                                        this.val$result.put(selectorInfo.name, selectorInfo);
                                    }
                                };
                                CssResolveUtil.consumeClassNames(valueElement2.getValue(), (PsiElement)valueElement2, (PairConsumer<? super String, ? super TextRange>)consumer);
                            }
                        } else if (Comparing.strEqual((String)"id", (String)attributeName, (boolean)false) && (valueElement = attribute.getValueElement()) != null && StringUtil.isNotEmpty((String)(value = attribute.getValue()))) {
                            int offset = valueElement.getTextRange().getStartOffset() + ElementManipulators.getValueTextRange((PsiElement)valueElement).getStartOffset();
                            SelectorInfo selectorInfo = new SelectorInfo("#" + value, tagName, offset);
                            this.val$result.put(selectorInfo.name, selectorInfo);
                        }
                        super.visitXmlAttribute(attribute);
                    }
                });
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                MyDataIndexer.$$$reportNull$$$0(1);
            }
            return tHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/index/CssTemplateSelectorsIndex$MyDataIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/index/CssTemplateSelectorsIndex$MyDataIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

