/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssBlockSkipper;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.css.impl.parsing.CssParser;
import com.intellij.psi.css.impl.stubs.CssPseudoSelectorStubElementType;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssParser2
implements CssParser {
    public static final TokenSet SELECTORS_HIERARCHY_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_GT, CssElementTypes.CSS_GT_GT_GT, CssElementTypes.CSS_SLASHED_COMBINATOR, CssElementTypes.CSS_HAT, CssElementTypes.CSS_CAT, CssElementTypes.CSS_PLUS, CssElementTypes.CSS_TILDA});
    private static final IElementType IDENT = CssElementTypes.CSS_IDENT;
    private static final IElementType COMMA = CssElementTypes.CSS_COMMA;
    private static final IElementType PERIOD = CssElementTypes.CSS_PERIOD;
    private static final IElementType HASH = CssElementTypes.CSS_HASH;
    private static final IElementType COLON = CssElementTypes.CSS_COLON;
    private static final IElementType NUMBER = CssElementTypes.CSS_NUMBER;
    private static final IElementType MINUS = CssElementTypes.CSS_MINUS;
    private static final IElementType STRING_TOKEN = CssElementTypes.CSS_STRING_TOKEN;
    private static final IElementType URI_START = CssElementTypes.CSS_URI_START;
    private static final IElementType LBRACE = CssElementTypes.CSS_LBRACE;
    private static final IElementType RBRACE = CssElementTypes.CSS_RBRACE;
    private static final IElementType LBRACKET = CssElementTypes.CSS_LBRACKET;
    private static final IElementType RBRACKET = CssElementTypes.CSS_RBRACKET;
    private static final IElementType SEMICOLON = CssElementTypes.CSS_SEMICOLON;
    private static final IElementType IMPORT_SYM = CssElementTypes.CSS_IMPORT_SYM;
    private static final IElementType IMPORTANT = CssElementTypes.CSS_IMPORTANT;
    private static final IElementType FUNCTION_TOKEN = CssElementTypes.CSS_FUNCTION_TOKEN;
    private static final IElementType RPAREN = CssElementTypes.CSS_RPAREN;
    private static final IElementType PLUS = CssElementTypes.CSS_PLUS;
    private static final IElementType ASTERISK = CssElementTypes.CSS_ASTERISK;
    @NotNull
    private final CssMathParser MATH_PARSER;
    private boolean parseInlineCss;
    private static boolean doSyntaxErrorReporting = true;
    protected PsiBuilder myBuilder;
    private boolean inKeyframesRuleset = false;
    private boolean mySemicolonRequired = true;
    protected boolean myIsMediaFeature = false;
    private final WhitespacesAndCommentsBinder commentsBefore = WhitespacesBinders.leadingCommentsBinder((TokenSet)this.getCommentTokenTypes());
    private static final WhitespacesAndCommentsBinder emptyBeforeWithMoreThanOneWhiteSpaceR = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            if (tokens.size() == 1 && tokens.get(0) == CssElementTypes.CSS_WHITE_SPACE) {
                return 0;
            }
            return tokens.size();
        }
    };

    public CssParser2() {
        this.MATH_PARSER = new CssMathParser(this);
    }

    public WhitespacesAndCommentsBinder getCommentsBeforeBinder() {
        return this.commentsBefore;
    }

    @Override
    @Nullable
    public final IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    @Override
    @Nullable
    public final IElementType rawLookup(int steps) {
        return this.myBuilder.rawLookup(steps);
    }

    @Override
    @Nullable
    public final IElementType lookAhead(int steps) {
        return this.myBuilder.lookAhead(steps);
    }

    @Nullable
    public final String getTokenText() {
        return this.myBuilder.getTokenText();
    }

    @Override
    public void addToken() {
        this.myBuilder.advanceLexer();
    }

    @Override
    public void addSingleToken() {
        this.myBuilder.advanceLexer();
    }

    protected IElementType getStylesheetElementType() {
        return CssElementTypes.CSS_STYLESHEET;
    }

    protected IElementType getStylesheetLazyElementType() {
        return CssElementTypes.CSS_LAZY_STYLESHEET;
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            CssParser2.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            CssParser2.$$$reportNull$$$0(1);
        }
        this.myBuilder = builder;
        this.parse(root);
        ASTNode aSTNode = this.myBuilder.getTreeBuilt();
        if (aSTNode == null) {
            CssParser2.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    protected void parse(IElementType root) {
        boolean hasCommentsAndWhitespacesOnly;
        PsiBuilder.Marker rootMarker = this.myBuilder.mark();
        boolean bl = hasCommentsAndWhitespacesOnly = this.myBuilder.getTokenType() == null;
        if (root instanceof IFileElementType) {
            PsiBuilder.Marker styleSheet = this.myBuilder.mark();
            while (this.myBuilder.getTokenType() != null) {
                this.myBuilder.advanceLexer();
            }
            styleSheet.collapse(this.getStylesheetLazyElementType());
            WhitespacesAndCommentsBinder leftBinder = this.getStylesheetLeftBinder(hasCommentsAndWhitespacesOnly);
            styleSheet.setCustomEdgeTokenBinders(leftBinder, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        } else if (root instanceof CssStylesheetLazyElementType) {
            PsiBuilder.Marker stylesheet = this.createCompositeElement();
            this.parseCharset();
            this.skipSgmlCommentDelimiters(true);
            this.parseImportList();
            this.parseNamespaceList();
            this.parseRulesetList(false);
            this.skipSgmlCommentDelimiters(true);
            stylesheet.done(this.getStylesheetElementType());
            WhitespacesAndCommentsBinder leftBinder = this.getStylesheetLeftBinder(hasCommentsAndWhitespacesOnly);
            stylesheet.setCustomEdgeTokenBinders(leftBinder, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        } else if (root == CssElementTypes.CSS_PAGE_BLOCK) {
            this.parseInlineCss = true;
            this.parseDeclarationBlock(CssElementTypes.CSS_PAGE_BLOCK);
        } else {
            this.parseInlineCss = true;
            this.parseDeclarationBlock();
        }
        rootMarker.done(root);
        rootMarker.setCustomEdgeTokenBinders(this.commentsBefore, WhitespacesBinders.GREEDY_RIGHT_BINDER);
    }

    public WhitespacesAndCommentsBinder getStylesheetLeftBinder(boolean hasCommentsAndWhitespacesOnly) {
        return hasCommentsAndWhitespacesOnly ? emptyBeforeWithMoreThanOneWhiteSpaceR : WhitespacesBinders.GREEDY_LEFT_BINDER;
    }

    public void addTokenAndSkipWhitespace() {
        this.addToken();
    }

    protected TokenSet getCommentTokenTypes() {
        return CssElementTypes.COMMENTS;
    }

    @Override
    @NotNull
    public final PsiBuilder.Marker createCompositeElement() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (marker == null) {
            CssParser2.$$$reportNull$$$0(3);
        }
        return marker;
    }

    protected boolean isSimpleSelectorStart() {
        IElementType tokenType = this.getTokenType();
        return this.isIdent(tokenType) || tokenType == CssElementTypes.CSS_ASTERISK;
    }

    public boolean isIdent(IElementType type) {
        return type == IDENT;
    }

    @Override
    public final boolean isIdent() {
        return this.isIdent(this.getTokenType());
    }

    protected boolean isOrToken() {
        return (this.isIdent() || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) && "or".equalsIgnoreCase(this.getTokenText());
    }

    protected boolean isAndToken() {
        return (this.isIdent() || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) && "and".equalsIgnoreCase(this.getTokenText());
    }

    protected boolean isNotToken() {
        return (this.isIdent() || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) && "not".equalsIgnoreCase(this.getTokenText());
    }

    protected boolean isRulesetStart() {
        IElementType type = this.getTokenType();
        return this.isSimpleSelectorStart() || type == PERIOD || type == HASH || type == COLON || type == LBRACKET || type == CssElementTypes.CSS_PIPE || SELECTORS_HIERARCHY_TOKENS.contains(type);
    }

    public boolean isDone() {
        IElementType tokenType = this.getTokenType();
        return tokenType == null;
    }

    protected void createErrorElement(@NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            CssParser2.$$$reportNull$$$0(4);
        }
        if (!doSyntaxErrorReporting) {
            return;
        }
        this.myBuilder.mark().error(message);
    }

    @Nullable
    protected PsiBuilder.Marker createRootErrorElement() {
        if (!doSyntaxErrorReporting) {
            return null;
        }
        return this.myBuilder.mark();
    }

    protected boolean addTokenOrError(IElementType expectedTokenType, @NlsContexts.ParsingError String message) {
        if (this.getTokenType() == expectedTokenType) {
            this.addSingleToken();
            return true;
        }
        this.createErrorElement(CssBundle.message((String)"parsing.error.0.expected", (Object[])new Object[]{message}));
        return false;
    }

    protected void addSemicolonOrError() {
        this.addTokenOrError(SEMICOLON, "';'");
    }

    @Override
    public boolean addIdentOrError() {
        if (this.getTokenType() == IDENT) {
            this.addSingleToken();
            return true;
        }
        this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        return false;
    }

    protected void addRParenOrError() {
        this.addTokenOrError(RPAREN, "')'");
    }

    protected void skipSgmlCommentDelimiters(boolean parseInnerStylesheet) {
        IElementType tokenType;
        boolean seenCDO = false;
        while (!this.isDone() && ((tokenType = this.getTokenType()) == CssElementTypes.CSS_CDO || tokenType == CssElementTypes.CSS_CDC || !parseInnerStylesheet && seenCDO)) {
            if (tokenType == CssElementTypes.CSS_CDO) {
                seenCDO = true;
            } else if (tokenType == CssElementTypes.CSS_CDC && seenCDO) {
                if (!parseInnerStylesheet) {
                    this.addToken();
                }
                return;
            }
            this.addToken();
        }
    }

    protected void parseRulesetList(boolean stopOnRBrace) {
        PsiBuilder.Marker rulesetList = this.createCompositeElement();
        boolean endedWithCdc = false;
        while (!this.isDone() && this.parseRulesetListItem(stopOnRBrace)) {
            if (this.myBuilder.getTokenType() == CssElementTypes.CSS_CDC && this.myBuilder.lookAhead(1) == null) {
                endedWithCdc = true;
                break;
            }
            this.skipSgmlCommentDelimiters(true);
        }
        rulesetList.done((IElementType)CssElementTypes.CSS_RULESET_LIST);
        rulesetList.setCustomEdgeTokenBinders(this.commentsBefore, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        if (endedWithCdc) {
            this.addToken();
        }
    }

    protected boolean parseRulesetListItem(boolean stopOnRBrace) {
        if (this.parseCharset() || this.parseStylesheetItem() || !this.parseInlineCss && this.parseDeclarationBlock()) {
            return true;
        }
        if (this.isDone() || stopOnRBrace && this.getTokenType() == RBRACE) {
            return false;
        }
        if (this.getTokenType() != CssElementTypes.CSS_CDC) {
            if (!this.parseInlineCss && this.getTokenType() == RBRACE) {
                PsiBuilder.Marker errorElement = this.createRootErrorElement();
                this.addToken();
                if (errorElement != null) {
                    errorElement.error(CssBundle.message((String)"parsing.error.opening.brace.expected", (Object[])new Object[0]));
                }
            } else {
                if (!this.isExpectedTokenAfterDeclarationBlock()) {
                    this.myBuilder.error(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
                }
                this.addToken();
            }
        }
        return true;
    }

    protected boolean isExpectedTokenAfterDeclarationBlock() {
        return this.parseInlineCss;
    }

    private boolean parseCharset() {
        if (this.getTokenType() != CssElementTypes.CSS_CHARSET_SYM) {
            return false;
        }
        PsiBuilder.Marker charset = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseCssString();
        this.addSemicolonOrError();
        charset.done(CssElementTypes.CSS_CHARSET);
        return true;
    }

    protected boolean parseValueAtRule() {
        if (this.getTokenType() != CssElementTypes.CSS_VALUE_SYM) {
            return false;
        }
        PsiBuilder.Marker valueAtRule = this.createCompositeElement();
        this.addToken();
        if (!this.parseValueImport()) {
            this.parseValueDeclaration();
        }
        this.addTokenOrError(SEMICOLON, "';'");
        valueAtRule.done(CssElementTypes.CSS_VALUE_RULE);
        return true;
    }

    private boolean parseValueImport() {
        if (this.getTokenType() == null) {
            return false;
        }
        PsiBuilder.Marker temp = this.createCompositeElement();
        this.addToken();
        while (!this.isDone() && this.getTokenType() != CssElementTypes.CSS_SEMICOLON) {
            if (this.getTokenType() == IDENT && "from".equals(this.getTokenText())) {
                this.addToken();
                IElementType next = this.getTokenType();
                if (next == STRING_TOKEN || next == IDENT) {
                    temp.rollbackTo();
                    this.doParseValueImport();
                    return true;
                }
            }
            this.addToken();
        }
        temp.rollbackTo();
        return false;
    }

    private void doParseValueImport() {
        boolean paren;
        PsiBuilder.Marker valueImport = this.createCompositeElement();
        boolean bl = paren = this.getTokenType() == CssElementTypes.CSS_LPAREN;
        if (paren) {
            this.addToken();
        }
        if (this.getTokenType() == IDENT) {
            this.parseValueImportedAliasList();
            if (paren) {
                this.addTokenOrError(CssElementTypes.CSS_RPAREN, "')'");
            }
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        }
        if (this.getTokenType() == IDENT && "from".equals(this.getTokenText())) {
            this.addToken();
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.from.expected", (Object[])new Object[0]));
            while (!(this.isDone() || this.getTokenType() == CssElementTypes.CSS_SEMICOLON || this.getTokenType() == IDENT && "from".equals(this.getTokenText()))) {
                this.addToken();
            }
            if (this.getTokenType() == IDENT && "from".equals(this.getTokenText())) {
                this.addToken();
            } else {
                valueImport.done(CssElementTypes.CSS_VALUE_IMPORT);
                return;
            }
        }
        if (this.getTokenType() == CssElementTypes.CSS_STRING_TOKEN) {
            this.parseCssString();
        } else if (this.getTokenType() == IDENT) {
            this.addToken();
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.file.path.expected", (Object[])new Object[0]));
        }
        valueImport.done(CssElementTypes.CSS_VALUE_IMPORT);
    }

    private void parseValueImportedAliasList() {
        PsiBuilder.Marker list = this.createCompositeElement();
        if (this.parseValueImportedAlias()) {
            while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.addToken();
                if (this.parseValueImportedAlias()) continue;
                this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
                break;
            }
        }
        list.done(CssElementTypes.CSS_VALUE_IMPORTED_ALIAS_LIST);
    }

    private boolean parseValueImportedAlias() {
        if (this.getTokenType() != IDENT) {
            return false;
        }
        PsiBuilder.Marker element = this.createCompositeElement();
        this.addToken();
        if (this.getTokenType() == IDENT && "as".equals(this.getTokenText())) {
            this.addToken();
            this.addIdentOrError();
        }
        element.done(CssElementTypes.CSS_VALUE_IMPORTED_ALIAS);
        return true;
    }

    private void parseValueDeclaration() {
        PsiBuilder.Marker valueDecl = this.createCompositeElement();
        this.addIdentOrError();
        if (this.getTokenType() == COLON) {
            this.addToken();
        }
        PsiBuilder.Marker valueValue = this.createCompositeElement();
        if (this.getTokenType() == STRING_TOKEN && this.lookAhead(1) == SEMICOLON) {
            this.parseCssString();
        } else {
            while (!this.isDone() && this.getTokenType() != SEMICOLON) {
                this.addToken();
            }
        }
        valueValue.done(CssElementTypes.CSS_VALUE_VALUE);
        valueDecl.done(CssElementTypes.CSS_VALUE_DECLARATION);
    }

    protected boolean parseGenericAtRule(boolean withNestedRulesets) {
        if (this.getTokenType() != CssElementTypes.CSS_ATKEYWORD) {
            return false;
        }
        PsiBuilder.Marker atRule = this.createCompositeElement();
        this.addToken();
        while (!this.isDone() && this.getTokenType() != LBRACE && this.getTokenType() != RBRACE && this.getTokenType() != CssElementTypes.CSS_ATKEYWORD) {
            if (this.getTokenType() == SEMICOLON) {
                this.addTokenAndSkipWhitespace();
                atRule.done(CssElementTypes.CSS_GENERIC_AT_RULE);
                return true;
            }
            this.addTokenAndSkipWhitespace();
        }
        if (withNestedRulesets) {
            if (this.getTokenType() == LBRACE) {
                this.parseNestedRulesetList();
            }
        } else if (!this.parseDeclarationBlock() || this.myBuilder.rawLookup(-1) != RBRACE) {
            atRule.rollbackTo();
            return this.parseGenericAtRule(true);
        }
        atRule.done(CssElementTypes.CSS_GENERIC_AT_RULE);
        return true;
    }

    protected boolean parseSimpleAtRule(IElementType atRuleSym, IElementType resultElementType) {
        if (this.getTokenType() != atRuleSym) {
            return false;
        }
        PsiBuilder.Marker element = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseDeclarationBlock();
        element.done(resultElementType);
        return true;
    }

    protected boolean parseAllSimpleAtRules() {
        return this.parseFontFace() || this.parseViewPort();
    }

    private boolean parseFontFace() {
        return this.parseSimpleAtRule(CssElementTypes.CSS_FONTFACE_SYM, CssElementTypes.CSS_FONTFACE);
    }

    private boolean parseViewPort() {
        return this.parseSimpleAtRule(CssElementTypes.CSS_VIEWPORT_SYM, CssElementTypes.CSS_VIEWPORT);
    }

    protected boolean parseKeyframes() {
        if (this.getTokenType() != CssElementTypes.CSS_KEYFRAMES_SYM) {
            return false;
        }
        this.inKeyframesRuleset = true;
        PsiBuilder.Marker keyframes = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        if (!this.parseKeyframesName()) {
            PsiBuilder.Marker error = this.createCompositeElement();
            while (!this.isDone() && this.getTokenType() != LBRACE && this.getTokenType() != RBRACE) {
                this.addToken();
            }
            error.error(CssBundle.message((String)"parsing.error.invalid.keyframes.name", (Object[])new Object[0]));
        }
        if (this.addTokenOrError(LBRACE, "'{'")) {
            this.skipSgmlCommentDelimiters(false);
            while (!this.isDone() && this.getTokenType() != RBRACE) {
                boolean rulesetParsingResult = this.parseKeyframesRuleset();
                this.skipSgmlCommentDelimiters(false);
                if (rulesetParsingResult) continue;
                break;
            }
            this.addTokenOrError(RBRACE, "'}'");
        }
        keyframes.done(CssElementTypes.CSS_KEYFRAMES_RULE);
        this.inKeyframesRuleset = false;
        return true;
    }

    protected boolean parseKeyframesName() {
        if (this.isIdent()) {
            return this.addIdentOrError();
        }
        if (this.getTokenType() == COLON && this.lookAhead(1) == FUNCTION_TOKEN && (this.lookAhead(3) == CssElementTypes.CSS_RPAREN || this.lookAhead(3) == IDENT && this.lookAhead(4) == CssElementTypes.CSS_RPAREN)) {
            this.addToken();
            this.addToken();
            this.addToken();
            this.addIdentOrError();
            this.addToken();
            return true;
        }
        return false;
    }

    protected boolean parseKeyframesRuleset() {
        PsiBuilder.Marker ruleset = this.createCompositeElement();
        boolean result = false;
        if (this.parseKeyframeSelectorList()) {
            if (this.parseDeclarationBlock()) {
                result = true;
            } else {
                PsiBuilder.Marker error = this.createCompositeElement();
                while (!this.isDone() && this.getTokenType() != LBRACE && this.getTokenType() != RBRACE) {
                    this.addToken();
                }
                error.error(CssBundle.message((String)"parsing.error.keyframe.block.expected", (Object[])new Object[0]));
                result = false;
            }
        }
        if (result) {
            ruleset.done((IElementType)CssElementTypes.CSS_RULESET);
        } else {
            ruleset.drop();
        }
        return result;
    }

    private void parseImportList() {
        if (!this.canStartImportList(this.getTokenType())) {
            return;
        }
        PsiBuilder.Marker importList = this.createCompositeElement();
        while (this.parseImport()) {
            this.skipSgmlCommentDelimiters(true);
        }
        importList.done(CssElementTypes.CSS_IMPORT_LIST);
        importList.setCustomEdgeTokenBinders(this.commentsBefore, null);
    }

    protected boolean parseNamespaceList() {
        if (this.getTokenType() != CssElementTypes.CSS_NAMESPACE_SYM) {
            return false;
        }
        PsiBuilder.Marker namespaceList = this.createCompositeElement();
        while (this.parseNamespace()) {
            this.skipSgmlCommentDelimiters(true);
        }
        namespaceList.done(CssElementTypes.CSS_NAMESPACE_LIST);
        return true;
    }

    protected boolean parseNamespace() {
        if (this.getTokenType() != CssElementTypes.CSS_NAMESPACE_SYM) {
            return false;
        }
        PsiBuilder.Marker namespace = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseNamespaceName();
        if (!this.parseUriOrString()) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.url.or.string.expected", (Object[])new Object[0]));
        }
        this.addSemicolonOrError();
        namespace.done(CssElementTypes.CSS_NAMESPACE);
        return true;
    }

    protected boolean parseNamespaceName() {
        if (this.isIdent()) {
            return this.addIdentOrError();
        }
        return false;
    }

    protected boolean parseUriOrString() {
        return this.parseUri() || this.parseCssString();
    }

    protected boolean parseCssString() {
        if (this.getTokenType() != STRING_TOKEN) {
            return false;
        }
        PsiBuilder.Marker string = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        string.done(CssElementTypes.CSS_STRING);
        return true;
    }

    protected boolean parseImportReference() {
        return this.parseUriOrString();
    }

    protected boolean parseImport() {
        if (this.getTokenType() != IMPORT_SYM) {
            return false;
        }
        PsiBuilder.Marker anImport = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        if (!this.parseImportReference()) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.url.or.string.expected", (Object[])new Object[0]));
        }
        if (this.getTokenType() != CssElementTypes.CSS_SEMICOLON) {
            this.parseImportSupportsCondition();
        }
        if (this.getTokenType() != CssElementTypes.CSS_SEMICOLON) {
            this.parseMediumList();
        }
        this.addSemicolonOrError();
        anImport.done((IElementType)CssElementTypes.CSS_IMPORT);
        return true;
    }

    protected boolean parseImportSupportsCondition() {
        if (!CssParser2.isSupportsClause(this.getTokenType(), this.getTokenText()) || this.rawLookup(1) != CssElementTypes.CSS_LPAREN) {
            return false;
        }
        PsiBuilder.Marker supports = this.createCompositeElement();
        this.addToken();
        this.addToken();
        if (this.parseSupportsCondition() || this.parseSingleDeclarationInBlock(true)) {
            this.addRParenOrError();
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.supports.condition.or.declaration.expected", (Object[])new Object[0]));
        }
        supports.done(CssElementTypes.CSS_SUPPORTS);
        return true;
    }

    protected boolean canStartImportList(IElementType tokenType) {
        return tokenType == IMPORT_SYM;
    }

    protected boolean parseStylesheetItem() {
        if (this.parseRuleset()) {
            return true;
        }
        IElementType tokenType = this.getTokenType();
        if (this.parsePage() || this.parseKeyframes() || this.parseMedia() || this.parseSupports() || this.parseAllSimpleAtRules() || this.parseValueAtRule() || this.parseScope() || this.parseCounterStyle() || this.parseRegion() || this.parseDocument()) {
            return true;
        }
        if (this.parseImport()) {
            return true;
        }
        return tokenType == CssElementTypes.CSS_ATKEYWORD && (this.parseAtRule() || this.parseGenericAtRule(false));
    }

    protected boolean parseDocument() {
        if (this.getTokenType() == CssElementTypes.CSS_DOCUMENT_SYM) {
            PsiBuilder.Marker marker = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            if (this.getTokenType() == LBRACE) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.function.expected", (Object[])new Object[0]));
            }
            while (this.getTokenType() != null && this.getTokenType() != LBRACE) {
                this.addTokenAndSkipWhitespace();
            }
            this.parseNestedRulesetList();
            marker.done(CssElementTypes.CSS_DOCUMENT_RULE);
            return true;
        }
        return false;
    }

    protected boolean parseRegion() {
        if (this.getTokenType() == CssElementTypes.CSS_REGION_SYM) {
            PsiBuilder.Marker marker = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            this.parseSelector();
            this.parseNestedRulesetList();
            marker.done(CssElementTypes.CSS_REGION_RULE);
            return true;
        }
        return false;
    }

    protected boolean parseAtRule() {
        return false;
    }

    protected boolean parseScope() {
        if (this.getTokenType() != CssElementTypes.CSS_SCOPE_SYM) {
            return false;
        }
        PsiBuilder.Marker page = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseSelectorList();
        this.parseNestedRulesetList();
        page.done(CssElementTypes.CSS_SCOPE_RULE);
        return true;
    }

    protected boolean parseCounterStyle() {
        if (this.getTokenType() != CssElementTypes.CSS_COUNTER_STYLE_SYM) {
            return false;
        }
        PsiBuilder.Marker counterStyle = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.addIdentOrError();
        this.parseDeclarationBlock();
        counterStyle.done(CssElementTypes.CSS_COUNTER_STYLE_RULE);
        return true;
    }

    protected boolean parsePage() {
        if (this.getTokenType() != CssElementTypes.CSS_PAGE_SYM) {
            return false;
        }
        PsiBuilder.Marker page = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parsePageSelectors();
        this.parseDeclarationBlock(CssElementTypes.CSS_PAGE_BLOCK);
        page.done(CssElementTypes.CSS_PAGE);
        return true;
    }

    private void parsePageSelectors() {
        if (this.parsePageSelector()) {
            while (this.getTokenType() == COMMA) {
                this.addToken();
                if (this.parsePageSelector()) continue;
                this.createErrorElement(CssBundle.message((String)"parsing.error.page.selector.expected", (Object[])new Object[0]));
            }
        }
    }

    private boolean parsePageSelector() {
        if (!this.isIdent() && this.getTokenType() != COLON) {
            return false;
        }
        boolean result = false;
        if (this.isIdent()) {
            this.addIdentOrError();
            result = true;
        }
        while (!(result && this.hasWhitespaceBefore() || this.getTokenType() != COLON)) {
            PsiBuilder.Marker pseudoPage = this.createCompositeElement();
            this.addToken();
            if (!this.hasWhitespaceBefore()) {
                if (this.isIdent()) {
                    this.addIdentOrError();
                    result = true;
                } else if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
                    this.parseFunction(true);
                    result = true;
                } else {
                    this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
                }
            } else {
                this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            }
            pseudoPage.done((IElementType)CssElementTypes.CSS_PSEUDO_PAGE);
        }
        return result;
    }

    protected boolean parseDeclarationBlock() {
        return this.parseDeclarationBlock(CssElementTypes.CSS_DECLARATION_BLOCK);
    }

    protected boolean parseDeclarationBlock(ILazyParseableElementType blockElementType) {
        if (!this.parseInlineCss) {
            return CssBlockSkipper.skipDeclarationBlockAndCollapse(this, blockElementType);
        }
        this.parseInlineCss = false;
        IElementType currentTokenType = this.getTokenType();
        boolean withBraces = false;
        if (currentTokenType == LBRACE) {
            this.addTokenAndSkipWhitespace();
            withBraces = true;
        }
        boolean unexpectedEnd = this.isDone();
        this.skipSgmlCommentDelimiters(false);
        while (!this.isDone()) {
            int lastPosition = this.myBuilder.getCurrentOffset();
            if (!this.parseSingleDeclarationInBlock(blockElementType == CssElementTypes.CSS_PAGE_BLOCK, true)) {
                unexpectedEnd = true;
                break;
            }
            if (this.isSemicolonRequired()) {
                if (this.getTokenType() != SEMICOLON) {
                    if (lastPosition < this.myBuilder.getCurrentOffset() && !this.isDone() && this.getTokenType() != RBRACE) {
                        this.addSemicolonOrError();
                        if (this.getTokenType() != LBRACE) continue;
                    }
                    this.advanceUntil(LBRACE, RBRACE, SEMICOLON);
                    IElementType tokenType = this.getTokenType();
                    if (this.isDone()) {
                        unexpectedEnd = true;
                        break;
                    }
                    if (tokenType == SEMICOLON) {
                        this.addToken();
                    } else if (tokenType == RBRACE) {
                        if (withBraces) break;
                        this.addToken();
                    } else if (tokenType == LBRACE) {
                        this.parseDeclarationBlock();
                    }
                } else {
                    this.addToken();
                }
            }
            this.skipSgmlCommentDelimiters(false);
        }
        if (withBraces) {
            if (this.getTokenType() != RBRACE || unexpectedEnd) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.closing.brace.expected", (Object[])new Object[0]));
            }
            if (this.getTokenType() == RBRACE) {
                this.addToken();
            }
        }
        if (!this.isDone()) {
            PsiBuilder.Marker error = this.createCompositeElement();
            while (!this.isDone()) {
                this.addToken();
            }
            error.error(CssBundle.message((String)"parsing.error.unexpected.terms", (Object[])new Object[0]));
        }
        this.parseInlineCss = true;
        return true;
    }

    @Override
    public void advanceUntil(IElementType ... stopElements) {
        TokenSet set = TokenSet.create((IElementType[])stopElements);
        while (!this.isDone() && !set.contains(this.getTokenType())) {
            this.addToken();
        }
    }

    protected boolean isSemicolonRequired() {
        return this.mySemicolonRequired;
    }

    private boolean parseSingleDeclarationInBlock(boolean parseInlineCss) {
        return this.parseSingleDeclarationInBlock(false, parseInlineCss);
    }

    protected boolean parseSingleDeclarationInBlock(boolean withPageMarginRules, boolean parseInlineCss) {
        return this.parseSingleDeclarationInBlock(withPageMarginRules, parseInlineCss, true);
    }

    protected boolean parseSingleDeclarationInBlock(boolean withPageMarginRules, boolean parseInlineCss, boolean requirePropertyValue) {
        return this.parseSingleDeclarationInBlock(withPageMarginRules, parseInlineCss, requirePropertyValue, (IElementType)CssElementTypes.CSS_DECLARATION);
    }

    protected boolean parseSingleDeclarationInBlock(boolean withPageMarginRules, boolean parseInlineCss, boolean requirePropertyValue, @NotNull IElementType elementType) {
        if (elementType == null) {
            CssParser2.$$$reportNull$$$0(5);
        }
        if (!this.myIsMediaFeature && !withPageMarginRules && this.parseGenericAtRule(false)) {
            this.mySemicolonRequired = false;
            return true;
        }
        if (withPageMarginRules) {
            if (this.getTokenType() == CssElementTypes.CSS_PAGE_MARGIN_SYM) {
                this.parsePageMarginRule();
                this.mySemicolonRequired = false;
                return true;
            }
            if (this.getTokenType() == CssElementTypes.CSS_ATKEYWORD) {
                PsiBuilder.Marker atRule = this.myBuilder.mark();
                PsiBuilder.Marker error = this.myBuilder.mark();
                this.addToken();
                error.error(CssBundle.message((String)"parsing.error.unknown.page.margin.keyword", (Object[])new Object[0]));
                this.parseDeclarationBlock();
                atRule.done(CssElementTypes.CSS_GENERIC_AT_RULE);
                this.mySemicolonRequired = false;
                return true;
            }
        }
        this.mySemicolonRequired = true;
        if (this.isIdent() || this.getTokenType() == NUMBER || this.getTokenType() == HASH || this.getTokenType() == CssElementTypes.CSS_BAD_CHARACTER) {
            if (!parseInlineCss) {
                PsiBuilder.Marker position = this.myBuilder.mark();
                int insideExpression = 0;
                while (!this.isDone()) {
                    this.addToken();
                    if (this.isDone()) break;
                    IElementType tt = this.getTokenType();
                    if (insideExpression == 0 && tt == CssElementTypes.CSS_EXPRESSION) {
                        this.addToken();
                        if (this.getTokenType() != CssElementTypes.CSS_LPAREN) continue;
                        insideExpression = 1;
                        continue;
                    }
                    if (insideExpression > 0) {
                        if (tt == CssElementTypes.CSS_LPAREN) {
                            ++insideExpression;
                        } else if (tt == CssElementTypes.CSS_RPAREN) {
                            --insideExpression;
                        }
                    }
                    if (insideExpression != 0 || tt != SEMICOLON && tt != LBRACE && tt != RBRACE) continue;
                    break;
                }
                if (!this.shouldIgnoreLbraceAfterDeclaration() && this.getTokenType() == LBRACE) {
                    position.rollbackTo();
                    this.createErrorElement(CssBundle.message((String)"parsing.error.closing.brace.expected", (Object[])new Object[0]));
                    return false;
                }
                position.rollbackTo();
            }
            this.parseDeclaration(false, requirePropertyValue, elementType);
        }
        if (this.getTokenType() == ASTERISK || this.getTokenType() == CssElementTypes.CSS_MINUS) {
            IElementType type;
            if (!parseInlineCss && (type = this.myBuilder.lookAhead(1)) != null && !this.isIdent(type)) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.closing.brace.expected", (Object[])new Object[0]));
                return false;
            }
            this.parseDeclaration(true, requirePropertyValue, elementType);
        }
        return true;
    }

    private boolean parsePageMarginRule() {
        if (this.getTokenType() != CssElementTypes.CSS_PAGE_MARGIN_SYM) {
            return false;
        }
        PsiBuilder.Marker pageMargin = this.myBuilder.mark();
        this.addToken();
        this.parseDeclarationBlock();
        pageMargin.done(CssElementTypes.CSS_PAGE_MARGIN_RULE);
        return true;
    }

    protected boolean shouldIgnoreLbraceAfterDeclaration() {
        return false;
    }

    protected void parsePropertyOfDeclaration() {
        boolean error = false;
        if (!this.isIdent() && HASH != this.getTokenType()) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.property.name.expected", (Object[])new Object[0]));
            error = true;
        }
        this.addToken();
        if (error && this.isIdent()) {
            this.addToken();
        }
    }

    protected void parseDeclaration(boolean asteriskDeclaration, boolean requirePropertyValue, @NotNull IElementType elementType) {
        if (elementType == null) {
            CssParser2.$$$reportNull$$$0(6);
        }
        PsiBuilder.Marker declaration = this.createCompositeElement();
        String name = null;
        if (asteriskDeclaration) {
            this.addToken();
            if (this.getTokenType() != null) {
                this.addTokenAndSkipWhitespace();
            }
        } else {
            if (this.myBuilder.getTokenType() == CssElementTypes.CSS_IDENT) {
                name = this.myBuilder.getTokenText();
            }
            this.parsePropertyOfDeclaration();
        }
        boolean filter = false;
        if (name != null && name.endsWith("filter")) {
            filter = true;
        }
        if (name != null && name.startsWith("--") && this.getTokenType() == COLON && this.lookAhead(1) == LBRACE) {
            this.addTokenOrError(COLON, "':'");
            this.parseDeclarationBlock();
            declaration.done((IElementType)CssElementTypes.CSS_CUSTOM_MIXIN);
            return;
        }
        if (requirePropertyValue || this.getTokenType() == COLON) {
            this.addTokenOrError(COLON, "':'");
            if (filter) {
                this.parseFilterTermList();
            } else {
                this.parseTermList(true, new IElementType[0]);
            }
            if (this.getTokenType() == IMPORTANT) {
                this.addTokenAndSkipWhitespace();
            }
        }
        declaration.done(elementType);
    }

    protected boolean parseRuleset() {
        if (!this.isRulesetStart()) {
            return false;
        }
        PsiBuilder.Marker ruleset = this.createCompositeElement();
        this.parseSelectorList();
        this.parseDeclarationBlock();
        ruleset.done((IElementType)CssElementTypes.CSS_RULESET);
        return true;
    }

    protected boolean parseSupports() {
        if (this.getTokenType() != CssElementTypes.CSS_SUPPORTS_SYM) {
            return false;
        }
        PsiBuilder.Marker supports = this.createCompositeElement();
        this.addToken();
        if (!this.parseSupportsCondition()) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.supports.condition.expected", (Object[])new Object[0]));
        }
        this.parseSupportsAtRuleBody();
        supports.done(CssElementTypes.CSS_SUPPORTS);
        return true;
    }

    protected void parseSupportsAtRuleBody() {
        this.parseNestedRulesetList();
    }

    protected void parseNestedRulesetList() {
        this.addTokenOrError(LBRACE, "'{'");
        this.skipSgmlCommentDelimiters(true);
        while (this.parseRulesetListItem(true)) {
            this.skipSgmlCommentDelimiters(true);
        }
        this.addTokenOrError(RBRACE, "'}'");
    }

    private boolean parseSupportsCondition() {
        PsiBuilder.Marker conditionList = this.createCompositeElement();
        PsiBuilder.Marker condition = this.createCompositeElement();
        if (this.parseSupportsNegation()) {
            condition.done(CssElementTypes.CSS_SUPPORTS_CONDITION);
            conditionList.drop();
            return true;
        }
        if (this.parseSupportsConditionsInParens()) {
            if (this.isIdent()) {
                IElementType listType;
                if (this.isAndToken()) {
                    listType = CssElementTypes.CSS_SUPPORTS_CONDITION_AND_LIST;
                    this.parseSupportsMultiConditions("and", CssBundle.message((String)"parsing.error.and.expected", (Object[])new Object[0]));
                } else if (this.isOrToken()) {
                    listType = CssElementTypes.CSS_SUPPORTS_CONDITION_OR_LIST;
                    this.parseSupportsMultiConditions("or", CssBundle.message((String)"parsing.error.or.expected", (Object[])new Object[0]));
                } else {
                    listType = CssElementTypes.CSS_SUPPORTS_CONDITION_UNKNOWN_LIST;
                    this.parseSupportsMultiConditions(null, CssBundle.message((String)"parsing.error.and.or.or.expected", (Object[])new Object[0]));
                }
                condition.drop();
                conditionList.done(listType);
            } else {
                condition.done(CssElementTypes.CSS_SUPPORTS_CONDITION);
                conditionList.drop();
            }
            return true;
        }
        conditionList.rollbackTo();
        return false;
    }

    private void parseSupportsMultiConditions(@Nullable @NonNls String operationText, @NotNull @NlsContexts.ParsingError String errorMessage) {
        if (errorMessage == null) {
            CssParser2.$$$reportNull$$$0(7);
        }
        while (this.isIdent() || this.isOrToken() || this.isAndToken()) {
            if (operationText == null || !operationText.equalsIgnoreCase(this.getTokenText())) {
                PsiBuilder.Marker error = this.createCompositeElement();
                this.addIdentOrError();
                error.error(errorMessage);
            } else {
                this.addIdentOrError();
            }
            if (this.parseSupportsConditionsInParens()) continue;
            this.createErrorElement(CssBundle.message((String)"parsing.error.supports.condition.expected", (Object[])new Object[0]));
            break;
        }
    }

    private boolean parseSupportsNegation() {
        if (this.isNotToken()) {
            this.addToken();
            if (!this.parseSupportsConditionsInParens()) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.supports.condition.expected", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    private boolean parseSupportsConditionsInParens() {
        if (this.parseSupportsGeneralEnclosed()) {
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.addToken();
            if (!this.parseSupportsCondition() && !this.parseSingleDeclarationInBlock(true)) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.supports.condition.expected", (Object[])new Object[0]));
            }
            this.addRParenOrError();
            return true;
        }
        return false;
    }

    private boolean parseSupportsGeneralEnclosed() {
        IElementType initialToken = this.getTokenType();
        if (initialToken == FUNCTION_TOKEN || initialToken == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker markerToRollback = this.createCompositeElement();
            this.addToken();
            String tokenText = this.getTokenText();
            if (this.isIdent() && ("any".equalsIgnoreCase(tokenText) || "unused".equalsIgnoreCase(tokenText))) {
                this.addToken();
                this.addRParenOrError();
                markerToRollback.drop();
                return true;
            }
            markerToRollback.rollbackTo();
        }
        return false;
    }

    protected boolean parseMedia() {
        if (this.getTokenType() != CssElementTypes.CSS_MEDIA_SYM) {
            return false;
        }
        PsiBuilder.Marker media = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseMediumList();
        this.parseNestedRulesetList();
        media.done((IElementType)CssElementTypes.CSS_MEDIA);
        return true;
    }

    protected void parseMediumList() {
        PsiBuilder.Marker mediumList = this.createCompositeElement();
        LighterASTNode marker = this.myBuilder.getLatestDoneMarker();
        if (this.parseMediaQuery(false)) {
            while (this.getTokenType() == COMMA) {
                this.addTokenAndSkipWhitespace();
                this.parseMediaQuery(true);
            }
            LighterASTNode nextMarker = this.myBuilder.getLatestDoneMarker();
            mediumList.done(CssElementTypes.CSS_MEDIUM_LIST);
            if (nextMarker == null || nextMarker == marker) {
                mediumList.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_LEFT_BINDER);
            }
        } else {
            mediumList.drop();
        }
    }

    private boolean parseMediaQuery(boolean required) {
        PsiBuilder.Marker error;
        if (!this.isIdent() && this.getTokenType() != CssElementTypes.CSS_LPAREN && !this.isCustomMediaQueryIdent(false)) {
            if (required) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.opening.parenthesis.or.identifier.expected", (Object[])new Object[0]));
            }
            return false;
        }
        PsiBuilder.Marker mediaQuery = this.createCompositeElement();
        if (this.isIdent()) {
            String s = this.getTokenText();
            if (this.isNotToken() || "only".equals(s)) {
                this.addTokenAndSkipWhitespace();
            }
        }
        if (this.isIdent()) {
            this.addTokenAndSkipWhitespace();
            if (this.isAndToken()) {
                this.addTokenAndSkipWhitespace();
                this.parseMediaExpressionList();
            } else if (this.isIdent()) {
                error = this.createCompositeElement();
                this.addIdentOrError();
                error.error(CssBundle.message((String)"parsing.error.and.expected", (Object[])new Object[0]));
                this.parseMediaExpressionList();
            }
        } else if (this.isCustomMediaQueryIdent(false)) {
            this.addCustomMediaQueryIdent();
            if (this.isAndToken()) {
                this.addTokenAndSkipWhitespace();
                this.parseMediaExpressionList();
            } else if (this.isIdent()) {
                error = this.createCompositeElement();
                this.addIdentOrError();
                error.error(CssBundle.message((String)"parsing.error.and.expected", (Object[])new Object[0]));
                this.parseMediaExpressionList();
            }
        } else if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.parseMediaExpressionList();
        }
        mediaQuery.done(CssElementTypes.CSS_MEDIA_QUERY);
        return true;
    }

    private void parseMediaExpressionList() {
        PsiBuilder.Marker expList = this.createCompositeElement();
        while (!this.isDone()) {
            this.parseMediaExpression();
            if (!this.isIdent() && !this.isCustomMediaQueryIdent(false) && !"and".equals(this.getTokenText())) break;
            this.addTokenAndSkipWhitespace();
        }
        expList.done(CssElementTypes.CSS_MEDIA_EXPRESSION_LIST);
    }

    private void parseMediaExpression() {
        PsiBuilder.Marker mediaExp = this.createCompositeElement();
        boolean result = false;
        PsiBuilder.Marker temp = this.createCompositeElement();
        if (this.isCustomMediaQueryIdent(true)) {
            result = this.addCustomMediaQueryIdent();
        }
        if (!result) {
            temp.rollbackTo();
            this.addLParenOrError();
            this.myIsMediaFeature = true;
            if (this.getTokenType() == RPAREN) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.media.feature.expected", (Object[])new Object[0]));
            } else {
                this.parseSingleDeclarationInBlock(false, true, false, CssElementTypes.CSS_MEDIA_FEATURE);
            }
            this.myIsMediaFeature = false;
            this.addRParenOrError();
        } else {
            temp.drop();
        }
        mediaExp.done(CssElementTypes.CSS_MEDIA_EXPRESSION);
    }

    protected boolean addLParenOrError() {
        return this.addTokenOrError(CssElementTypes.CSS_LPAREN, "'('");
    }

    protected boolean isCustomMediaQueryIdent(boolean insideMediaExpression) {
        return false;
    }

    protected boolean addCustomMediaQueryIdent() {
        this.addLParenOrError();
        this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        this.addRParenOrError();
        return true;
    }

    private boolean parseKeyframeSelectorList() {
        PsiBuilder.Marker selectorList = this.createCompositeElement();
        boolean result = this.parseKeyframesSelector();
        while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
            this.addTokenAndSkipWhitespace();
            if (this.parseKeyframesSelector()) continue;
            this.createErrorElement(CssBundle.message((String)"parsing.error.keyframes.selector.expected", (Object[])new Object[0]));
            break;
        }
        if (result) {
            selectorList.done((IElementType)CssElementTypes.CSS_SELECTOR_LIST);
        } else {
            selectorList.rollbackTo();
        }
        return result;
    }

    private boolean parseKeyframesSelector() {
        boolean result = false;
        PsiBuilder.Marker selector = this.createCompositeElement();
        PsiBuilder.Marker simpleSelector = this.createCompositeElement();
        if (this.getTokenType() == CssElementTypes.CSS_NUMBER) {
            this.addToken();
            if (this.addTokenOrError(CssElementTypes.CSS_PERCENT, "'%'")) {
                result = true;
            }
        } else if (this.isIdent()) {
            String tokenText = this.getTokenText();
            this.addIdentOrError();
            boolean bl = result = this.inKeyframesRuleset || (this.getTokenType() == LBRACE || this.getTokenType() == COMMA) && ("from".equals(tokenText) || "to".equals(tokenText));
        }
        if (result) {
            simpleSelector.done(CssElementTypes.CSS_KEYFRAMES_SELECTOR);
            selector.done((IElementType)CssElementTypes.CSS_SELECTOR);
        } else {
            simpleSelector.drop();
            selector.drop();
        }
        return result;
    }

    protected void parseSelectorList() {
        PsiBuilder.Marker selectorList = this.createCompositeElement();
        this.parseSelector();
        while (this.getTokenType() == COMMA) {
            this.addTokenAndSkipWhitespace();
            if (!this.isRulesetStart()) {
                if (this.isTrailingCommaInSelectorListAllowed()) break;
                this.createErrorElement(CssBundle.message((String)"parsing.error.selector.expected", (Object[])new Object[0]));
                break;
            }
            this.parseSelector();
        }
        selectorList.done((IElementType)CssElementTypes.CSS_SELECTOR_LIST);
    }

    protected boolean isTrailingCommaInSelectorListAllowed() {
        return false;
    }

    protected void parseSelector() {
        PsiBuilder.Marker selector = this.createCompositeElement();
        while (!this.isDone()) {
            this.parseSimpleSelector();
            if (SELECTORS_HIERARCHY_TOKENS.contains(this.getTokenType())) {
                this.addTokenAndSkipWhitespace();
            } else if (!this.isRulesetStart()) break;
            if (this.getTokenType() != LBRACE) continue;
        }
        selector.done((IElementType)CssElementTypes.CSS_SELECTOR);
    }

    protected void parseSimpleSelector() {
        PsiBuilder.Marker simpleSelector = this.createCompositeElement();
        boolean hasPrefix = false;
        if (this.isSimpleSelectorStart()) {
            if (this.isIdent()) {
                this.addIdentOrError();
            } else {
                this.addToken();
            }
            hasPrefix = true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_PIPE) {
            this.addToken();
            if (this.getTokenType() == CssElementTypes.CSS_ASTERISK) {
                this.addToken();
            } else {
                this.addIdentOrError();
            }
        }
        this.parseSelectorSuffixList(hasPrefix);
        simpleSelector.done((IElementType)CssElementTypes.CSS_SIMPLE_SELECTOR);
    }

    protected void parseSelectorSuffixList(boolean hasPrefix) {
        PsiBuilder.Marker selectorSuffixList = this.createCompositeElement();
        if (hasPrefix && this.getTokenType() != TokenType.BAD_CHARACTER && this.hasWhitespaceBefore()) {
            selectorSuffixList.done(CssElementTypes.CSS_SELECTOR_SUFFIX_LIST);
            selectorSuffixList.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
            return;
        }
        while (!this.isDone()) {
            PsiBuilder.Marker element;
            if (this.parseClass() || this.parseIdSelector() || this.parsePseudo() || this.parseAttribute()) {
                if (!this.hasWhitespaceBefore()) continue;
                break;
            }
            if (this.getTokenType() != TokenType.BAD_CHARACTER || (element = this.createRootErrorElement()) == null) break;
            this.addToken();
            element.error(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
            break;
        }
        selectorSuffixList.done(CssElementTypes.CSS_SELECTOR_SUFFIX_LIST);
        selectorSuffixList.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
    }

    @Override
    public boolean hasWhitespaceBefore() {
        this.myBuilder.getTokenType();
        return this.myBuilder.rawLookup(-1) == CssElementTypes.CSS_WHITE_SPACE;
    }

    protected boolean parseIdSelector() {
        if (this.getTokenType() != HASH) {
            return false;
        }
        PsiBuilder.Marker idSelector = this.createCompositeElement();
        this.addToken();
        idSelector.done((IElementType)CssElementTypes.CSS_ID_SELECTOR);
        return true;
    }

    protected boolean parseAttribute() {
        if (this.getTokenType() != LBRACKET) {
            return false;
        }
        PsiBuilder.Marker attribute = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseAttributeLSide();
        this.parseAttributeRSide();
        if (this.isIdent() && "i".equals(this.getTokenText())) {
            this.addSingleToken();
        }
        this.addTokenOrError(RBRACKET, "']'");
        attribute.done((IElementType)CssElementTypes.CSS_ATTRIBUTE);
        return true;
    }

    private boolean parseAttributeLSide() {
        if (!this.isIdent() && this.getTokenType() != CssElementTypes.CSS_PIPE && this.getTokenType() != CssElementTypes.CSS_ASTERISK) {
            return false;
        }
        if (this.isIdent()) {
            this.addIdentOrError();
        } else if (this.getTokenType() == CssElementTypes.CSS_ASTERISK) {
            if (this.myBuilder.lookAhead(1) != CssElementTypes.CSS_PIPE) {
                PsiBuilder.Marker error = this.myBuilder.mark();
                this.addToken();
                error.error(CssBundle.message((String)"parsing.error.unexpected.asterisk", (Object[])new Object[0]));
            } else {
                this.addToken();
            }
        }
        if (this.getTokenType() == CssElementTypes.CSS_PIPE) {
            this.addToken();
            this.addIdentOrError();
        }
        return true;
    }

    protected void parseAttributeRSide() {
        if (!CssElementTypes.ATTRIBUTE_OPERATORS.contains(this.getTokenType())) {
            return;
        }
        this.addTokenAndSkipWhitespace();
        PsiBuilder.Marker attributeRSide = this.createCompositeElement();
        if (!this.parseCssString()) {
            if (this.isIdent()) {
                this.addIdentOrError();
            } else {
                this.createErrorElement(CssBundle.message((String)"parsing.error.expected.string.or.identifier", (Object[])new Object[0]));
            }
        }
        attributeRSide.done(CssElementTypes.CSS_ATTRIBUTE_RSIDE);
    }

    protected boolean parsePseudo() {
        CssPseudoSelectorStubElementType pseudoType;
        if (this.getTokenType() != COLON) {
            return false;
        }
        PsiBuilder.Marker pseudo = this.createCompositeElement();
        this.addToken();
        if (!this.hasWhitespaceBefore() && this.getTokenType() == COLON) {
            this.addToken();
            pseudoType = CssElementTypes.CSS_PSEUDO_ELEMENT;
        } else {
            pseudoType = CssElementTypes.CSS_PSEUDO_CLASS;
        }
        IElementType tokenType = this.getTokenType();
        if (this.hasWhitespaceBefore()) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
            pseudo.done((IElementType)pseudoType);
            return true;
        }
        if (this.isIdent(tokenType)) {
            PsiBuilder.Marker possibleFunction = this.createCompositeElement();
            this.addIdentOrError();
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
                this.addTokenAndSkipWhitespace();
                this.parsePseudoTermList();
                this.addRParenOrError();
                possibleFunction.done(CssElementTypes.CSS_FUNCTION);
            } else {
                possibleFunction.drop();
            }
        } else if (tokenType == FUNCTION_TOKEN) {
            this.parsePseudoFunction();
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        }
        pseudo.done((IElementType)pseudoType);
        return true;
    }

    protected boolean parseClass() {
        if (this.getTokenType() != PERIOD) {
            return false;
        }
        PsiBuilder.Marker cssClass = this.createCompositeElement();
        this.addToken();
        if (!this.hasWhitespaceBefore()) {
            this.addIdentOrError();
        }
        cssClass.done((IElementType)CssElementTypes.CSS_CLASS);
        return true;
    }

    protected void createTermExpectedErrorElement() {
        this.createErrorElement(CssBundle.message((String)"parsing.error.term.expected", (Object[])new Object[0]));
    }

    protected void parseFilterTermList() {
        PsiBuilder.Marker filterTermList = this.createCompositeElement();
        PsiBuilder.Marker term = this.createCompositeElement();
        this.parseTermList(false, COMMA);
        if (this.getTokenType() != COMMA && !"progid".equalsIgnoreCase(this.getTokenText())) {
            term.drop();
            filterTermList.drop();
            return;
        }
        term.done(CssElementTypes.CSS_TERM);
        while (this.getTokenType() == COMMA || "progid".equalsIgnoreCase(this.getTokenText())) {
            if (this.getTokenType() == COMMA) {
                this.addTokenAndSkipWhitespace();
            }
            term = this.createCompositeElement();
            this.parseTermList(false, COMMA);
            term.done(CssElementTypes.CSS_TERM);
        }
        filterTermList.done(CssElementTypes.CSS_TERM_LIST);
    }

    protected boolean parseTermList(boolean strict, IElementType ... stopElements) {
        return this.parseTermList(strict, false, stopElements);
    }

    protected boolean parseTermList(boolean strict, boolean nameValuePairSyntax, IElementType ... stopElements) {
        TokenSet stopSet = stopElements.length > 0 ? TokenSet.create((IElementType[])stopElements) : TokenSet.EMPTY;
        PsiBuilder.Marker termList = this.createCompositeElement();
        boolean taken = this.parseTerm(strict, nameValuePairSyntax);
        if (!taken && strict) {
            this.createTermExpectedErrorElement();
        }
        boolean result = taken;
        while (!this.isDone()) {
            IElementType type = this.getTokenType();
            if (!(type != COMMA && type != CssElementTypes.CSS_SLASH || stopSet.contains(type))) {
                this.addTokenAndSkipWhitespace();
            }
            PsiBuilder.Marker lastTerm = this.createCompositeElement();
            if (this.parseTerm(strict, nameValuePairSyntax)) {
                if (!stopSet.contains(COLON) && this.getTokenType() == COLON) {
                    lastTerm.rollbackTo();
                    break;
                }
            } else {
                if (this.isDone() || this.isTermListFinished() || stopSet.contains(this.getTokenType())) {
                    lastTerm.drop();
                    break;
                }
                result = false;
                if (strict) {
                    this.createTermExpectedErrorElement();
                }
                this.addToken();
            }
            lastTerm.drop();
        }
        termList.done(CssElementTypes.CSS_TERM_LIST);
        if (!taken) {
            termList.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, emptyBeforeWithMoreThanOneWhiteSpaceR);
        }
        return result;
    }

    protected boolean isTermListFinished() {
        return this.isTermListFinished(this.getTokenType());
    }

    protected boolean isTermListFinished(IElementType type) {
        return type == SEMICOLON || type == RBRACE || type == IMPORTANT || type == RPAREN;
    }

    protected boolean _parseTerm(boolean strict, boolean nameValuePairSyntax) {
        IElementType tokenType = this.getTokenType();
        if (!this.isIdent(tokenType) && tokenType != HASH && tokenType != NUMBER && tokenType != MINUS && tokenType != PLUS && tokenType != STRING_TOKEN && tokenType != URI_START && tokenType != FUNCTION_TOKEN && tokenType != LBRACKET && tokenType != CssElementTypes.CSS_UNICODE_RANGE && tokenType != CssElementTypes.CSS_EXPRESSION) {
            return false;
        }
        PsiBuilder.Marker term = this.createCompositeElement();
        int minusOrPlusEndOffset = -1;
        if (tokenType == MINUS || tokenType == PLUS) {
            minusOrPlusEndOffset = this.myBuilder.rawTokenTypeStart(1);
            this.addSingleToken();
        }
        tokenType = this.getTokenType();
        if (!this.parseFunction(strict)) {
            if (this.isIdent(tokenType) || tokenType == HASH) {
                if (nameValuePairSyntax && this.lookAhead(1) == CssElementTypes.CSS_EQ) {
                    PsiBuilder.Marker termList = this.createCompositeElement();
                    PsiBuilder.Marker innerTerm = this.createCompositeElement();
                    this.addTokenAndSkipWhitespace();
                    innerTerm.done(CssElementTypes.CSS_TERM);
                    this.addTokenAndSkipWhitespace();
                    this.parseTerm(strict);
                    termList.done(CssElementTypes.CSS_TERM_LIST);
                } else {
                    this.addTokenAndSkipWhitespace();
                }
            } else if (tokenType == CssElementTypes.CSS_UNICODE_RANGE) {
                this.addSingleToken();
            } else {
                if (tokenType == LBRACKET) {
                    this.addSingleToken();
                    if (this.getTokenType() != RBRACKET) {
                        this.parseTermList(true, RBRACKET);
                    }
                    this.addTokenOrError(RBRACKET, "']'");
                    term.done(CssElementTypes.CSS_BRACKETED_LIST);
                    return true;
                }
                if (!(this.parseUri() || this.parseNumberTerm(minusOrPlusEndOffset) || this.parseCssString() || this.parseExpression() || tokenType == null)) {
                    this.createErrorElement(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
                    this.addToken();
                }
            }
        }
        term.done(CssElementTypes.CSS_TERM);
        return true;
    }

    protected boolean parseAttrFunction() {
        if (this.getTokenType() != CssElementTypes.CSS_FUNCTION_TOKEN || !"attr".equalsIgnoreCase(this.getTokenText())) {
            return false;
        }
        PsiBuilder.Marker function = this.createCompositeElement();
        this.addToken();
        this.addLParenOrError();
        PsiBuilder.Marker termList = this.createCompositeElement();
        PsiBuilder.Marker termAttr = this.createCompositeElement();
        PsiBuilder.Marker attribute = this.createCompositeElement();
        if (!this.parseAttributeLSide()) {
            termList.rollbackTo();
            this.createErrorElement(CssBundle.message((String)"parsing.error.attribute.name.expected", (Object[])new Object[0]));
            this.addRParenOrError();
            function.done(CssElementTypes.CSS_FUNCTION);
            return true;
        }
        attribute.done((IElementType)CssElementTypes.CSS_ATTRIBUTE);
        termAttr.done(CssElementTypes.CSS_TERM);
        if (this.getTokenType() != COMMA && this.getTokenType() != RPAREN) {
            if (this.getTokenType() == CssElementTypes.CSS_PERCENT) {
                PsiBuilder.Marker term = this.createCompositeElement();
                this.addToken();
                term.done(CssElementTypes.CSS_TERM);
            } else if (!this.parseTerm(false)) {
                this.myBuilder.error(CssBundle.message((String)"parsing.error.closing.parenthesis.expected", (Object[])new Object[0]));
            }
        }
        if (this.getTokenType() == COMMA) {
            this.addToken();
            this.parseTerm(true, false);
        }
        termList.done(CssElementTypes.CSS_TERM_LIST);
        this.addRParenOrError();
        function.done(CssElementTypes.CSS_FUNCTION);
        return true;
    }

    protected boolean parseFunctionAcceptingMathExpressions() {
        if (this.getTokenType() != CssElementTypes.CSS_FUNCTION_TOKEN) {
            return false;
        }
        String tokenText = this.getTokenText();
        if (tokenText == null) {
            return false;
        }
        String functionName = StringUtil.toLowerCase((String)CssPropertyUtil.getElementNameWithoutVendorPrefix(tokenText));
        if (!ArrayUtil.contains((String)functionName, (String[])new String[]{"calc", "max", "min", "clamp"})) {
            return false;
        }
        PsiBuilder.Marker function = this.createCompositeElement();
        this.addToken();
        this.addLParenOrError();
        PsiBuilder.Marker termList = this.createCompositeElement();
        this.getMathParser().parse();
        while (this.getTokenType() == COMMA) {
            this.addToken();
            this.getMathParser().parse();
        }
        termList.done(CssElementTypes.CSS_TERM_LIST);
        this.addRParenOrError();
        function.done(CssElementTypes.CSS_FUNCTION);
        return true;
    }

    protected CssMathParser getMathParser() {
        return this.MATH_PARSER;
    }

    private boolean parseTerm(boolean strict) {
        return this.parseTerm(strict, false);
    }

    private boolean parseTerm(boolean strict, boolean nameValuePairSyntax) {
        return this._parseTerm(strict, nameValuePairSyntax);
    }

    public boolean parseExpression() {
        if (this.getTokenType() != CssElementTypes.CSS_EXPRESSION) {
            return false;
        }
        PsiBuilder.Marker expression = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.addLParenOrError();
        PsiBuilder.Marker expressionParameter = this.createCompositeElement();
        this.parseExpressionTokenList();
        expressionParameter.done(CssElementTypes.CSS_EXPRESSION_PARAMETER);
        this.addRParenOrError();
        expression.done(CssElementTypes.CSS_EXPRESSION);
        return true;
    }

    public static boolean isCssExpressionType(IElementType type) {
        return type == CssElementTypes.CSS_COLON || type == CssElementTypes.CSS_EQ || type == CssElementTypes.CSS_GT || type == CssElementTypes.CSS_MINUS || type == CssElementTypes.CSS_PLUS || type == CssElementTypes.CSS_PERIOD || type == CssElementTypes.CSS_SLASH || type == CssElementTypes.CSS_BAD_CHARACTER || type == CssElementTypes.CSS_FUNCTION_TOKEN;
    }

    private void parseExpressionTokenList() {
        int openParen = 0;
        boolean afterFunction = false;
        while (!this.isDone()) {
            IElementType type = this.getTokenType();
            if (CssParser2.isCssExpressionType(type)) {
                this.addTokenAndSkipWhitespace();
                if (type != CssElementTypes.CSS_FUNCTION_TOKEN) continue;
                afterFunction = true;
                continue;
            }
            if (this.isIdent()) {
                this.addIdentOrError();
                continue;
            }
            type = this.getTokenType();
            if (type == CssElementTypes.CSS_LPAREN) {
                ++openParen;
                this.addToken();
                continue;
            }
            if (type == CssElementTypes.CSS_RPAREN) {
                if (openParen == 0) break;
                if (openParen <= 0) continue;
                --openParen;
                this.addToken();
                continue;
            }
            if (this.isDone() || (type == SEMICOLON || type == RBRACE) && !afterFunction) {
                if (openParen <= 0) break;
                this.addRParenOrError();
                break;
            }
            this.addToken();
        }
    }

    @Override
    public boolean parseFunction(boolean strict) {
        if (this.getTokenType() != FUNCTION_TOKEN) {
            return false;
        }
        if (this.parseAttrFunction() || this.parseFunctionAcceptingMathExpressions()) {
            return true;
        }
        PsiBuilder.Marker function = this.createCompositeElement();
        @NonNls String s = this.getTokenText();
        this.addToken();
        this.addTokenAndSkipWhitespace();
        if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
            this.parseTermList(strict, "Embed".equalsIgnoreCase(s), new IElementType[0]);
        }
        this.addRParenOrError();
        function.done(CssElementTypes.CSS_FUNCTION);
        return true;
    }

    protected boolean parsePseudoFunction() {
        if (this.getTokenType() != FUNCTION_TOKEN) {
            return false;
        }
        PsiBuilder.Marker function = this.createCompositeElement();
        this.addToken();
        this.addTokenAndSkipWhitespace();
        this.parsePseudoTermList();
        this.addRParenOrError();
        function.done(CssElementTypes.CSS_FUNCTION);
        return true;
    }

    protected boolean parsePseudoExpression() {
        if (!this.isIdent() && NUMBER != this.getTokenType() && PLUS != this.getTokenType() && MINUS != this.getTokenType()) {
            return false;
        }
        if (this.isIdent() && !"n".equalsIgnoreCase(this.getTokenText())) {
            return false;
        }
        PsiBuilder.Marker expression = this.createCompositeElement();
        boolean op = false;
        while (!this.isDone()) {
            IElementType tokenType = this.getTokenType();
            if (MINUS != tokenType && PLUS != tokenType && NUMBER != tokenType && !this.isIdent(tokenType)) {
                expression.done(CssElementTypes.CSS_EXPRESSION);
                return RPAREN == tokenType;
            }
            if (MINUS == tokenType || PLUS == tokenType) {
                this.addTokenAndSkipWhitespace();
                if (NUMBER == this.getTokenType()) {
                    this.addTokenAndSkipWhitespace();
                }
                if (this.isIdent()) {
                    this.addIdentOrError();
                }
                op = true;
                continue;
            }
            if (NUMBER == tokenType) {
                if (op) {
                    this.createErrorElement(CssBundle.message((String)"parsing.error.plus.or.minus.expected", (Object[])new Object[0]));
                }
                this.addTokenAndSkipWhitespace();
                if (this.isIdent()) {
                    this.addIdentOrError();
                }
                op = true;
                continue;
            }
            if (!this.isIdent()) continue;
            if (op) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.plus.or.minus.expected", (Object[])new Object[0]));
            }
            this.addIdentOrError();
        }
        expression.done(CssElementTypes.CSS_EXPRESSION);
        return false;
    }

    protected boolean parsePseudoTerm() {
        IElementType tokenType = this.getTokenType();
        if (!this.isIdent(tokenType) && !this.isSimpleSelectorStart() && tokenType != HASH && tokenType != PERIOD && tokenType != COLON && tokenType != LBRACKET && tokenType != NUMBER && tokenType != PLUS && tokenType != ASTERISK && tokenType != STRING_TOKEN && tokenType != MINUS) {
            return false;
        }
        PsiBuilder.Marker term = this.createCompositeElement();
        tokenType = this.getTokenType();
        if (!this.parsePseudoExpression()) {
            if (this.isIdent()) {
                this.addIdentOrError();
            } else if (this.isSimpleSelectorStart()) {
                if (this.isIdent()) {
                    this.addIdentOrError();
                } else {
                    this.addToken();
                }
            } else if (tokenType == HASH) {
                this.addTokenAndSkipWhitespace();
                this.parseAttribute();
            } else if (tokenType == STRING_TOKEN) {
                this.parseCssString();
            } else if (!(this.parseAttribute() || this.parsePseudo() || this.parseClass() || tokenType == null)) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
                this.addToken();
            }
        }
        term.done(CssElementTypes.CSS_TERM);
        return true;
    }

    private void parsePseudoTermList() {
        PsiBuilder.Marker termList = this.createCompositeElement();
        boolean taken = this.parsePseudoTerm();
        if (!taken) {
            this.createTermExpectedErrorElement();
        }
        while (!this.isDone()) {
            IElementType type = this.getTokenType();
            if (type == COMMA) {
                this.addTokenAndSkipWhitespace();
            }
            if (this.parsePseudoTerm()) continue;
            type = this.getTokenType();
            if (this.isDone() || type == SEMICOLON || type == RBRACE || type == IMPORTANT || type == RPAREN) break;
            this.createTermExpectedErrorElement();
            this.addToken();
        }
        termList.done(CssElementTypes.CSS_TERM_LIST);
    }

    private boolean parseJsfResource() {
        if (this.getTokenType() != CssElementTypes.CSS_URL) {
            return false;
        }
        String tokenText = this.getTokenText();
        if (tokenText == null || !tokenText.startsWith("#{")) {
            return false;
        }
        this.addToken();
        if (this.getTokenType() != STRING_TOKEN) {
            return true;
        }
        this.addToken();
        if (this.getTokenType() == CssElementTypes.CSS_URL && (tokenText = this.getTokenText()) != null && tokenText.endsWith("}")) {
            this.addToken();
        }
        return true;
    }

    protected boolean parseUriContent() {
        return false;
    }

    protected boolean parseUri() {
        if (this.getTokenType() != URI_START) {
            return false;
        }
        PsiBuilder.Marker uri = this.createCompositeElement();
        this.addToken();
        this.addLParenOrError();
        if (!(this.parseUriContent() || this.parseCssString() || this.parseJsfResource())) {
            if (this.getTokenType() == CssElementTypes.CSS_URL) {
                this.addToken();
            } else {
                this.createErrorElement(CssBundle.message((String)"parsing.error.url.or.string.expected", (Object[])new Object[0]));
            }
        }
        this.addRParenOrError();
        uri.done(CssElementTypes.CSS_URI);
        return true;
    }

    private boolean parseNumberTerm(int minusPlusEndOffset) {
        if (this.getTokenType() != NUMBER) {
            return false;
        }
        if (minusPlusEndOffset != -1 && minusPlusEndOffset != this.myBuilder.getCurrentOffset()) {
            return true;
        }
        PsiBuilder.Marker numberTerm = this.createCompositeElement();
        int numberEnd = this.myBuilder.rawTokenTypeStart(1);
        this.addToken();
        IElementType tokenType = this.getTokenType();
        int identStart = this.myBuilder.getCurrentOffset();
        if ((this.isIdent(tokenType) && tokenType != CssElementTypes.CSS_MINUS || tokenType == CssElementTypes.CSS_PERCENT) && numberEnd == identStart) {
            this.addToken();
        }
        numberTerm.done(CssElementTypes.CSS_NUMBER_TERM);
        return true;
    }

    public static void setDoSyntaxErrorReporting(boolean _doSyntaxErrorReporting) {
        doSyntaxErrorReporting = _doSyntaxErrorReporting;
    }

    public static boolean isSupportsClause(IElementType tokenType, String tokenText) {
        return tokenType == CssElementTypes.CSS_FUNCTION_TOKEN && "supports".equals(tokenText);
    }

    public boolean supportsNestedBlocks() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/parsing/CssParser2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/parsing/CssParser2";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleDeclarationInBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSupportsMultiConditions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

