/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssOperationImpl
extends CssElementImpl
implements CssOperation {
    protected CssOperationImpl(@NotNull IElementType operation) {
        if (operation == null) {
            CssOperationImpl.$$$reportNull$$$0(0);
        }
        super(operation);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssOperationImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssOperation((CssOperation)this);
            return;
        }
        super.accept(visitor);
    }

    @NotNull
    public CssTermType getTermType() {
        PsiElement firstTerm = this.getFirstChild();
        if (firstTerm != null && firstTerm.getNode().getElementType() == CssElementTypes.CSS_LPAREN) {
            firstTerm = firstTerm.getNextSibling();
        }
        if (this.getElementType() == CssElementTypes.CSS_UNARY_OPERATION) {
            PsiElement secondTerm = this.getSecondTerm();
            if (secondTerm instanceof CssTerm) {
                CssTermType cssTermType = ((CssTerm)secondTerm).getTermType();
                if (cssTermType == null) {
                    CssOperationImpl.$$$reportNull$$$0(2);
                }
                return cssTermType;
            }
        } else {
            PsiElement secondTerm = this.getSecondTerm();
            if (firstTerm instanceof CssTerm && secondTerm instanceof CssTerm) {
                IElementType operatorType;
                CssTermType leftType = CssOperationImpl.abs(((CssTerm)firstTerm).getTermType());
                CssTermType rightType = CssOperationImpl.abs(((CssTerm)secondTerm).getTermType());
                if (leftType == CssTermType.AS_NEEDED || rightType == CssTermType.AS_NEEDED) {
                    CssTermType cssTermType = CssTermType.AS_NEEDED;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(3);
                    }
                    return cssTermType;
                }
                if (leftType == CssTermType.UNKNOWN || rightType == CssTermType.UNKNOWN) {
                    CssTermType cssTermType = CssTermType.UNKNOWN;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(4);
                    }
                    return cssTermType;
                }
                if (leftType == CssTermTypes.PERCENTAGE) {
                    CssTermType cssTermType = CssOperationImpl.numberOrInteger(rightType) ? CssTermTypes.PERCENTAGE : rightType;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(5);
                    }
                    return cssTermType;
                }
                if (rightType == CssTermTypes.PERCENTAGE) {
                    CssTermType cssTermType = CssOperationImpl.numberOrInteger(leftType) ? CssTermTypes.PERCENTAGE : leftType;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(6);
                    }
                    return cssTermType;
                }
                PsiElement operator = this.getToken(CssMathParser.OPERATORS);
                IElementType iElementType = operatorType = operator != null ? operator.getNode().getElementType() : null;
                if (operatorType == CssElementTypes.CSS_MINUS || operatorType == CssElementTypes.CSS_PLUS) {
                    if (leftType == rightType) {
                        CssTermType cssTermType = leftType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(7);
                        }
                        return cssTermType;
                    }
                    if (leftType == CssTermTypes.NUMBER) {
                        CssTermType cssTermType = rightType == CssTermTypes.INTEGER ? CssTermTypes.NUMBER : rightType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(8);
                        }
                        return cssTermType;
                    }
                    if (rightType == CssTermTypes.NUMBER) {
                        CssTermType cssTermType = leftType == CssTermTypes.INTEGER ? CssTermTypes.NUMBER : leftType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(9);
                        }
                        return cssTermType;
                    }
                    if (leftType == CssTermTypes.INTEGER) {
                        CssTermType cssTermType = rightType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(10);
                        }
                        return cssTermType;
                    }
                    if (rightType == CssTermTypes.INTEGER) {
                        CssTermType cssTermType = leftType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(11);
                        }
                        return cssTermType;
                    }
                    if (leftType == CssTermTypes.VAR) {
                        CssTermType cssTermType = rightType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(12);
                        }
                        return cssTermType;
                    }
                    if (rightType == CssTermTypes.VAR) {
                        CssTermType cssTermType = leftType;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(13);
                        }
                        return cssTermType;
                    }
                    CssTermType cssTermType = CssTermType.UNKNOWN;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(14);
                    }
                    return cssTermType;
                }
                if (operatorType == CssElementTypes.CSS_ASTERISK) {
                    CssTermType cssTermType = CssOperationImpl.numberOrInteger(rightType) || rightType == CssTermTypes.VAR ? leftType : rightType;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(15);
                    }
                    return cssTermType;
                }
                if (operatorType == CssElementTypes.CSS_SLASH) {
                    if (rightType == CssTermTypes.NUMBER && leftType == CssTermTypes.INTEGER) {
                        CssTermType cssTermType = CssTermTypes.NUMBER;
                        if (cssTermType == null) {
                            CssOperationImpl.$$$reportNull$$$0(16);
                        }
                        return cssTermType;
                    }
                    CssTermType cssTermType = leftType;
                    if (cssTermType == null) {
                        CssOperationImpl.$$$reportNull$$$0(17);
                    }
                    return cssTermType;
                }
            }
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            CssOperationImpl.$$$reportNull$$$0(18);
        }
        return cssTermType;
    }

    @NotNull
    private static CssTermType abs(@NotNull CssTermType type) {
        if (type == null) {
            CssOperationImpl.$$$reportNull$$$0(19);
        }
        if (type == CssTermTypes.NEGATIVE_ANGLE) {
            CssTermType cssTermType = CssTermTypes.ANGLE;
            if (cssTermType == null) {
                CssOperationImpl.$$$reportNull$$$0(20);
            }
            return cssTermType;
        }
        if (type == CssTermTypes.NEGATIVE_LENGTH) {
            CssTermType cssTermType = CssTermTypes.LENGTH;
            if (cssTermType == null) {
                CssOperationImpl.$$$reportNull$$$0(21);
            }
            return cssTermType;
        }
        if (type == CssTermTypes.NEGATIVE_NUMBER) {
            CssTermType cssTermType = CssTermTypes.NUMBER;
            if (cssTermType == null) {
                CssOperationImpl.$$$reportNull$$$0(22);
            }
            return cssTermType;
        }
        if (type == CssTermTypes.NEGATIVE_PERCENTAGE) {
            CssTermType cssTermType = CssTermTypes.PERCENTAGE;
            if (cssTermType == null) {
                CssOperationImpl.$$$reportNull$$$0(23);
            }
            return cssTermType;
        }
        CssTermType cssTermType = type;
        if (cssTermType == null) {
            CssOperationImpl.$$$reportNull$$$0(24);
        }
        return cssTermType;
    }

    private static boolean numberOrInteger(CssTermType termType) {
        return termType == CssTermTypes.INTEGER || termType == CssTermTypes.NUMBER;
    }

    @Nullable
    private PsiElement getSecondTerm() {
        PsiElement secondTerm = this.getLastChild();
        if (secondTerm != null && secondTerm.getNode().getElementType() == CssElementTypes.CSS_RPAREN) {
            return (secondTerm = secondTerm.getPrevSibling()) instanceof PsiWhiteSpace ? secondTerm.getPrevSibling() : secondTerm;
        }
        return secondTerm;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssOperationImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssOperationImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTermType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "abs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "abs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

