/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectPusher;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CssDialectMappings", storages={@Storage(value="cssdialects.xml")})
public class CssDialectMappings
extends LanguagePerFileMappings<String> {
    public static final Key<String> CSS_DIALECT_NAME_KEY = Key.create((String)"CSS_LANGUAGE_DIALECT");
    private final CssDialectPusher myPusherInstance = new CssDialectPusher();

    public static CssDialectMappings getInstance(Project project) {
        return (CssDialectMappings)((Object)ServiceManager.getService((Project)project, CssDialectMappings.class));
    }

    protected FilePropertyPusher<String> getFilePropertyPusher() {
        return this.myPusherInstance;
    }

    public CssDialectMappings(Project project) {
        super(project);
    }

    protected String serialize(String dialectName) {
        return dialectName;
    }

    @NotNull
    public List<String> getAvailableValues() {
        List list = ContainerUtil.map((Collection)CssDialect.getAvailableDialects(), dialect -> dialect.getName());
        if (list == null) {
            CssDialectMappings.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Contract(value="null -> false")
    public boolean hasCustomDialect(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        String mapping = (String)this.getMapping(file);
        return mapping != null && !CssDialect.CLASSIC.getName().equals(mapping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/CssDialectMappings", "getAvailableValues"));
    }
}

