/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.javascript.debugger.nashorn.NashornJSBreakpointHandler;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandler;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandlerKt;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapCollector;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornJSBreakpointHandlerFactory;", "Lcom/intellij/debugger/engine/JavaBreakpointHandlerFactory;", "()V", "createHandler", "Lcom/intellij/debugger/engine/JavaBreakpointHandler;", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "intellij.javascript.nashorn.debugger"})
public final class NashornJSBreakpointHandlerFactory
implements JavaBreakpointHandlerFactory {
    @NotNull
    public JavaBreakpointHandler createHandler(@NotNull DebugProcessImpl process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        JSRootConfiguration jSRootConfiguration = JSRootConfiguration.getInstance((Project)process.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)jSRootConfiguration, (String)"JSRootConfiguration.getInstance(process.project)");
        if (jSRootConfiguration.getLanguageLevel() == JSLanguageLevel.NASHORN) {
            process.putUserData(NashornSourceMapHandlerKt.getNASHORN_SOURCE_MAP_HANDLER_KEY(), (Object)LazyKt.lazy((Function0)((Function0)new Function0<NashornSourceMapHandler>(process){
                final /* synthetic */ DebugProcessImpl $process;

                @Nullable
                public final NashornSourceMapHandler invoke() {
                    try {
                        PreloadedSourceMapList list = new PreloadedSourceMapList();
                        SourceMapCollector sourceMapCollector = new SourceMapCollector(list, true);
                        Project project = this.$process.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"process.project");
                        Path basePath = Paths.get(project.getBasePath(), new String[0]);
                        Project project2 = this.$process.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"process.project");
                        VirtualFile virtualFile = project2.getBaseDir();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"process.project.baseDir");
                        Url baseUrl = Urls.newLocalFileUrl((VirtualFile)virtualFile);
                        Path path = basePath;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"basePath");
                        SourceMapCollector.resolveSourcemaps$default((SourceMapCollector)sourceMapCollector, (Path)path, (Url)baseUrl, null, (boolean)false, (boolean)false, (int)0, (int)60, null);
                        Project project3 = this.$process.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"process.project");
                        return new NashornSourceMapHandler(project3, list);
                    }
                    catch (Exception e) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(NashornJSBreakpointHandlerFactory.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error((Throwable)e);
                        return null;
                    }
                }
                {
                    this.$process = debugProcessImpl;
                    super(0);
                }
            })));
        }
        return new NashornJSBreakpointHandler(process);
    }
}

