/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.JavaeeLogger;
import com.intellij.javaee.oss.util.FileWrapper;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryScanner {
    @Nullable
    private final Pattern pattern;

    protected DirectoryScanner(@NonNls String pattern) {
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
    }

    public void scan(@NonNls String dir, Class<?> ref) {
        try {
            File base = new File(PathUtil.getJarPathForClass(ref));
            if (base.isDirectory()) {
                this.scanDirectory(base, dir);
            } else if (base.exists()) {
                this.scanArchive(base, dir);
            }
        }
        catch (Throwable t) {
            JavaeeLogger.error(t);
        }
    }

    private void scanDirectory(File base, String dir) {
        File[] files = new File(base, dir).listFiles();
        if (files != null) {
            for (final File file : files) {
                if (this.pattern != null && !this.pattern.matcher(file.getName()).matches()) continue;
                try {
                    this.handle(new FileWrapper(file.getName(), "/" + dir + "/" + file.getName()){

                        @Override
                        public InputStream getStream() throws IOException {
                            return new FileInputStream(file);
                        }
                    });
                }
                catch (Throwable t) {
                    JavaeeLogger.error(t);
                }
            }
        }
    }

    private void scanArchive(File base, String dir) throws IOException {
        final ZipFile zip = new ZipFile(base);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            final ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.startsWith(dir)) continue;
            name = entry.getName().substring(name.lastIndexOf(47) + 1);
            if (this.pattern != null && !this.pattern.matcher(name).matches()) continue;
            try {
                this.handle(new FileWrapper(entry.getName().replaceFirst("(?:.*/)?(.*)", "$1"), "/" + entry.getName()){

                    @Override
                    public InputStream getStream() throws IOException {
                        return zip.getInputStream(entry);
                    }
                });
            }
            catch (Throwable t) {
                JavaeeLogger.error(t);
            }
        }
    }

    protected abstract void handle(FileWrapper var1) throws Exception;
}

