/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeePersistentDataEditor<T extends JavaeePersistentData>
extends ApplicationServerPersistentDataEditor<T> {
    private static final Logger LOG = Logger.getInstance(JavaeePersistentDataEditor.class);
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myHome;
    private JLabel myWarning;
    private JPanel myCustomPanelPlaceHolder;
    private JComponent myVersionComponent;
    private JPanel myValidationPanel;
    private JButton myFixButton;
    private String myServerVersion;
    private final JavaeeIntegration myIntegration;
    private VersionContribution myVersionContribution;
    private Runnable myQuickFix = null;

    public JavaeePersistentDataEditor(JavaeeIntegration integration) {
        super(() -> (JavaeePersistentData)integration.getApplicationServerHelper().createPersistentDataEmptyInstance());
        this.myIntegration = integration;
        this.$$$setupUI$$$();
        @NlsSafe String serverName = this.getServerName();
        for (Component component : this.myMainPanel.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel label = (JLabel)component;
            label.setText(MessageFormat.format(label.getText(), serverName));
        }
        this.myHome.addBrowseFolderListener(AppServersCommonBundle.getText("PersistentDataEditor.chooser.title", serverName), AppServersCommonBundle.getText("PersistentDataEditor.chooser.description", serverName), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myHome.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaeePersistentDataEditor.this.homeChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/oss/server/JavaeePersistentDataEditor$1", "textChanged"));
            }
        });
        this.myWarning.setIcon(AllIcons.General.BalloonError);
        this.updateWarning();
        this.myFixButton.setIcon(AllIcons.Actions.QuickfixBulb);
        this.myFixButton.addActionListener(e -> {
            if (this.myQuickFix != null) {
                this.myQuickFix.run();
            }
        });
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    protected void resetEditorFrom(@NotNull T settings) {
        if (settings == null) {
            JavaeePersistentDataEditor.$$$reportNull$$$0(0);
        }
        this.myHome.setText(((JavaeePersistentData)((Object)settings)).HOME);
        this.homeChanged();
    }

    protected void applyEditorTo(@NotNull T settings) {
        if (settings == null) {
            JavaeePersistentDataEditor.$$$reportNull$$$0(1);
        }
        ((JavaeePersistentData)((Object)settings)).HOME = this.myHome.getText();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            JavaeePersistentDataEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    protected String getServerName() {
        return this.getIntegration().getName();
    }

    private void homeChanged() {
        this.setVersion(this.getVersionContribution().detectVersion());
        this.updateWarning();
        this.onHomeChanged();
    }

    private void createUIComponents() {
        this.myVersionComponent = this.getVersionContribution().createVersionComponent();
    }

    protected JPanel getCustomPanelPlaceHolder() {
        return this.myCustomPanelPlaceHolder;
    }

    protected String getHome() {
        return this.myHome.getText();
    }

    protected void setHomePath(String homePath) {
        this.myHome.setText(homePath);
    }

    protected void onHomeChanged() {
    }

    protected boolean isValidHomeSelected() {
        return this.myServerVersion != null;
    }

    protected String getVersion() {
        return this.myServerVersion;
    }

    protected void setVersion(String version) {
        this.myServerVersion = version;
        this.myWarning.setVisible(version == null);
    }

    protected void showQuickFix(ConfigurationException exception) {
        this.myWarning.setText(JavaeePersistentDataEditor.generateWarningLabelText(exception));
        this.myQuickFix = exception.getQuickFix();
        this.myFixButton.setVisible(this.myQuickFix != null);
    }

    private VersionContribution getVersionContribution() {
        if (this.myVersionContribution == null) {
            this.myVersionContribution = this.createVersionContribution();
        }
        return this.myVersionContribution;
    }

    private void updateWarning() {
        this.myQuickFix = null;
        this.myWarning.setText(AppServersCommonBundle.getText("PersistentDataEditor.warning", this.getServerName()));
        this.myFixButton.setVisible(false);
    }

    @Nls
    private static String generateWarningLabelText(ConfigurationException exception) {
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)(exception.getTitle() + ": ")).bold()).append(HtmlChunk.text((String)exception.getMessage())).wrapWithHtmlBody().toString();
    }

    protected VersionContribution createVersionContribution() {
        return new SimpleVersionContribution();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/server/JavaeePersistentDataEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/server/JavaeePersistentDataEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHome = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(300, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/AppServersCommonBundle", JavaeePersistentDataEditor.class).getString("PersistentDataEditor.label.version"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/AppServersCommonBundle", JavaeePersistentDataEditor.class).getString("PersistentDataEditor.label.home"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomPanelPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JComponent jComponent = this.myVersionComponent;
        jPanel3.add((Component)jComponent, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myValidationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myWarning = jLabel = new JLabel();
        jLabel.setText("---");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 0, null, null, null));
        this.myFixButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/ExecutionBundle", JavaeePersistentDataEditor.class).getString("fix.run.configuration.problem.button"));
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class SimpleVersionContribution
    implements VersionContribution {
        private JLabel myVersionLabel;

        private SimpleVersionContribution() {
        }

        @Override
        public JComponent createVersionComponent() {
            return this.getVersionLabel();
        }

        @Override
        public String detectVersion() {
            JLabel versionLabel = this.getVersionLabel();
            try {
                @NlsSafe String result = JavaeePersistentDataEditor.this.getIntegration().detectVersion((JavaeePersistentData)((Object)JavaeePersistentDataEditor.this.getSnapshot()));
                versionLabel.setText(result);
                return result;
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                versionLabel.setText(AppServersCommonBundle.getText("PersistentDataEditor.unknown", new Object[0]));
                return null;
            }
        }

        private JLabel getVersionLabel() {
            if (this.myVersionLabel == null) {
                this.myVersionLabel = new JLabel();
            }
            return this.myVersionLabel;
        }
    }

    protected static interface VersionContribution {
        public JComponent createVersionComponent();

        @Nullable
        public String detectVersion();
    }
}

