/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.model.xml.application.JavaeeApplication;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaeeDeploymentProvider
extends DeploymentProvider {
    private static final DeploymentMethod[] METHODS = new DeploymentMethod[0];
    private final boolean deployArchivesOnly;

    public JavaeeDeploymentProvider() {
        this(false);
    }

    public JavaeeDeploymentProvider(boolean deployArchivesOnly) {
        this.deployArchivesOnly = deployArchivesOnly;
    }

    public DeploymentMethod[] getAvailableMethods() {
        return METHODS;
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return ((JavaeeIntegration)commonModel.getIntegration()).createNewDeploymentModel(commonModel, source);
    }

    public void doDeploy(Project project, J2EEServerInstance instance, DeploymentModel deployment) {
        ((JavaeeServerInstance)instance).deploy(deployment);
    }

    public void startUndeploy(J2EEServerInstance instance, DeploymentModel deployment) {
        ((JavaeeServerInstance)instance).undeploy(deployment);
    }

    public void cleanDeployments(J2EEServerInstance instance, List<DeploymentModel> deploymentModels) {
        ((JavaeeServerInstance)instance).cleanDeployments(deploymentModels);
    }

    public void updateDeploymentStatus(J2EEServerInstance instance, DeploymentModel deployment) {
        ((JavaeeServerInstance)instance).updateDeploymentStatus(deployment);
    }

    public Collection<? extends ArtifactType> getSupportedArtifactTypes() {
        if (this.deployArchivesOnly) {
            ArtifactType ear = JavaeeArtifactUtil.getInstance().getEarArtifactType();
            ArtifactType jar = JavaeeArtifactUtil.getInstance().getEjbJarArtifactType();
            ArtifactType war = WebArtifactUtil.getInstance().getWarArtifactType();
            return Arrays.asList(ear, jar, war);
        }
        return super.getSupportedArtifactTypes();
    }

    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return ((JavaeeIntegration)commonModel.getIntegration()).createAdditionalDeploymentSettingsEditor(commonModel, source);
    }

    @Nullable
    public static String getFacetDefinedDeploymentName(DeploymentModel deployment) {
        Artifact artifact = deployment.getArtifact();
        if (artifact == null) {
            return null;
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            JavaeeApplicationFacet appFacet;
            JavaeeApplication appRoot;
            Project project = deployment.getCommonModel().getProject();
            Collection appFacets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, artifact, JavaeeApplicationFacet.ID);
            if (!appFacets.isEmpty() && (appRoot = (appFacet = (JavaeeApplicationFacet)appFacets.iterator().next()).getRoot()) != null) {
                return (String)appRoot.getApplicationName().getValue();
            }
            return null;
        });
    }

    public static String getDefaultDeploymentName(DeploymentModel deployment) {
        return JavaeeDeploymentProvider.getDefaultDeploymentName(deployment, false);
    }

    public static String getDefaultDeploymentNameWithMinuses(DeploymentModel deployment) {
        return JavaeeDeploymentProvider.getDefaultDeploymentName(deployment, true);
    }

    private static String getDefaultDeploymentName(DeploymentModel deployment, boolean keepMinuses) {
        String facetDefinedName = JavaeeDeploymentProvider.getFacetDefinedDeploymentName(deployment);
        String originalName = facetDefinedName == null ? deployment.getDeploymentSource().getPresentableName() : facetDefinedName;
        String sanitizedName = FileUtil.sanitizeFileName((String)originalName);
        if (!keepMinuses) {
            return sanitizedName;
        }
        char[] chars = sanitizedName.toCharArray();
        for (int i = 0; i < sanitizedName.length(); ++i) {
            if (originalName.charAt(i) != '-' || chars[i] != '_') continue;
            chars[i] = 45;
        }
        return new String(chars);
    }
}

