/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.utils;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.utils.AppServerJavaeeModuleBuilderIntegration;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.facet.WebFacetImportCallback;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.supportProvider.AppServerSupportConfigurable;
import com.intellij.javaee.supportProvider.AppServerSupportContributor;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributor;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.externalSystem.project.PackagingModifiableModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppServerWebFacetImportCallback
implements WebFacetImportCallback {
    public void webFacetImported(Module module, IdeModifiableModelsProvider modelsProvider) {
        String appServerName = (String)module.getProject().getUserData(AppServerJavaeeModuleBuilderIntegration.APP_SERVER_NAME_KEY);
        if (appServerName == null) {
            return;
        }
        module.getProject().putUserData(AppServerJavaeeModuleBuilderIntegration.APP_SERVER_NAME_KEY, null);
        ApplicationServer server = ApplicationServersManager.getInstance().findByName(appServerName);
        if (server == null) {
            return;
        }
        ModifiableRootModel model = modelsProvider.getModifiableRootModel(module);
        RunnerAndConfigurationSettings settings = AppServerSupportConfigurable.addSupport(model, server, false);
        final ModifiableArtifactModel artifactModel = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getModifiableArtifactModel();
        boolean isGradleModule = ExternalSystemApiUtil.isExternalSystemAwareModule((String)"GRADLE", (Module)module);
        Object[] artifacts = artifactModel.getArtifacts();
        final Artifact artifact = (Artifact)ContainerUtil.find((Object[])artifacts, artifactItem -> {
            ArtifactType type = artifactItem.getArtifactType();
            if (isGradleModule) {
                return type instanceof JavaeeArtifactTypeBase && ((JavaeeArtifactTypeBase)type).isArchive();
            }
            return type instanceof JavaeeArtifactTypeBase && !((JavaeeArtifactTypeBase)type).isArchive();
        });
        if (artifact != null) {
            List<AppServerSupportContributor<? extends ServerModel>> contributors;
            final CommonModel configuration = (CommonModel)settings.getConfiguration();
            DeploymentSettings deploymentSettings = configuration.getDeploymentSettings();
            if (deploymentSettings != null) {
                deploymentSettings.getOrCreateModel(artifact);
            }
            if (!(contributors = AppServerWebFacetImportCallback.getAppServerSupportContributors()).isEmpty()) {
                AppServerSupportContributor.SetupSubject setupSubject = new AppServerSupportContributor.SetupSubject(){

                    @Override
                    @NotNull
                    public CommonModel getRunConfig() {
                        CommonModel commonModel = configuration;
                        if (commonModel == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return commonModel;
                    }

                    @Override
                    @Nullable
                    public Artifact findArtifactOfType(@NotNull ArtifactType type) {
                        if (type == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return type.equals(artifact.getArtifactType()) ? artifact : null;
                    }

                    @Override
                    @Nullable
                    public ModifiableArtifact findModifiableArtifactOfType(@NotNull ArtifactType type) {
                        if (type == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return type.equals(artifact.getArtifactType()) ? artifactModel.getOrCreateModifiableArtifact(artifact) : null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: 
                            case 2: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: 
                            case 2: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/javaee/appServers/utils/AppServerWebFacetImportCallback$1";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "type";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getRunConfig";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/javaee/appServers/utils/AppServerWebFacetImportCallback$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "findArtifactOfType";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "findModifiableArtifactOfType";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                for (AppServerSupportContributor<? extends ServerModel> next : contributors) {
                    next.setupServerRunConfiguration(setupSubject);
                }
            }
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)module.getProject(), (RunConfiguration)configuration, (Artifact)artifact);
        }
    }

    private static List<AppServerSupportContributor<? extends ServerModel>> getAppServerSupportContributors() {
        ArrayList<AppServerSupportContributor<? extends ServerModel>> result = new ArrayList<AppServerSupportContributor<? extends ServerModel>>();
        for (JavaeeFrameworkSupportContributor next : JavaeeFrameworkSupportContributor.EP_NAME.getExtensionList()) {
            if (!(next instanceof AppServerSupportContributor)) continue;
            AppServerSupportContributor impl = (AppServerSupportContributor)next;
            result.add(impl);
        }
        return result;
    }
}

