/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.localRun;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.localRun.CommandLineExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ParametersDialog;
import com.intellij.javaee.appServers.run.localRun.ScriptHelper;
import com.intellij.javaee.appServers.run.localRun.ScriptInfo;
import com.intellij.javaee.appServers.run.localRun.ScriptParser;
import com.intellij.javaee.appServers.run.localRun.UserScriptPanel;
import com.intellij.javaee.appServers.run.localRun.ViewTextDialog;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.Observable;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ScriptPanel
extends Observable {
    private final CardLayout myCardLayout = new CardLayout();
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JPanel myScriptsPanel = new JPanel(this.myCardLayout);
    @NonNls
    private static final String USER = "USER";
    @NonNls
    private static final String DEFAULT = "DEFAULT";
    private final TextFieldWithBrowseButton myDefaultScriptField;
    private final JCheckBox myUseDefault;
    private final UserScriptPanel myUserScript;
    private final boolean myIsStartup;
    @Nls
    private String myDefaultScript;
    private String myCurrentMode;
    private String myVMParameters = "";
    private String myUserScriptDefaultValue;

    public ScriptPanel(boolean startup) {
        this.myPanel.add((Component)this.myScriptsPanel, "Center");
        this.myIsStartup = startup;
        this.myUseDefault = new JCheckBox(AppServersIntegrationBundle.message((String)"checkbox.edit.script.properties.use.default", (Object[])new Object[0]));
        this.myPanel.add((Component)this.myUseDefault, "East");
        String title = startup ? AppServersIntegrationBundle.message((String)"dialog.title.select.startup.script", (Object[])new Object[0]) : AppServersIntegrationBundle.message((String)"dialog.title.select.shutdown.script", (Object[])new Object[0]);
        this.myUserScript = new UserScriptPanel(title, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myDefaultScriptField = new TextFieldWithBrowseButton();
        this.myDefaultScriptField.getTextField().setEnabled(false);
        this.myScriptsPanel.add((Component)this.myUserScript.getComponent(), USER);
        this.myScriptsPanel.add((Component)this.myDefaultScriptField, DEFAULT);
        this.myUserScript.addCustomizeParametersActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptParser scriptParser = ScriptPanel.this.myUserScript.createScriptParser();
                ParametersDialog parametersDialog = new ParametersDialog(ScriptPanel.this.myVMParameters, scriptParser.getParameters());
                if (parametersDialog.showAndGet()) {
                    ScriptPanel.this.myVMParameters = parametersDialog.getVMParameters();
                    ScriptPanel.this.myUserScript.setText(new ScriptParser(scriptParser.getPath(), parametersDialog.getProgramParameters()).combine());
                }
            }
        });
        this.myUseDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPanel.this.onUseDefault();
            }
        });
        this.myUserScript.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ScriptPanel.this.setModified();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScriptPanel.this.setModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScriptPanel.this.setModified();
            }
        });
        this.myDefaultScriptField.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        this.myDefaultScriptField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPanel.this.viewDefaultScript();
            }
        });
        Dimension minDin = new Dimension(100, -1);
        this.myDefaultScriptField.getTextField().setMinimumSize(minDin);
        this.myUserScript.getTextField().setMinimumSize(minDin);
    }

    private void onUseDefault() {
        this.updateScriptView();
        if (!this.myUseDefault.isSelected()) {
            this.transferDefaultValueToUserDefinedField();
        }
        this.setModified();
    }

    private void setModified() {
        this.setChanged();
        this.notifyObservers();
    }

    private void viewDefaultScript() {
        String title = this.myIsStartup ? AppServersIntegrationBundle.message((String)"dialog.title.default.startup.script", (Object[])new Object[0]) : AppServersIntegrationBundle.message((String)"dialog.title.default.shutdown.script", (Object[])new Object[0]);
        new ViewTextDialog(this.myDefaultScript, title).show();
    }

    private void updateScriptView() {
        if (this.myUseDefault.isSelected()) {
            this.show(DEFAULT);
        } else {
            this.show(USER);
        }
    }

    private void show(String mode) {
        if (Objects.equals(mode, this.myCurrentMode)) {
            return;
        }
        this.myCurrentMode = mode;
        this.myCardLayout.show(this.myScriptsPanel, mode);
    }

    public void updateFrom(ScriptInfo info, CommonModel commonModel) {
        boolean useDefault = info.USE_DEFAULT;
        this.myUseDefault.setSelected(useDefault);
        this.myDefaultScript = info.getDefaultScript();
        this.myDefaultScriptField.setText(this.myDefaultScript);
        this.myDefaultScriptField.setToolTipText(this.myDefaultScript);
        if (useDefault) {
            this.myUserScript.setText("");
            this.myUserScript.setInitialProgramParameters("");
        } else {
            this.myUserScript.setText(new ScriptParser(FileUtil.toSystemDependentName((String)info.SCRIPT), info.PROGRAM_PARAMETERS).combine());
            this.myUserScript.setInitialProgramParameters(info.PROGRAM_PARAMETERS);
        }
        boolean infoIsAvailable = info.infoIsAvailable();
        if (!infoIsAvailable) {
            this.myUseDefault.setSelected(false);
        }
        this.myUseDefault.setVisible(infoIsAvailable);
        this.myVMParameters = info.VM_PARAMETERS;
        this.updateScriptView();
        this.prepareDefaultValueOfUserDefinedField(info.getScriptHelper(), commonModel);
    }

    private void transferDefaultValueToUserDefinedField() {
        if (this.myUserScriptDefaultValue != null) {
            this.myUserScript.setText(this.myUserScriptDefaultValue);
        }
    }

    private void prepareDefaultValueOfUserDefinedField(@Nullable ScriptHelper scriptHelper, CommonModel commonModel) {
        CommandLineExecutableObject commandLineExecutableObject;
        String[] defaultScript;
        this.myUserScriptDefaultValue = null;
        if (scriptHelper == null) {
            return;
        }
        ExecutableObject defaultExecutableObject = scriptHelper.getDefaultScript(commonModel);
        if (defaultExecutableObject instanceof CommandLineExecutableObject && (defaultScript = (commandLineExecutableObject = (CommandLineExecutableObject)defaultExecutableObject).getParameters()) != null && defaultScript.length > 0) {
            String path = defaultScript[0];
            String parameters = "";
            if (defaultScript.length > 1) {
                String[] parametersExceptFirst = new String[defaultScript.length - 1];
                System.arraycopy(defaultScript, 1, parametersExceptFirst, 0, parametersExceptFirst.length);
                parameters = ScriptPanel.joinParameters(parametersExceptFirst);
            }
            this.myUserScriptDefaultValue = new ScriptParser(path, parameters).combine();
        }
    }

    private static String joinParameters(String[] parametersExceptFirst) {
        ParametersList parametersList = new ParametersList();
        for (String aParametersExceptFirst : parametersExceptFirst) {
            parametersList.add(aParametersExceptFirst);
        }
        return parametersList.getParametersString();
    }

    public void applyTo(ScriptInfo info) {
        boolean useDefault;
        info.USE_DEFAULT = useDefault = this.myUseDefault.isSelected() && this.myUseDefault.isVisible();
        if (useDefault) {
            info.SCRIPT = "";
            info.PROGRAM_PARAMETERS = "";
        } else {
            ScriptParser scriptParser = this.myUserScript.createScriptParser();
            info.SCRIPT = FileUtil.toSystemIndependentName((String)scriptParser.getPath());
            info.PROGRAM_PARAMETERS = scriptParser.getParameters();
        }
        info.VM_PARAMETERS = this.myVMParameters;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }
}

