/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.localRun;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ScriptHelper;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptInfo
implements JDOMExternalizable {
    public boolean USE_DEFAULT;
    public String SCRIPT;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    private final ScriptHelper myScriptsHelper;
    private final CommonStrategy myParent;
    private final boolean myStartupNotShutdown;

    public ScriptInfo(@Nullable ScriptHelper scriptsHelper, @NotNull CommonStrategy parent, boolean startupNotShutdown) {
        if (parent == null) {
            ScriptInfo.$$$reportNull$$$0(0);
        }
        this.USE_DEFAULT = true;
        this.SCRIPT = "";
        this.VM_PARAMETERS = "";
        this.PROGRAM_PARAMETERS = "";
        this.myScriptsHelper = scriptsHelper;
        this.myParent = parent;
        this.myStartupNotShutdown = startupNotShutdown;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        if (this.SCRIPT != null) {
            this.SCRIPT = FileUtil.toSystemIndependentName((String)this.SCRIPT);
        }
    }

    public void initRunnerSettings(RunConfigurationBase runConfiguration, RunnerSettings runnerSettings) {
        if (this.myScriptsHelper != null) {
            this.myScriptsHelper.initRunnerSettings(runConfiguration, runnerSettings);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Nullable
    public ExecutableObject getScript() {
        if (!this.USE_DEFAULT) {
            if ("".equals(this.SCRIPT)) {
                return null;
            }
            return new ColoredCommandLineExecutableObject(new String[]{FileUtil.toSystemDependentName((String)this.SCRIPT)}, this.PROGRAM_PARAMETERS);
        }
        if (this.myScriptsHelper != null) {
            return this.myScriptsHelper.getDefaultScript((CommonModel)this.myParent);
        }
        return null;
    }

    @Nls
    public String getDefaultScript() {
        if (this.myScriptsHelper != null) {
            ExecutableObject defaultScript = this.myScriptsHelper.getDefaultScript((CommonModel)this.myParent);
            if (defaultScript == null) {
                return "";
            }
            return defaultScript.getDisplayString();
        }
        return "";
    }

    public boolean infoIsAvailable() {
        return this.myScriptsHelper != null;
    }

    @Nullable
    public ScriptHelper getScriptHelper() {
        return this.myScriptsHelper;
    }

    public void checkConfiguration(RunConfigurationBase runConfiguration, RunnerSettings runnerSettings) throws RuntimeConfigurationException {
        if (!this.USE_DEFAULT && !new File(this.SCRIPT).exists()) {
            throw new RuntimeConfigurationWarning(this.myStartupNotShutdown ? AppServersIntegrationBundle.message((String)"ScriptInfo.error.startup.script.not.found", (Object[])new Object[0]) : AppServersIntegrationBundle.message((String)"ScriptInfo.error.shutdown.script.not.found", (Object[])new Object[0]));
        }
        if (this.myScriptsHelper != null && runnerSettings != null) {
            this.myScriptsHelper.checkRunnerSettings(runConfiguration, runnerSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/appServers/run/localRun/ScriptInfo", "<init>"));
    }
}

