/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.execution.update;

import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapUIImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.DeploysArtifactsOnStartupOnly;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.appServers.run.execution.update.HotSwapClassesUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.RedeployArtifactsUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.ReloadClassesAndResourcesUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.ReloadResourcesUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.RestartServerUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public final class UpdatingRunningApplicationUtil {
    private static final Logger LOG = Logger.getInstance(UpdatingRunningApplicationUtil.class);
    private static UpdatingPolicy[] ourPolicies;

    private UpdatingRunningApplicationUtil() {
    }

    @Nullable
    public static UpdatingPolicy findPolicy(@Nullable @NonNls String id) {
        if (id == null) {
            return null;
        }
        for (UpdatingPolicy updatingPolicy : UpdatingRunningApplicationUtil.getPolicies()) {
            if (!id.equals(updatingPolicy.getId())) continue;
            return updatingPolicy;
        }
        return null;
    }

    public static Collection<? extends UpdatingPolicy> getPolicies() {
        if (ourPolicies == null) {
            ourPolicies = new UpdatingPolicy[]{new HotSwapClassesUpdatingPolicy(), new ReloadResourcesUpdatingPolicy(), new ReloadClassesAndResourcesUpdatingPolicy(), new RedeployArtifactsUpdatingPolicy(), new RestartServerUpdatingPolicy()};
        }
        return Arrays.asList(ourPolicies);
    }

    public static Collection<? extends UpdatingPolicy> getAvailablePolicies(@Nullable Executor executor, @NotNull CommonModel commonModel, boolean onFrameDeactivation) {
        if (commonModel == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(0);
        }
        ArrayList<UpdatingPolicy> result = new ArrayList<UpdatingPolicy>();
        for (UpdatingPolicy updatingPolicy : UpdatingRunningApplicationUtil.getPolicies()) {
            if (executor != null && !updatingPolicy.isAvailableForExecutor(executor) || !updatingPolicy.isAvailableForConfiguration(commonModel) || onFrameDeactivation && !updatingPolicy.isAvailableOnFrameDeactivation()) continue;
            result.add(updatingPolicy);
        }
        return result;
    }

    public static Promise<ProjectTaskManager.Result> makeClasses(@NotNull Project project, @NotNull CommonModel commonModel, boolean onFrameDeactivation) {
        if (project == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(1);
        }
        if (commonModel == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(2);
        }
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts((Collection)commonModel.getDeployedArtifacts(), (Project)project);
        ProjectTask modulesBuildTask = ProjectTaskManager.getInstance((Project)project).createModulesBuildTask(modules.toArray(Module.EMPTY_ARRAY), true, true, false);
        return UpdatingRunningApplicationUtil.startCompilation(project, modulesBuildTask, onFrameDeactivation);
    }

    public static Promise<ProjectTaskManager.Result> startCompilation(@NotNull Project project, @NotNull ProjectTask projectTask, boolean onFrameDeactivation) {
        if (project == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(3);
        }
        if (projectTask == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(4);
        }
        ProjectTaskContext context = new ProjectTaskContext(onFrameDeactivation).withUserData(HotSwapUIImpl.SKIP_HOT_SWAP_KEY, (Object)true);
        return ProjectTaskManager.getInstance((Project)project).run(context, projectTask);
    }

    public static Promise<ProjectTaskManager.Result> makeClassesAndResources(Project project, CommonModel commonModel, boolean onFrameDeactivation) {
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts((Collection)commonModel.getDeployedArtifacts(), (Project)project);
        ProjectTask modulesBuildTask = ProjectTaskManager.getInstance((Project)project).createModulesBuildTask(modules.toArray(Module.EMPTY_ARRAY), true, true, false);
        ProjectTask buildArtifactsTask = ProjectTaskManager.getInstance((Project)project).createBuildTask(true, (ProjectModelBuildableElement[])commonModel.getArtifactsToBuild().toArray(new Artifact[0]));
        return UpdatingRunningApplicationUtil.startCompilation(project, (ProjectTask)new ProjectTaskList(Arrays.asList(modulesBuildTask, buildArtifactsTask)), onFrameDeactivation);
    }

    public static boolean isResourcesReloadingSupported(CommonModel commonModel) {
        CommonStrategy strategy = (CommonStrategy)commonModel;
        DeploymentProvider deploymentProvider = strategy.getDeploymentProvider();
        if (deploymentProvider == null) {
            ServerModel serverModel = strategy.getServerModel();
            if (serverModel instanceof DeploysArtifactsOnStartupOnly) {
                return ((DeploysArtifactsOnStartupOnly)serverModel).isResourcesReloadingSupported();
            }
            return false;
        }
        List<Artifact> deployedArtifacts = strategy.getDeployedArtifacts();
        if (deployedArtifacts.isEmpty()) {
            return false;
        }
        for (Artifact artifact : deployedArtifacts) {
            if (deploymentProvider.isResourcesReloadingSupported(commonModel, artifact.getArtifactType())) continue;
            return false;
        }
        return true;
    }

    public static boolean makeAndHotSwap(Project project, CommonModel commonModel, ProcessHandler processHandler, @Nullable Consumer<ProjectTaskManager.Result> consumer, boolean makeClassesOnly, boolean onFrameDeactivation) {
        DebuggerSession session;
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        DebugProcess process = debuggerManager.getDebugProcess(processHandler);
        if (process != null && (session = debuggerManager.getSession(process)) != null) {
            Consumer<ProjectTaskManager.Result> resultConsumer = result -> {
                try {
                    if (!project.isDisposed()) {
                        HotSwapUI.getInstance((Project)project).reloadChangedClasses(session, false);
                    }
                }
                finally {
                    if (consumer != null) {
                        consumer.accept((ProjectTaskManager.Result)result);
                    }
                }
            };
            if (makeClassesOnly) {
                UpdatingRunningApplicationUtil.makeClasses(project, commonModel, onFrameDeactivation).onSuccess(resultConsumer);
            } else {
                UpdatingRunningApplicationUtil.makeClassesAndResources(project, commonModel, onFrameDeactivation).onSuccess(resultConsumer);
            }
            return true;
        }
        return false;
    }

    public static void setupPolicyCombobox(JComboBox<UpdatingPolicy> combobox, CommonStrategy config, boolean onFrameDeactivation) {
        combobox.setRenderer((ListCellRenderer<UpdatingPolicy>)SimpleListCellRenderer.create((String)AppServersIntegrationBundle.message((String)"UpdatingRunningApplicationUtil.label.do.nothing", (Object[])new Object[0]), value -> UIUtil.removeMnemonic((String)value.getDescription())));
        UpdatingRunningApplicationUtil.updatePolicyCombobox(combobox, config, onFrameDeactivation);
    }

    public static Executor getExecutor(J2EEProcess process) {
        return UpdatingRunningApplicationUtil.getExecutor(process.getCommonStrategy().getProject(), (ProcessHandler)process);
    }

    @NotNull
    public static Executor getExecutor(Project project, ProcessHandler processHandler) {
        Executor executor;
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        DebugProcess debugProcess = debuggerManager.getDebugProcess(processHandler);
        if (debugProcess != null && debuggerManager.getSession(debugProcess) != null) {
            Executor executor2 = DefaultDebugExecutor.getDebugExecutorInstance();
            if (executor2 == null) {
                UpdatingRunningApplicationUtil.$$$reportNull$$$0(5);
            }
            return executor2;
        }
        if (processHandler instanceof J2EEProcessHandlerWrapper && (executor = ((J2EEProcessHandlerWrapper)processHandler).getExecutor()) != null) {
            Executor executor3 = executor;
            if (executor3 == null) {
                UpdatingRunningApplicationUtil.$$$reportNull$$$0(6);
            }
            return executor3;
        }
        Executor executor4 = DefaultRunExecutor.getRunExecutorInstance();
        if (executor4 == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(7);
        }
        return executor4;
    }

    public static boolean updatePolicyCombobox(JComboBox<UpdatingPolicy> combobox, CommonModel model, boolean onFrameDeactivation) {
        Object oldSelection = combobox.getSelectedItem();
        combobox.removeAllItems();
        if (onFrameDeactivation) {
            combobox.addItem(null);
        }
        Collection<? extends UpdatingPolicy> policies = UpdatingRunningApplicationUtil.getAvailablePolicies(null, model, onFrameDeactivation);
        for (UpdatingPolicy updatingPolicy : policies) {
            combobox.addItem(updatingPolicy);
        }
        combobox.setSelectedItem(oldSelection);
        if (combobox.getSelectedItem() == null && combobox.getItemCount() > 0) {
            combobox.setSelectedIndex(0);
        }
        return !policies.isEmpty();
    }

    public static void updateOpenedFilesAndStartCompilation(@NotNull Project project, List<Artifact> affectedArtifacts, @NotNull Runnable compileAction) {
        ArrayList<VirtualFile> files;
        if (project == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(8);
        }
        if (compileAction == null) {
            UpdatingRunningApplicationUtil.$$$reportNull$$$0(9);
        }
        LOG.debug("Quick in-process updating of resource files started");
        FileDocumentManager.getInstance().saveAllDocuments();
        List paths = BuildManager.getInstance().getFilesChangedSinceLastCompilation(project);
        if (paths != null) {
            files = new ArrayList();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (String path : paths) {
                ContainerUtil.addIfNotNull(files, (Object)fileSystem.findFileByPath(path));
            }
            UpdatingRunningApplicationUtil.logFiles(files, "changed since last compilation");
        } else {
            files = Arrays.asList(FileEditorManager.getInstance((Project)project).getSelectedFiles());
            UpdatingRunningApplicationUtil.logFiles(files, "opened in the editor");
        }
        if (files.isEmpty()) {
            compileAction.run();
        } else {
            PackageFileWorker.startPackagingFiles((Project)project, files, (Artifact[])affectedArtifacts.toArray(new Artifact[0]), (Runnable)compileAction);
        }
    }

    private static void logFiles(List<VirtualFile> files, String description) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating " + files.size() + " files, " + description);
            for (VirtualFile file : files) {
                LOG.debug(" " + file.getPath());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/run/execution/update/UpdatingRunningApplicationUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/run/execution/update/UpdatingRunningApplicationUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailablePolicies";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeClasses";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startCompilation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateOpenedFilesAndStartCompilation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

