/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.javaee.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.make.J2EECompilerManager;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeConsoleViewImpl;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.appServers.run.execution.JavaeePlainConsoleView;
import com.intellij.javaee.appServers.run.execution.update.SelectUpdatingPolicyDialog;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerStateListener;
import com.intellij.javaee.serverInstances.RunAppServerInstanceManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.util.net.NetUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance(ExecutionHelper.class);
    private final CommonStrategy myConfiguration;

    public ExecutionHelper(CommonStrategy configuration) {
        this.myConfiguration = configuration;
        J2EECompilerManager.getInstance(configuration.getProject());
    }

    public ConsoleView createConsole(J2EEProcess j2eeProcess, Executor executor) {
        GlobalSearchScope scope = GlobalSearchScopes.executionScope((Project)this.getProject(), (RunProfile)this.myConfiguration);
        ConsoleView plainConsole = TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), scope).getConsole();
        if (this.myConfiguration.getDeploymentProvider() == null) {
            return new JavaeePlainConsoleView(plainConsole, this.getIntegration(), j2eeProcess);
        }
        return new JavaeeConsoleViewImpl(this.getProject(), this.myConfiguration, j2eeProcess, executor, plainConsole);
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        AppServerDeployedFileUrlProvider urlProvider;
        final J2EEServerInstance newInstance = this.myConfiguration.createServerInstance();
        if (this.myConfiguration.getDeploymentProvider() != null) {
            final DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)this.getProject());
            final boolean needUndeployOnDisconnect = this.myConfiguration.getDeploymentProvider().isNeedUndeployOnDisconnect();
            new ServerStateWaiter(newInstance){

                @Override
                protected boolean isInState(J2EEServerEvent event) {
                    return event.isStateRunning();
                }

                @Override
                protected void onInState(J2EEServerInstance instance) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (needUndeployOnDisconnect) {
                            deploymentManager.initKeepDeployedAfterDisconnect(instance, (CommonModel)ExecutionHelper.this.myConfiguration);
                        }
                        deploymentManager.deployAllModules(instance, (CommonModel)ExecutionHelper.this.myConfiguration, false, null);
                    }, ExecutionHelper.this.getProject().getDisposed());
                }
            };
            if (needUndeployOnDisconnect) {
                new ServerStateWaiter(newInstance){

                    @Override
                    protected boolean isInState(J2EEServerEvent event) {
                        return event.isStateBeforeDisconnect();
                    }

                    @Override
                    protected void onInState(J2EEServerInstance instance) {
                        deploymentManager.undeployNonKeptModules(instance, (CommonModel)ExecutionHelper.this.myConfiguration);
                    }
                };
                new ServerStateWaiter(newInstance){

                    @Override
                    protected boolean isInState(J2EEServerEvent event) {
                        return event.isStateProcessKilled();
                    }

                    @Override
                    protected void onInState(J2EEServerInstance instance) {
                        deploymentManager.clean(instance, (CommonModel)ExecutionHelper.this.myConfiguration);
                    }
                };
            }
        }
        if ((urlProvider = this.getIntegration().getDeployedFileUrlProvider()) instanceof ApplicationServerUrlMapping) {
            final ApplicationServerUrlMapping urlMapping = (ApplicationServerUrlMapping)urlProvider;
            urlMapping.startTrackingServerInstance(newInstance);
            final JavaeeDeploymentListener deploymentListener = new JavaeeDeploymentListener(){

                public void deploymentStatusChanged(DeploymentModel model, DeploymentStatus newStatus, CommonModel runConfiguration) {
                    urlMapping.updateDeploymentContexts(newInstance, model, newStatus == DeploymentStatus.DEPLOYED);
                }
            };
            final DeploymentManagerEx deploymentManagerEx = DeploymentManagerEx.getInstanceEx(this.getProject());
            deploymentManagerEx.addDeploymentListener(newInstance, deploymentListener);
            new ServerStateWaiter(newInstance){

                @Override
                protected boolean isInState(J2EEServerEvent event) {
                    return event.isStateDisconnected();
                }

                @Override
                protected void onInState(J2EEServerInstance instance) {
                    deploymentManagerEx.removeDeploymentListener(newInstance, deploymentListener);
                    urlMapping.stopTrackingServerInstance(newInstance);
                }
            };
        }
        return newInstance;
    }

    public DefaultExecutionResult createExecutionResult(J2EEProcess j2eeProcess, Executor executor) {
        ConsoleView consoleView;
        ProcessHandler resultHandler = (ProcessHandler)j2eeProcess;
        resultHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            consoleView = this.createConsole(j2eeProcess, executor);
            consoleView.attachToProcess(resultHandler);
        } else {
            consoleView = null;
        }
        return new DefaultExecutionResult((ExecutionConsole)consoleView, resultHandler, new AnAction[]{ActionManager.getInstance().getAction("JavaeeRunToolWindowToolbar")});
    }

    private Project getProject() {
        return this.myConfiguration.getProject();
    }

    private AppServerIntegration getIntegration() {
        return this.myConfiguration.getIntegration();
    }

    public void checkAddressesAlreadyInUse(J2EEProcessHandlerWrapper processHandlerWrapper) throws CantRunException {
        List<Pair<String, Integer>> addresses = this.myConfiguration.getAddressesToCheck();
        for (Pair<String, Integer> pair : addresses) {
            String host = (String)pair.getFirst();
            int port = (Integer)pair.getSecond();
            String addressText = host + ":" + port;
            if (NetUtils.canConnectToSocket((String)host, (int)port)) {
                throw new CantRunException(AppServersIntegrationBundle.message((String)"exception.text.address.is.in.use", (Object[])new Object[]{addressText}));
            }
            if (!NetUtils.isLocalhost((String)host) || !NetUtils.canConnectToRemoteSocket((String)host, (int)port)) continue;
            processHandlerWrapper.showWarning(AppServersIntegrationBundle.message((String)"message.text.able.to.bind.yet.able.to.connect.too", (Object[])new Object[]{addressText}));
        }
    }

    public static RunConfiguration.RestartSingletonResult restart(@NotNull CommonStrategy configuration, @NotNull Executor executor) {
        RunAppServerInstanceManager runAppServerInstanceManager;
        J2EEServerInstance existingInstance;
        if (configuration == null) {
            ExecutionHelper.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            ExecutionHelper.$$$reportNull$$$0(1);
        }
        if ((existingInstance = (runAppServerInstanceManager = RunAppServerInstanceManager.getInstance((Project)configuration.getProject())).findInstance((CommonModel)configuration)) == null) {
            return RunConfiguration.RestartSingletonResult.RESTART;
        }
        ProcessHandler handler = runAppServerInstanceManager.findHandler(existingInstance);
        if (existingInstance.isStopped() || handler == null || handler.isProcessTerminating() || handler.isProcessTerminated()) {
            return RunConfiguration.RestartSingletonResult.RESTART;
        }
        String name = configuration.getName();
        Executor oldExecutor = UpdatingRunningApplicationUtil.getExecutor(configuration.getProject(), handler);
        if (!executor.equals(oldExecutor)) {
            String message = AppServersIntegrationBundle.message((String)"message.text.run.configuration.already.run.do.you.want.to.restart.in.1", (Object[])new Object[]{name, executor.getActionName()});
            int answer = Messages.showYesNoDialog((Project)configuration.getProject(), (String)message, (String)AppServersIntegrationBundle.message((String)"dialog.title.restart.server", (Object[])new Object[0]), null);
            if (answer == 0) {
                UpdatingPolicy policy = UpdatingRunningApplicationUtil.findPolicy("restart-server");
                LOG.assertTrue(policy != null);
                policy.runUpdate(configuration.getProject(), executor, existingInstance, handler, false);
            }
            return RunConfiguration.RestartSingletonResult.NO_FURTHER_ACTION;
        }
        Collection<? extends UpdatingPolicy> policies = UpdatingRunningApplicationUtil.getAvailablePolicies(executor, configuration, false);
        if (!policies.isEmpty()) {
            String description = AppServersIntegrationBundle.message((String)"message.text.run.configuration.already.run", (Object[])new Object[]{name});
            SelectUpdatingPolicyDialog dialog = new SelectUpdatingPolicyDialog(configuration.getProject(), name, description, false, policies, configuration.getUpdatingPolicy());
            dialog.show();
            if (dialog.getExitCode() == 0) {
                dialog.getSelectedPolicy().runUpdate(configuration.getProject(), executor, existingInstance, handler, false);
                RunContentManager.getInstance((Project)configuration.getProject()).toFrontRunContent(executor, handler);
            }
        }
        return RunConfiguration.RestartSingletonResult.NO_FURTHER_ACTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "executor";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/appServers/run/execution/ExecutionHelper";
        objectArray[2] = "restart";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class ServerStateWaiter {
        ServerStateWaiter(final J2EEServerInstance instance) {
            instance.addServerListener(new J2EEServerStateListener(){

                public void serverStateChanged(J2EEServerEvent event) {
                    if (this.isInState(event)) {
                        this.onInState(instance);
                        instance.removeServerListener((J2EEServerStateListener)this);
                    }
                }
            });
        }

        protected abstract boolean isInState(J2EEServerEvent var1);

        protected abstract void onInState(J2EEServerInstance var1);
    }
}

