/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration;

import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.EmptyEnvVarNameQuickFix;
import com.intellij.javaee.appServers.run.configuration.RunnerSpecificConfigurationBit;
import com.intellij.javaee.appServers.run.localRun.EnvironmentHelper;
import com.intellij.javaee.appServers.run.localRun.ScriptInfo;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RunnerSpecificLocalConfigurationBit
extends RunnerSpecificConfigurationBit {
    @NonNls
    private static final String ENV_VARIABLES = "EnvironmentVariables";
    @NonNls
    private static final String STARTUP_TAG = "STARTUP";
    @NonNls
    private static final String SHUTDOWN_TAG = "SHUTDOWN";
    @NonNls
    private static final String VM_VAR_NAME = "VM_VAR";
    private final List<EnvironmentVariable> myVariables = new ArrayList<EnvironmentVariable>();
    public boolean USE_ENV_VARIABLES = true;
    private final ScriptInfo myStartupInfo;
    private final ScriptInfo myShutdownInfo;
    private final EnvironmentVariable myVMEnvVariable = new EnvironmentVariable("", "", true){

        public String getValue() {
            return RunnerSpecificLocalConfigurationBit.this.getVMPatchedParameters();
        }

        public boolean isVisible() {
            EnvironmentHelper helper = RunnerSpecificLocalConfigurationBit.this.getHelper();
            return (helper == null || helper.isVmVariableVisible()) && this.getValue().length() > 0;
        }

        public String getName() {
            this.fixVMVariableName();
            return super.getName();
        }

        private void fixVMVariableName() {
            String vmOptsName;
            EnvironmentHelper helper = RunnerSpecificLocalConfigurationBit.this.getHelper();
            if (helper != null && (vmOptsName = helper.getDefaultJavaVmEnvVariableName((CommonModel)RunnerSpecificLocalConfigurationBit.this.getParentConfiguration())) != null && !helper.defaultVmVariableNameCanBeChangedByUser()) {
                this.setName(vmOptsName);
            }
        }

        public boolean getNameIsWriteable() {
            EnvironmentHelper helper = RunnerSpecificLocalConfigurationBit.this.getHelper();
            return helper != null && helper.defaultVmVariableNameCanBeChangedByUser();
        }

        public String getDescription() {
            return AppServersIntegrationBundle.message((String)"RunnerSpecificLocalConfigurationBit.tooltip.vm.options.are.read.only", (Object[])new Object[0]);
        }
    };

    @Nullable
    private EnvironmentHelper getHelper() {
        return this.getParentConfiguration().getHelper();
    }

    public RunnerSpecificLocalConfigurationBit(ConfigurationInfoProvider provider) {
        super(provider);
        String vmOptsName;
        CommonStrategy parentConfiguration = this.getParentConfiguration();
        this.myStartupInfo = new ScriptInfo(parentConfiguration.createStartupHelper(provider), parentConfiguration, true);
        this.myShutdownInfo = new ScriptInfo(parentConfiguration.createShutdownHelper(provider), parentConfiguration, false);
        EnvironmentHelper helper = this.getHelper();
        if (helper != null && (vmOptsName = helper.getDefaultJavaVmEnvVariableName((CommonModel)parentConfiguration)) != null && !helper.defaultVmVariableNameCanBeChangedByUser()) {
            this.myVMEnvVariable.setName(vmOptsName);
        }
    }

    @Override
    public RunnerSettings getRunnerSettings() {
        RunnerSettings runnerSettings = super.getRunnerSettings();
        if (runnerSettings instanceof GenericDebuggerRunnerSettings) {
            ((GenericDebuggerRunnerSettings)runnerSettings).setLocal(true);
        }
        return runnerSettings;
    }

    public List<EnvironmentVariable> getEnvVariables() {
        ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>();
        this.addPredefinedVariables(result);
        result.addAll(this.myVariables);
        return result;
    }

    private void addPredefinedVariables(Collection<EnvironmentVariable> result) {
        if (this.myVMEnvVariable.isVisible()) {
            result.add(this.myVMEnvVariable);
        }
    }

    private String getVMPatchedParameters() {
        JavaParameters parameters = this.createJavaParameters();
        try {
            this.getRunner().patch(parameters, this.getRunnerSettings(), (RunProfile)this.getParentConfiguration(), false);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return this.appendVMArguments(parameters);
    }

    public JavaParameters createJavaParameters() {
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(this.getParentConfiguration().getJre());
        return javaParameters;
    }

    public String appendVMArguments(JavaParameters parameters) {
        parameters.getVMParametersList().addParametersString(this.getParentConfiguration().getSettingsBean().COMMON_VM_ARGUMENTS);
        return parameters.getVMParametersList().getParametersString();
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.getParentConfiguration().expandServerModelMacros(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        RunnerSettings runnerSettings = this.getRunnerSettings();
        this.myStartupInfo.readExternal(element.getChild(STARTUP_TAG));
        this.myStartupInfo.initRunnerSettings((RunConfigurationBase)this.getParentConfiguration(), runnerSettings);
        this.myShutdownInfo.readExternal(element.getChild(SHUTDOWN_TAG));
        this.myShutdownInfo.initRunnerSettings((RunConfigurationBase)this.getParentConfiguration(), runnerSettings);
        List variables = element.getChildren(ENV_VARIABLES);
        for (Object variable : variables) {
            EnvironmentVariable environmentVariable = new EnvironmentVariable();
            environmentVariable.readExternal((Element)variable);
            this.myVariables.add(environmentVariable);
        }
        String vmName = element.getAttributeValue(VM_VAR_NAME);
        if (vmName != null) {
            this.myVMEnvVariable.setName(vmName);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        RunnerSpecificLocalConfigurationBit.write(element, STARTUP_TAG, this.myStartupInfo);
        RunnerSpecificLocalConfigurationBit.write(element, SHUTDOWN_TAG, this.myShutdownInfo);
        for (EnvironmentVariable variable : this.myVariables) {
            Element varElement = new Element(ENV_VARIABLES);
            element.addContent(varElement);
            variable.writeExternal(varElement);
        }
        element.setAttribute(VM_VAR_NAME, this.myVMEnvVariable.getName());
        this.getParentConfiguration().collapseServerModelMacros(element);
    }

    private static void write(Element element, String tag, ScriptInfo object) throws WriteExternalException {
        Element patcherElement = new Element(tag);
        object.writeExternal(patcherElement);
        element.addContent(patcherElement);
    }

    public void setEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.myVariables.clear();
        EnvironmentHelper helper = this.getHelper();
        boolean changeVMEnvName = helper != null && helper.defaultVmVariableNameCanBeChangedByUser();
        for (EnvironmentVariable environmentVariable : environmentVariables) {
            if (!environmentVariable.getIsPredefined()) {
                this.myVariables.add(environmentVariable);
                continue;
            }
            if (!changeVMEnvName) continue;
            this.myVMEnvVariable.setName(environmentVariable.getName());
        }
    }

    public Map<String, String> getEnvVarValues(ScriptInfo scriptInfo, boolean addPredefinedVars, String vmPatchedParameters) {
        String scriptVmParameters;
        HashMap<String, String> result = new HashMap<String, String>();
        String string = scriptVmParameters = scriptInfo.USE_DEFAULT ? "" : scriptInfo.VM_PARAMETERS;
        if (addPredefinedVars) {
            if (this.myVMEnvVariable.isVisible() || scriptVmParameters.length() > 0 || vmPatchedParameters.length() > 0) {
                result.put(this.myVMEnvVariable.getName(), vmPatchedParameters + " " + scriptVmParameters);
            }
        } else if (!scriptVmParameters.isEmpty()) {
            result.put(this.myVMEnvVariable.getName(), scriptVmParameters);
        }
        for (EnvironmentVariable variable : this.myVariables) {
            result.merge(variable.getName(), variable.getValue(), (oldValue, newValue) -> oldValue + " " + newValue);
        }
        return result;
    }

    public void putVmEnvVariable(JavaParameters parameters, Map<String, String> result) {
        String vmParameters = parameters.getVMParametersList().getParametersString();
        if (!vmParameters.isBlank()) {
            result.put(this.myVMEnvVariable.getName(), vmParameters);
        }
    }

    public ScriptInfo getStartupInfo() {
        return this.myStartupInfo;
    }

    public ScriptInfo getShutdownInfo() {
        return this.myShutdownInfo;
    }

    public void checkConfiguration(RunnerSettings runnerSettings) throws RuntimeConfigurationException {
        for (EnvironmentVariable environmentVariable : this.myVariables) {
            if (!StringUtil.isEmpty((String)environmentVariable.getName())) continue;
            throw new RuntimeConfigurationError(AppServersIntegrationBundle.message((String)"error.env.var.name.is.not.set", (Object[])new Object[0]), (Runnable)new EmptyEnvVarNameQuickFix((ProgramRunner)this.getRunner(), environmentVariable));
        }
        this.myStartupInfo.checkConfiguration((RunConfigurationBase)this.getParentConfiguration(), runnerSettings);
        this.myShutdownInfo.checkConfiguration((RunConfigurationBase)this.getParentConfiguration(), runnerSettings);
    }
}

