/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration;

import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.ide.DataManager;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.deployment.ui.DeploymentSettingsPanel;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.packaging.artifacts.Artifact;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkArtifactForDeploymentQuickFix
implements Runnable {
    private final Project myProject;
    private final DeploymentProvider myDeploymentProvider;

    public MarkArtifactForDeploymentQuickFix(Project project, DeploymentProvider deploymentProvider) {
        this.myProject = project;
        this.myDeploymentProvider = deploymentProvider;
    }

    @Nls
    public String getWarningMessage() {
        return this.getAvailableArtifacts().isEmpty() ? AppServersIntegrationBundle.message((String)"warning.no.artifacts.configured", (Object[])new Object[0]) : AppServersIntegrationBundle.message((String)"warning.no.artifacts.marked.for.deployment", (Object[])new Object[0]);
    }

    private List<Artifact> getAvailableArtifacts() {
        return DeploymentManager.getInstance((Project)this.myProject).getSupportedArtifacts(this.myDeploymentProvider);
    }

    @Override
    public void run() {
        DataContext context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
        if (context == null) {
            return;
        }
        final DeploymentSettingsPanel deploymentSettingsPanel = MarkArtifactForDeploymentQuickFix.selectDeploymentSettingsPanel(context);
        if (deploymentSettingsPanel == null) {
            return;
        }
        List<Artifact> availableArtifacts = this.getAvailableArtifacts();
        if (availableArtifacts.isEmpty()) {
            ModulesConfigurator.showArtifactSettings((Project)this.myProject, null);
            deploymentSettingsPanel.updateDeploymentModels();
            availableArtifacts = this.getAvailableArtifacts();
            if (availableArtifacts.isEmpty()) {
                return;
            }
        }
        if (availableArtifacts.size() == 1) {
            Artifact artifact = availableArtifacts.iterator().next();
            ApplicationManager.getApplication().invokeLater(() -> deploymentSettingsPanel.markForDeployment(artifact));
        } else {
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Artifact>(AppServersIntegrationBundle.message((String)"quickfix.popup.title.select.an.artifact.to.deploy", (Object[])new Object[0]), availableArtifacts){

                @NotNull
                public String getTextFor(Artifact value) {
                    String string = value.getName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(Artifact aValue) {
                    return aValue.getArtifactType().getIcon();
                }

                public PopupStep onChosen(Artifact selectedValue, boolean finalChoice) {
                    deploymentSettingsPanel.markForDeployment(selectedValue);
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/appServers/run/configuration/MarkArtifactForDeploymentQuickFix$1", "getTextFor"));
                }
            });
            listPopup.showInBestPositionFor(context);
        }
    }

    @Nullable
    private static DeploymentSettingsPanel selectDeploymentSettingsPanel(DataContext dataContext) {
        ConfigurationSettingsEditorWrapper editorWrapper = (ConfigurationSettingsEditorWrapper)ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.getData(dataContext);
        if (editorWrapper == null) {
            return null;
        }
        return (DeploymentSettingsPanel)editorWrapper.selectTabAndGetEditor(DeploymentSettingsPanel.class);
    }
}

