/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.appServers.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.appServers.run.configuration.JavaeeAppServerConfigurationType;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class J2EEConfigurationFactoryImpl
extends J2EEConfigurationFactory {
    public RunConfiguration createJ2EERunConfiguration(ConfigurationFactory factory, Project project, ServerModel serverSpecific, AppServerIntegration integration, boolean isLocal, JavaCommandLineStartupPolicy startupPolicy) {
        return integration.isDebugAllowed(isLocal) ? new CommonStrategy("", integration, project, factory, serverSpecific, isLocal, startupPolicy) : new CommonStrategyWithoutDefaultDebug("", integration, project, factory, serverSpecific, isLocal, startupPolicy);
    }

    public RunConfiguration createJ2EERunConfiguration(ConfigurationFactory factory, Project project, ServerModel serverSpecific, AppServerIntegration integration, boolean isLocal, ExecutableObjectStartupPolicy startupPolicy) {
        return integration.isDebugAllowed(isLocal) ? new CommonStrategy("", integration, project, factory, serverSpecific, isLocal, startupPolicy) : new CommonStrategyWithoutDefaultDebug("", integration, project, factory, serverSpecific, isLocal, startupPolicy);
    }

    public RunnerAndConfigurationSettings addAppServerConfiguration(@NotNull Project project, @NotNull ConfigurationFactory type, @NotNull ApplicationServer appServer) {
        if (project == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(1);
        }
        if (appServer == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(2);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings runSettings = runManager.createConfiguration(appServer.getName(), type);
        CommonStrategy configuration = (CommonStrategy)runSettings.getConfiguration();
        configuration.setApplicationServer(appServer);
        runManager.addConfiguration(runSettings);
        runManager.setSelectedConfiguration(runSettings);
        return runSettings;
    }

    public RunnerAndConfigurationSettings createSettingsByFile(@NotNull PsiFile psiFile, @NotNull JavaeeAppServerConfigurationType configurationType) {
        AppServerIntegration integration;
        if (psiFile == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(3);
        }
        if (configurationType == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(4);
        }
        if ((integration = configurationType.getIntegration()) == null) {
            return null;
        }
        List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{integration});
        if (servers.isEmpty()) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType != StdFileTypes.HTML && fileType != StdFileTypes.XHTML && fileType != StdFileTypes.JSP && fileType != StdFileTypes.JSPX) {
            return null;
        }
        Project project = psiFile.getProject();
        ApplicationServer server = (ApplicationServer)servers.get(0);
        String url = configurationType.getUrlToOpenInBrowser(server, psiFile);
        if (url == null) {
            return null;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(psiFile.getName(), configurationType.getLocalFactory());
        CommonStrategy configuration = (CommonStrategy)settings.getConfiguration();
        configuration.setApplicationServer(server);
        configuration.setUrlToOpenInBrowser(url);
        Collection artifacts = ArtifactBySourceFileFinder.getInstance((Project)project).findArtifacts(file);
        DeploymentProvider deploymentProvider = DeploymentManagerEx.getProvider(configuration);
        if (deploymentProvider != null) {
            Artifact toDeploy = null;
            for (Artifact artifact : artifacts) {
                if (!deploymentProvider.getSupportedArtifactTypes().contains(artifact.getArtifactType())) continue;
                toDeploy = artifact;
                break;
            }
            if (toDeploy == null) {
                return null;
            }
            configuration.getDeploymentSettings().getOrCreateModel(toDeploy);
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)configuration, toDeploy);
        }
        return settings;
    }

    public ConfigurationFactory createFactory(JavaeeAppServerConfigurationType type, boolean isLocal, String name, String id) {
        return new MyConfigurationFactory(type, isLocal, name, id);
    }

    public boolean isConfigurationApplicable(@NotNull JavaeeAppServerConfigurationType type, @NotNull Project project) {
        AppServerIntegration integration;
        if (type == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            J2EEConfigurationFactoryImpl.$$$reportNull$$$0(6);
        }
        return (integration = type.getIntegration()) == null || !ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{integration}).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appServer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/appServers/run/configuration/J2EEConfigurationFactoryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAppServerConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createSettingsByFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommonStrategyWithoutDefaultDebug
    extends CommonStrategy
    implements RunConfigurationWithSuppressedDefaultDebugAction {
        CommonStrategyWithoutDefaultDebug(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, ExecutableObjectStartupPolicy executablePolicy) {
            super(name, integration, project, factory, serverModel, isLocal, executablePolicy);
        }

        CommonStrategyWithoutDefaultDebug(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy) {
            super(name, integration, project, factory, serverModel, isLocal, javaPolicy);
        }
    }

    private static class MyConfigurationFactory
    extends ConfigurationFactory {
        private final boolean myIsLocal;
        private final String myName;
        private final JavaeeAppServerConfigurationType myType;
        private final String myId;

        MyConfigurationFactory(JavaeeAppServerConfigurationType type, boolean isLocal, String name, @NonNls String id) {
            super((ConfigurationType)type);
            this.myIsLocal = isLocal;
            this.myName = name;
            this.myType = type;
            this.myId = id;
        }

        @NotNull
        public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
            if (template == null) {
                MyConfigurationFactory.$$$reportNull$$$0(0);
            }
            RunConfiguration configuration = super.createConfiguration(name, template);
            ((CommonModel)configuration).initialize();
            RunConfiguration runConfiguration = configuration;
            if (runConfiguration == null) {
                MyConfigurationFactory.$$$reportNull$$$0(1);
            }
            return runConfiguration;
        }

        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                MyConfigurationFactory.$$$reportNull$$$0(2);
            }
            return J2EEConfigurationFactory.getInstance().isConfigurationApplicable(this.myType, project);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                MyConfigurationFactory.$$$reportNull$$$0(3);
            }
            RunConfiguration runConfiguration = this.myType.createJ2EEConfigurationTemplate((ConfigurationFactory)this, project, this.myIsLocal);
            if (runConfiguration == null) {
                MyConfigurationFactory.$$$reportNull$$$0(4);
            }
            return runConfiguration;
        }

        public Icon getIcon() {
            return this.myIsLocal ? this.myType.getLocalIcon() : this.myType.getRemoteIcon();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyConfigurationFactory.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                MyConfigurationFactory.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public RunConfigurationSingletonPolicy getSingletonPolicy() {
            RunConfigurationSingletonPolicy runConfigurationSingletonPolicy = RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
            if (runConfigurationSingletonPolicy == null) {
                MyConfigurationFactory.$$$reportNull$$$0(7);
            }
            return runConfigurationSingletonPolicy;
        }

        public boolean isEditableInDumbMode() {
            return this.myType.isEditableInDumbMode(this.myIsLocal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/appServers/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/appServers/run/configuration/J2EEConfigurationFactoryImpl$MyConfigurationFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfiguration";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingletonPolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createConfiguration";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

