/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.make;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class J2EECompilerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(J2EECompilerManager.class);
    private final Project myProject;
    private final FrameStateListener myJavaeeCompileRunnable;

    public static J2EECompilerManager getInstance(Project project) {
        return (J2EECompilerManager)ServiceManager.getService((Project)project, J2EECompilerManager.class);
    }

    public J2EECompilerManager(final @NotNull Project project) {
        if (project == null) {
            J2EECompilerManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myJavaeeCompileRunnable = new FrameStateListener(){

            public void onFrameDeactivated() {
                List<J2EEProcess> processes;
                CompilerManager compilerManager = CompilerManager.getInstance((Project)J2EECompilerManager.this.myProject);
                if (!(project.isDisposed() || !project.isInitialized() || compilerManager.isCompilationActive() || LaterInvocator.isInModalContext() || ProgressManager.getInstance().hasModalProgressIndicator() || (processes = J2EECompilerManager.getActiveJavaeeProcesses(J2EECompilerManager.this.myProject)).isEmpty())) {
                    J2EECompilerManager.this.makeJavaeeModules(processes);
                }
            }
        };
        this.setValidator(FrameStateManager.getInstance());
    }

    private static List<J2EEProcess> getActiveJavaeeProcesses(@Nullable Project project) {
        ProcessHandler[] processes;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<J2EEProcess> activeProcesses = new ArrayList<J2EEProcess>();
        for (ProcessHandler process : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (!(process instanceof J2EEProcess) || process.isProcessTerminated() || process.isProcessTerminating() || !process.isStartNotified()) continue;
            activeProcesses.add((J2EEProcess)process);
        }
        return activeProcesses;
    }

    private void makeJavaeeModules(List<J2EEProcess> processes) {
        try {
            for (J2EEProcess process : processes) {
                CommonStrategy strategy = process.getCommonStrategy();
                UpdatingPolicy policy = strategy.getUpdateOnFrameDeactivationPolicy();
                Executor executor = UpdatingRunningApplicationUtil.getExecutor(process);
                if (policy == null || !policy.isAvailableForConfiguration(strategy) || !policy.isAvailableForExecutor(executor) || !policy.isAvailableOnFrameDeactivation()) continue;
                policy.runUpdate(this.myProject, null, process.getServerInstance(), (ProcessHandler)process, true);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void setValidator(FrameStateManager saveAndSyncHandler) {
        this.registerCompilers(saveAndSyncHandler);
    }

    public void dispose() {
        this.unregisterCompilers();
    }

    public void unregisterCompilers() {
        FrameStateManager saveAndSyncHandler = FrameStateManager.getInstance();
        if (saveAndSyncHandler != null) {
            saveAndSyncHandler.removeListener(this.myJavaeeCompileRunnable);
        }
    }

    public void registerCompilers(FrameStateManager saveAndSyncHandler) {
        if (saveAndSyncHandler != null) {
            saveAndSyncHandler.addListener(this.myJavaeeCompileRunnable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/appServers/make/J2EECompilerManager", "<init>"));
    }
}

