/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.integration;

import com.intellij.DynamicBundle;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.impl.FrameworkTypeUtil;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.integration.ApplicationServersModelProvider;
import com.intellij.javaee.appServers.integration.ChooseModulesFromAllProjectsDialog;
import com.intellij.javaee.appServers.integration.impl.ApplicationServerImpl;
import com.intellij.javaee.appServers.integration.impl.ApplicationServersManagerImpl;
import com.intellij.javaee.appServers.utils.library.AppServerFrameworkLibraryProperties;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.supportProvider.AppServerFrameworkLibrariesFetcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerConfigurable
implements UnnamedConfigurable {
    private final ApplicationServerImpl myAppServerInstallation;
    private JPanel myPanel;
    private JTextField myName;
    private boolean myIsModified = false;
    private JPanel myServerSpecificSettings;
    private final ApplicationServerPersistentDataEditor<ApplicationServerPersistentData> myServerEditor;
    private boolean myIsInUpdating = false;
    private JLabel myNameLabel;
    private final ApplicationServersModelProvider myAppServersModelProvider;
    private List<FrameworkType> myAvailableFrameworks;
    private final LibraryRootsComponent myLibraryRootsComponent;
    private JPanel myLibrariesPanel;
    private CheckBoxList myFrameworksList;
    private JPanel myFrameworkLibrariesPanel;
    private final ExistingLibraryEditor myLibraryEditor;
    private final Map<FrameworkType, List<Module>> myTargetModulesForAddedLibraries;
    private AppServerLibrariesProvider myCurrentFrameworkLibrariesProvider;
    private Map<FrameworkType, List<File>> myFrameworkLibraries;

    public ApplicationServerConfigurable(ApplicationServerImpl applicationServer, ApplicationServersModelProvider appServersModelProvider) {
        this.$$$setupUI$$$();
        this.myAvailableFrameworks = Collections.emptyList();
        this.myTargetModulesForAddedLibraries = new HashMap<FrameworkType, List<Module>>();
        this.myFrameworkLibraries = Collections.emptyMap();
        this.myAppServersModelProvider = appServersModelProvider;
        this.myNameLabel.setLabelFor(this.myName);
        this.myAppServerInstallation = applicationServer;
        this.myServerEditor = this.createServerConfigurable();
        Library library = this.myAppServersModelProvider.getApplicationServersModel().getLibrary((ApplicationServer)this.myAppServerInstallation);
        this.myLibraryEditor = new ExistingLibraryEditor(library, null);
        Disposer.register(this.myServerEditor, (Disposable)this.myLibraryEditor);
        this.myLibraryRootsComponent = new LibraryRootsComponent(null, (LibraryEditor)this.myLibraryEditor);
        Disposer.register(this.myServerEditor, (Disposable)this.myLibraryRootsComponent);
        this.myFrameworkLibrariesPanel.setVisible(false);
        this.myServerEditor.addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<ApplicationServerPersistentData>(){

            public void stateChanged(@NotNull SettingsEditor<ApplicationServerPersistentData> settingsEditor) {
                if (settingsEditor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ApplicationServerConfigurable.this.myIsInUpdating) {
                    return;
                }
                ApplicationServerConfigurable.this.updateFrameworkLibrariesList();
                ApplicationServerConfigurable.this.myIsModified = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsEditor", "com/intellij/javaee/appServers/integration/ApplicationServerConfigurable$1", "stateChanged"));
            }
        });
        this.myServerSpecificSettings.setLayout(new BorderLayout());
        JComponent specificComponent = this.myServerEditor.getComponent();
        if (specificComponent != null) {
            this.myServerSpecificSettings.add(specificComponent);
            this.myServerSpecificSettings.setVisible(true);
        } else {
            this.myServerSpecificSettings.setVisible(false);
        }
        this.myLibrariesPanel.setLayout(new BorderLayout());
        this.myLibrariesPanel.add((Component)this.myLibraryRootsComponent.getComponent(), "Center");
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationServerConfigurable.this.myIsModified = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/appServers/integration/ApplicationServerConfigurable$2", "textChanged"));
            }
        });
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ApplicationServerConfigurable.this.updateName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/appServers/integration/ApplicationServerConfigurable$3", "textChanged"));
            }
        });
        this.updateFrameworkLibrariesList();
    }

    private void updateFrameworkLibrariesList() {
        AppServerLibrariesProvider provider = this.getFrameworkLibrariesProvider();
        if (Comparing.equal((Object)provider, (Object)this.myCurrentFrameworkLibrariesProvider)) {
            return;
        }
        if (provider == null) {
            this.updateFrameworkLibrariesList(Collections.emptyMap());
        } else {
            this.myFrameworksList.setEmptyText(AppServersIntegrationBundle.message((String)"ApplicationServerConfigurable.status.text.loading.available.libraries", (Object[])new Object[0]));
            AppServerFrameworkLibrariesFetcher.fetchLibraries(provider, map -> this.updateFrameworkLibrariesList((Map<FrameworkType, List<File>>)map));
        }
        this.myCurrentFrameworkLibrariesProvider = provider;
        this.myFrameworkLibrariesPanel.setVisible(provider != null);
    }

    private void updateFrameworkLibrariesList(@NotNull Map<FrameworkType, List<File>> frameworkLibraries) {
        if (frameworkLibraries == null) {
            ApplicationServerConfigurable.$$$reportNull$$$0(0);
        }
        this.myFrameworkLibraries = frameworkLibraries;
        this.myAvailableFrameworks = new ArrayList<FrameworkType>(frameworkLibraries.keySet());
        this.myFrameworksList.setEmptyText(AppServersIntegrationBundle.message((String)"ApplicationServerConfigurable.status.text.no.libraries.available", (Object[])new Object[0]));
        this.myAvailableFrameworks.sort(FrameworkTypeUtil.FRAMEWORK_TYPE_COMPARATOR);
        this.myFrameworksList.setItems(this.myAvailableFrameworks, frameworkType -> frameworkType.getPresentableName());
        for (FrameworkType type : this.myAvailableFrameworks) {
            this.myFrameworksList.setItemSelected((Object)type, this.myAppServerInstallation.getFrameworkLibrary(type) != null);
        }
    }

    @NlsSafe
    public String getCurrentServerName() {
        return this.myLibraryEditor.getName();
    }

    private void updateName() {
        this.myLibraryRootsComponent.renameLibrary(this.myName.getText());
    }

    @Nullable
    private ApplicationServerHelper getHelper() {
        AppServerIntegration serverIntegration = this.myAppServerInstallation.getSourceIntegration();
        return serverIntegration != null ? serverIntegration.getApplicationServerHelper() : null;
    }

    private ApplicationServerPersistentDataEditor<ApplicationServerPersistentData> createServerConfigurable() {
        ApplicationServerHelper helper = this.getHelper();
        if (helper == null) {
            return new NullApplicationServerPersistentDataEditor();
        }
        ApplicationServerPersistentDataEditor result = helper.createConfigurable();
        if (result == null) {
            return new NullApplicationServerPersistentDataEditor();
        }
        return result;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myIsModified || this.myLibraryEditor.hasChanges() || this.isFrameworkLibrariesModified();
    }

    private boolean isFrameworkLibrariesModified() {
        for (FrameworkType type : this.myFrameworkLibraries.keySet()) {
            boolean hasLibrary;
            boolean bl = hasLibrary = this.myAppServerInstallation.getFrameworkLibrary(type) != null;
            if (this.myFrameworksList.isItemSelected((Object)type) == hasLibrary) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myLibraryRootsComponent.applyProperties();
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myLibraryEditor.commit();
            ApplicationServersManager.ApplicationServersManagerModifiableModel serversModel = this.myAppServersModelProvider.getApplicationServersModel();
            for (Map.Entry<FrameworkType, List<File>> libraryEntry : this.myFrameworkLibraries.entrySet()) {
                FrameworkType type = libraryEntry.getKey();
                if (this.myFrameworksList.isItemSelected((Object)type)) {
                    List<File> files = libraryEntry.getValue();
                    if (files == null) continue;
                    Library library = serversModel.addFrameworkLibrary((ApplicationServer)this.myAppServerInstallation, type, files);
                    List<Module> modules = this.myTargetModulesForAddedLibraries.get(type);
                    if (modules == null) continue;
                    for (Module module : modules) {
                        ModuleRootModificationUtil.addDependency((Module)module, (Library)library, (DependencyScope)DependencyScope.PROVIDED, (boolean)false);
                    }
                    continue;
                }
                serversModel.removeFrameworkLibrary((ApplicationServer)this.myAppServerInstallation, type);
                for (Module module : this.getModulesDependingOnLibrary(type)) {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    for (OrderEntry entry : model.getOrderEntries()) {
                        if (!(entry instanceof LibraryOrderEntry) || !this.isAppServerFrameworkLibrary(((LibraryOrderEntry)entry).getLibrary(), type)) continue;
                        model.removeOrderEntry(entry);
                    }
                    model.commit();
                }
            }
        });
        this.myServerEditor.applyTo((Object)this.myAppServerInstallation.getPersistentData());
        this.myIsModified = false;
    }

    public void reset() {
        this.myIsInUpdating = true;
        try {
            this.myName.setText(this.myAppServerInstallation.getName());
            this.myLibraryRootsComponent.resetProperties();
            ApplicationServerPersistentData persistentData = this.myAppServerInstallation.getPersistentData();
            this.myServerEditor.resetFrom((Object)persistentData);
            this.updateFrameworkLibrariesList();
            this.myIsModified = false;
        }
        finally {
            this.myIsInUpdating = false;
        }
    }

    private AppServerLibrariesProvider getFrameworkLibrariesProvider() {
        AppServerIntegration integration = this.myAppServerInstallation.getSourceIntegration();
        ApplicationServerPersistentData persistentData = this.myAppServerInstallation.getPersistentData();
        if (integration == null || persistentData == null) {
            return null;
        }
        return integration.createLibrariesProvider(persistentData);
    }

    public void disposeUIResources() {
        Disposer.dispose(this.myServerEditor);
    }

    private void createUIComponents() {
        this.myFrameworksList = new CheckBoxList(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                FrameworkType type = (FrameworkType)ApplicationServerConfigurable.this.myFrameworksList.getItemAt(index);
                if (value) {
                    if (!ChooseModulesFromAllProjectsDialog.getAllModules().isEmpty()) {
                        ChooseModulesFromAllProjectsDialog dialog = new ChooseModulesFromAllProjectsDialog((Component)ApplicationServerConfigurable.this.myFrameworksList);
                        dialog.show();
                        ApplicationServerConfigurable.this.myTargetModulesForAddedLibraries.put(type, dialog.getChosenElements());
                    }
                } else {
                    List<Module> modules = ApplicationServerConfigurable.this.getModulesDependingOnLibrary(type);
                    if (!modules.isEmpty()) {
                        String place;
                        String string = place = modules.size() == 1 ? "module '" + modules.get(0).getName() + "'" : modules.size() + "modules";
                        if (0 != Messages.showYesNoDialog((Component)ApplicationServerConfigurable.this.myFrameworksList, (String)AppServersIntegrationBundle.message((String)"ApplicationServerConfigurable.warning.library.used.are.you.sure.to.delete", (Object[])new Object[]{ApplicationServersManagerImpl.getFrameworkLibraryName(ApplicationServerConfigurable.this.myAppServerInstallation, type), place}), (String)AppServersIntegrationBundle.message((String)"ApplicationServerConfigurable.title.delete.library", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) {
                            ApplicationServerConfigurable.this.myFrameworksList.setItemSelected((Object)type, true);
                        }
                    }
                }
            }
        });
    }

    @NotNull
    private List<Module> getModulesDependingOnLibrary(@NotNull FrameworkType type) {
        if (type == null) {
            ApplicationServerConfigurable.$$$reportNull$$$0(1);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                OrderEnumerator.orderEntries((Module)module).librariesOnly().forEachLibrary(library -> {
                    if (this.isAppServerFrameworkLibrary((Library)library, type)) {
                        modules.add(module);
                        return false;
                    }
                    return true;
                });
            }
        }
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            ApplicationServerConfigurable.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private boolean isAppServerFrameworkLibrary(@Nullable Library library, @NotNull FrameworkType type) {
        AppServerFrameworkLibraryProperties libraryProperties;
        if (type == null) {
            ApplicationServerConfigurable.$$$reportNull$$$0(3);
        }
        if (library == null) {
            return false;
        }
        LibraryProperties properties = ((LibraryEx)library).getProperties();
        return properties instanceof AppServerFrameworkLibraryProperties && (libraryProperties = (AppServerFrameworkLibraryProperties)properties).getFrameworkTypeId().equals(type.getId()) && libraryProperties.getServerName().equals(this.myAppServerInstallation.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkLibraries";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/integration/ApplicationServerConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/integration/ApplicationServerConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesDependingOnLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameworkLibrariesList";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModulesDependingOnLibrary";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAppServerFrameworkLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myName = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, 20), null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", ApplicationServerConfigurable.class).getString("label.application.server.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibrariesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", ApplicationServerConfigurable.class).getString("label.application.server.containing.libraries"), (int)0, (int)0, null, null));
        this.myServerSpecificSettings = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myFrameworkLibrariesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/AppServersIntegrationBundle", ApplicationServerConfigurable.class).getString("ApplicationServerConfigurable.title.additional.libraries.for.frameworks"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckBoxList checkBoxList = this.myFrameworksList;
        jBScrollPane.setViewportView((Component)checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class NullApplicationServerPersistentDataEditor
    extends ApplicationServerPersistentDataEditor<ApplicationServerPersistentData> {
        private NullApplicationServerPersistentDataEditor() {
        }

        public void resetEditorFrom(@NotNull ApplicationServerPersistentData applicationServerPersistentData) {
            if (applicationServerPersistentData == null) {
                NullApplicationServerPersistentDataEditor.$$$reportNull$$$0(0);
            }
        }

        public void applyEditorTo(@NotNull ApplicationServerPersistentData applicationServerPersistentData) {
            if (applicationServerPersistentData == null) {
                NullApplicationServerPersistentDataEditor.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public JComponent createEditor() {
            return new JPanel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "applicationServerPersistentData";
            objectArray2[1] = "com/intellij/javaee/appServers/integration/ApplicationServerConfigurable$NullApplicationServerPersistentDataEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetEditorFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyEditorTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

