/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.deployment.ui.DeploymentSettingsPanel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddModuleToDeployAction
extends AnAction {
    private final DeploymentSettingsPanel myPanel;

    public AddModuleToDeployAction(DeploymentSettingsPanel panel) {
        super(AppServersIntegrationBundle.messagePointer((String)"AddModuleToDeployAction.module", (Object[])new Object[0]), AllIcons.Nodes.Module);
        this.myPanel = panel;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddModuleToDeployAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(!this.getAvailableModules().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AddModuleToDeployAction.$$$reportNull$$$0(1);
        }
        Project project = this.myPanel.getProject();
        List<Module> supportedModules = this.getAvailableModules();
        if (supportedModules.size() == 1) {
            this.addModule(project, supportedModules.get(0));
            return;
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, supportedModules, AppServersIntegrationBundle.message((String)"AddModuleToDeployAction.title.select.modules.to.deploy", (Object[])new Object[0]), AppServersIntegrationBundle.message((String)"AddModuleToDeployAction.label.selected.modules.will.be.deployed", (Object[])new Object[0]));
        if (dialog.showAndGet()) {
            List chosen = dialog.getChosenElements();
            for (Module Module2 : chosen) {
                this.addModule(project, Module2);
            }
        }
    }

    private void addModule(Project project, Module Module2) {
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project).create(Module2);
        this.myPanel.addDeploymentModel((DeploymentSource)JavaeeDeploymentUtil.getInstance().createModuleDeploymentSource(pointer));
    }

    private List<Module> getAvailableModules() {
        Project project = this.myPanel.getProject();
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        ArrayList<Module> result = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
        result.removeAll(this.myPanel.getAddedModules());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/javaee/appServers/deployment/ui/actions/AddModuleToDeployAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

