/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.NettyKt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.AboutHttpServiceKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/ide/AboutHttpService;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "Lio/netty/handler/codec/http/HttpRequest;", "intellij.platform.builtInServer.impl"})
public final class AboutHttpService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        return "about";
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpRequestHandler.OriginCheckResult originAllowed = super.isOriginAllowed(request);
        if (originAllowed == HttpRequestHandler.OriginCheckResult.FORBID) {
            String string = NettyKt.getOrigin((HttpRequest)request);
            if (string == null) {
                return HttpRequestHandler.OriginCheckResult.FORBID;
            }
            String origin = string;
            CharSequence charSequence = origin;
            Regex regex = new Regex("https://([a-z0-9-]+\\.)*hyperskill.org$");
            boolean bl = false;
            return regex.matches(charSequence) ? HttpRequestHandler.OriginCheckResult.ALLOW : HttpRequestHandler.OriginCheckResult.FORBID;
        }
        return originAllowed;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        AboutHttpServiceKt.writeApplicationInfoJson((OutputStream)byteOut, urlDecoder, NettyKt.isLocalOrigin$default((HttpRequest)((HttpRequest)request), (boolean)false, (boolean)false, (int)3, null));
        RestService.Companion.send(byteOut, (HttpRequest)request, context);
        return null;
    }
}

