/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.xdebugger.impl.ui.InplaceEditor;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class TreeInplaceEditor
extends InplaceEditor {
    protected abstract TreePath getNodePath();

    protected abstract JTree getTree();

    @Override
    protected JComponent getHostComponent() {
        return this.getTree();
    }

    @Override
    protected void beforeShow() {
        this.getTree().scrollPathToVisible(this.getNodePath());
    }

    @Override
    @Nullable
    protected Rectangle getEditorBounds() {
        JTree tree = this.getTree();
        Rectangle bounds2 = tree.getVisibleRect();
        Rectangle nodeBounds = tree.getPathBounds(this.getNodePath());
        if (bounds2 == null || nodeBounds == null) {
            return null;
        }
        if (bounds2.y > nodeBounds.y || bounds2.y + bounds2.height < nodeBounds.y + nodeBounds.height) {
            return null;
        }
        bounds2.y = nodeBounds.y;
        bounds2.height = nodeBounds.height;
        if (nodeBounds.x > bounds2.x) {
            bounds2.width = bounds2.width - nodeBounds.x + bounds2.x;
            bounds2.x = nodeBounds.x;
        }
        return bounds2;
    }
}

