/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMapping;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMappingImpl;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMapping;", "externalStorageRoot", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "projectLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "(Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;)V", "getExternalStorageRoot", "()Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "getExternalSource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "internalSource", "intellij.platform.workspaceModel.ide"})
public final class JpsExternalStorageMappingImpl
implements JpsExternalStorageMapping {
    @NotNull
    private final VirtualFileUrl externalStorageRoot;
    private final VirtualFileUrlManager virtualFileManager;
    private final JpsProjectConfigLocation projectLocation;

    @Override
    @NotNull
    public JpsFileEntitySource getExternalSource(@NotNull JpsFileEntitySource internalSource) {
        String parentPath;
        String directoryName;
        Intrinsics.checkNotNullParameter((Object)internalSource, (String)"internalSource");
        JpsFileEntitySource jpsFileEntitySource = internalSource;
        if (jpsFileEntitySource instanceof JpsFileEntitySource.FileInDirectory) {
            String directoryPath = JpsPathUtil.urlToPath((String)((JpsFileEntitySource.FileInDirectory)internalSource).getDirectory().getUrl());
            String string = PathUtil.getFileName((String)directoryPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(directoryPath)");
            directoryName = string;
            String string2 = PathUtil.getParentPath((String)directoryPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.getParentPath(directoryPath)");
            parentPath = string2;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported internal entity source " + internalSource);
        }
        return Intrinsics.areEqual((Object)PathUtil.getFileName((String)parentPath), (Object)".idea") && (Intrinsics.areEqual((Object)directoryName, (Object)"libraries") || Intrinsics.areEqual((Object)directoryName, (Object)"artifacts")) ? (JpsFileEntitySource)new JpsFileEntitySource.ExactFile(VirtualFileUrlManagerUtil.append(this.getExternalStorageRoot(), "project/" + directoryName + ".xml", this.virtualFileManager), this.projectLocation) : (JpsFileEntitySource)new JpsFileEntitySource.FileInDirectory(VirtualFileUrlManagerUtil.append(this.getExternalStorageRoot(), "modules", this.virtualFileManager), this.projectLocation);
    }

    @Override
    @NotNull
    public VirtualFileUrl getExternalStorageRoot() {
        return this.externalStorageRoot;
    }

    public JpsExternalStorageMappingImpl(@NotNull VirtualFileUrl externalStorageRoot, @NotNull VirtualFileUrlManager virtualFileManager, @NotNull JpsProjectConfigLocation projectLocation) {
        Intrinsics.checkNotNullParameter((Object)externalStorageRoot, (String)"externalStorageRoot");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        Intrinsics.checkNotNullParameter((Object)projectLocation, (String)"projectLocation");
        this.externalStorageRoot = externalStorageRoot;
        this.virtualFileManager = virtualFileManager;
        this.projectLocation = projectLocation;
    }
}

