/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0001\u00a8\u0006\u000f"}, d2={"append", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "relativePath", "", "manager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "getInstance", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager$Companion;", "project", "Lcom/intellij/openapi/project/Project;", "isEqualOrParentOf", "", "other", "toPath", "Ljava/nio/file/Path;", "intellij.platform.workspaceModel.ide"})
@JvmName(name="VirtualFileUrlManagerUtil")
public final class VirtualFileUrlManagerUtil {
    @NotNull
    public static final VirtualFileUrlManager getInstance(@NotNull VirtualFileUrlManager.Companion $this$getInstance, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$getInstance, (String)"$this$getInstance");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(VirtualFileUrlManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (VirtualFileUrlManager)object;
    }

    @NotNull
    public static final VirtualFileUrl append(@NotNull VirtualFileUrl $this$append, @NotNull String relativePath, @NotNull VirtualFileUrlManager manager2) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"$this$append");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        return manager2.fromUrl($this$append.getUrl() + "/" + StringsKt.removePrefix((String)relativePath, (CharSequence)"/"));
    }

    public static final boolean isEqualOrParentOf(@NotNull VirtualFileUrl $this$isEqualOrParentOf, @NotNull VirtualFileUrl other) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrParentOf, (String)"$this$isEqualOrParentOf");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FileUtil.startsWith((String)other.getUrl(), (String)$this$isEqualOrParentOf.getUrl());
    }

    @NotNull
    public static final Path toPath(@NotNull VirtualFileUrl $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"$this$toPath");
        Path path = Paths.get(JpsPathUtil.urlToPath((String)$this$toPath.getUrl()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(JpsPathUtil.urlToPath(url))");
        return path;
    }
}

