/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LazyStubList
extends StubList {
    private final AtomicReferenceArray<StubBase<?>> myStubs;
    private final ObjectStubSerializer myRootSerializer;
    private int mySize;
    private final AtomicInteger myInstantiated = new AtomicInteger(1);
    private volatile LazyStubData myData;

    LazyStubList(int size, StubBase<?> root, ObjectStubSerializer rootSerializer) {
        super(size);
        this.myStubs = new AtomicReferenceArray(size);
        this.myRootSerializer = rootSerializer;
        this.myStubs.set(0, root);
        root.myStubList = this;
    }

    void addStub(@NotNull StubBase<?> stub, @Nullable StubBase<?> parent, @Nullable IStubElementType<?, ?> type) {
        if (stub == null) {
            LazyStubList.$$$reportNull$$$0(0);
        }
    }

    void addLazyStub(IElementType type, int childIndex, int parentIndex) {
        this.addStub(childIndex, parentIndex, type.getIndex());
        ++this.mySize;
    }

    boolean areChildrenNonAdjacent(int childId, int parentId) {
        return false;
    }

    public int size() {
        return this.mySize;
    }

    public StubBase<?> get(int index) {
        StubBase<?> stub = this.getCachedStub(index);
        if (stub != null) {
            return stub;
        }
        StubBase<?> newStub = this.instantiateStub(index);
        if (this.myStubs.compareAndSet(index, null, newStub)) {
            if (this.myInstantiated.incrementAndGet() == this.myStubs.length()) {
                this.myData = null;
            }
        } else {
            newStub = this.getCachedStub(index);
        }
        return newStub;
    }

    @Nullable
    StubBase<?> getCachedStub(int index) {
        return this.myStubs.get(index);
    }

    @NotNull
    private StubBase<?> instantiateStub(int index) {
        StubBase<?> stubBase;
        LazyStubData data2 = this.myData;
        if (data2 == null) {
            StubBase<?> stub = this.getCachedStub(index);
            if (stub != null) {
                StubBase<?> stubBase2 = stub;
                if (stubBase2 == null) {
                    LazyStubList.$$$reportNull$$$0(1);
                }
                return stubBase2;
            }
            throw new IllegalStateException("Not all (" + this.mySize + ") stubs are instantiated (" + this.myInstantiated + "), but data for them is missing");
        }
        try {
            StubBase<?> parent = this.get(data2.getParentIndex(index));
            StubBase<?> stub = data2.deserializeStub(index, parent, this.getStubType(index));
            stub.id = index;
            stubBase = stub;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Error | Exception e) {
            throw new RuntimeException(StubSerializationUtil.brokenStubFormat((ObjectStubSerializer)this.myRootSerializer), e);
        }
        if (stubBase == null) {
            LazyStubList.$$$reportNull$$$0(2);
        }
        return stubBase;
    }

    void setStubData(LazyStubData data2) {
        if (this.myInstantiated.get() < this.mySize) {
            this.myData = data2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/LazyStubList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/LazyStubList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addStub";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

