/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.scratch.RootType;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeBuilderImpl
extends ProjectScopeBuilder {
    @NotNull
    protected final Project myProject;

    public ProjectScopeBuilderImpl(@NotNull Project project) {
        if (project == null) {
            ProjectScopeBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public GlobalSearchScope buildEverythingScope() {
        return new EverythingGlobalScope(this.myProject){
            final FileBasedIndexImpl myFileBasedIndex;
            {
                boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                this.myFileBasedIndex = unitTestMode && !(fileBasedIndex instanceof FileBasedIndexImpl) ? null : (FileBasedIndexImpl)fileBasedIndex;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 instanceof VirtualFileWithId && this.myFileBasedIndex != null) {
                    for (IndexableFileSet set2 : this.myFileBasedIndex.getIndexableSets()) {
                        if (!set2.isInSet(file2) || !this.myFileBasedIndex.containsIndexableSet(set2, ProjectScopeBuilderImpl.this.myProject)) continue;
                        return true;
                    }
                    return false;
                }
                RootType rootType = RootType.forFile((VirtualFile)file2);
                return rootType == null || !rootType.isHidden() && !rootType.isIgnored(ProjectScopeBuilderImpl.this.myProject, file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/ProjectScopeBuilderImpl$1", "contains"));
            }
        };
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        ProjectAndLibrariesScope result2 = new ProjectAndLibrariesScope(this.myProject){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return this.myProjectFileIndex.isInLibrary(file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            @NotNull
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                Set<UnloadedModuleDescription> set2 = Collections.emptySet();
                if (set2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return set2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/search/ProjectScopeBuilderImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/search/ProjectScopeBuilderImpl$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedModulesBelongingToScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSearchInModuleContent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        result2.setDisplayName(LangBundle.message((String)"psi.search.scope.libraries", (Object[])new Object[0]));
        ProjectAndLibrariesScope projectAndLibrariesScope = result2;
        if (projectAndLibrariesScope == null) {
            ProjectScopeBuilderImpl.$$$reportNull$$$0(1);
        }
        return projectAndLibrariesScope;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        if (this.myProject.isDefault() || LightEdit.owns((Project)this.myProject)) {
            return new EverythingGlobalScope(this.myProject);
        }
        return new ProjectAndLibrariesScope(this.myProject){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2 instanceof ProjectAwareVirtualFile) {
                    return ((ProjectAwareVirtualFile)file2).isInProject(Objects.requireNonNull(this.getProject()));
                }
                DirectoryInfo info = ((ProjectFileIndexImpl)this.myProjectFileIndex).getInfoForFileOrDirectory(file2);
                return info.isInProject(file2) && (info.getModule() != null || info.hasLibraryClassRoot() || info.isInLibrarySource(file2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/ProjectScopeBuilderImpl$3", "contains"));
            }
        };
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        return new ProjectScopeImpl(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        return new CoreProjectScopeBuilder.ContentSearchScope(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/ProjectScopeBuilderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/ProjectScopeBuilderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLibrariesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

