/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFile containingFile, @NotNull Identikit.ByAnchor identikit) {
        if (anchor2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            AnchorElementInfo.$$$reportNull$$$0(1);
        }
        if (identikit == null) {
            AnchorElementInfo.$$$reportNull$$$0(2);
        }
        super(ProperTextRange.create((Segment)anchor2.getTextRange()), identikit, containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(3);
        }
        if (containingFile == null) {
            AnchorElementInfo.$$$reportNull$$$0(4);
        }
        if (stubElementType == null) {
            AnchorElementInfo.$$$reportNull$$$0(5);
        }
        super(null, Identikit.fromTypes(anchor2.getClass(), (IElementType)stubElementType, LanguageUtil.getRootLanguage((PsiElement)containingFile)), containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
    }

    private static long pack(int stubId, @Nullable IStubElementType stubElementType) {
        short index;
        short s = index = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager2) {
        long typeAndId;
        int stubId;
        if (manager2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(6);
        }
        if ((stubId = (int)(typeAndId = this.myStubElementTypeAndId)) != -1) {
            PsiFile file2 = this.restoreFile(manager2);
            if (!(file2 instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find((short)index);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file2, stubId, stubElementType, false);
        }
        return super.restoreElement(manager2);
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager2) {
        if (other == null) {
            AnchorElementInfo.$$$reportNull$$$0(7);
        }
        if (manager2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(8);
        }
        if (other instanceof AnchorElementInfo) {
            if (!this.getVirtualFile().equals(other.getVirtualFile())) {
                return false;
            }
            long packed1 = this.myStubElementTypeAndId;
            long packed2 = ((AnchorElementInfo)other).myStubElementTypeAndId;
            if (packed1 != -1L && packed2 != -1L) {
                return packed1 == packed2;
            }
            if (packed1 != -1L || packed2 != -1L) {
                return (Boolean)ReadAction.compute(() -> Comparing.equal((Object)this.restoreElement(manager2), (Object)other.restoreElement(manager2)));
            }
        }
        return super.pointsToTheSameElementAs(other, manager2);
    }

    @Override
    public void fastenBelt(@NotNull SmartPointerManagerImpl manager2) {
        if (manager2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(9);
        }
        if (this.getStubId() != -1) {
            this.switchToTree(manager2);
        }
        super.fastenBelt(manager2);
    }

    private void switchToTree(@NotNull SmartPointerManagerImpl manager2) {
        if (manager2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(10);
        }
        PsiElement element2 = this.restoreElement(manager2);
        SmartPointerTracker tracker2 = manager2.getTracker(this.getVirtualFile());
        if (element2 != null && tracker2 != null) {
            tracker2.switchStubToAst(this, element2);
        }
    }

    void switchToTreeRange(@NotNull PsiElement element2) {
        if (element2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(11);
        }
        this.switchToAnchor(element2);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    @Override
    public Segment getRange(@NotNull SmartPointerManagerImpl manager2) {
        if (manager2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(12);
        }
        if (this.getStubId() != -1) {
            this.switchToTree(manager2);
        }
        return super.getRange(manager2);
    }

    @Override
    @Nullable
    public TextRange getPsiRange(@NotNull SmartPointerManagerImpl manager2) {
        if (manager2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(13);
        }
        if (this.getStubId() != -1) {
            this.switchToTree(manager2);
        }
        return super.getPsiRange(manager2);
    }

    @Override
    public String toString() {
        return super.toString() + ",stubId=" + this.getStubId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identikit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElementType";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/smartPointers/AnchorElementInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "pointsToTheSameElementAs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fastenBelt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "switchToTree";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "switchToTreeRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

