/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.statusbar;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarPanel;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidgetFactory;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleStatusBarWidget
extends EditorBasedStatusBarPopup
implements CodeStyleSettingsListener {
    public static final String WIDGET_ID = CodeStyleStatusBarWidget.class.getName();
    private CodeStyleStatusBarPanel myPanel;

    public CodeStyleStatusBarWidget(@NotNull Project project) {
        if (project == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(0);
        }
        super(project, true);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                CodeStyleStatusBarWidget.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                CodeStyleStatusBarWidget.$$$reportNull$$$0(2);
            }
            return widgetState;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)psiFile);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)psiFile);
        if (settings instanceof TransientCodeStyleSettings) {
            EditorBasedStatusBarPopup.WidgetState widgetState = CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, CodeStyleStatusBarWidget.getUiContributor((TransientCodeStyleSettings)settings));
            if (widgetState == null) {
                CodeStyleStatusBarWidget.$$$reportNull$$$0(3);
            }
            return widgetState;
        }
        EditorBasedStatusBarPopup.WidgetState widgetState = CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, (CodeStyleStatusBarUIContributor)CodeStyleStatusBarWidget.getUiContributor(file2, indentOptions));
        if (widgetState == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(4);
        }
        return widgetState;
    }

    @Nullable
    private static CodeStyleStatusBarUIContributor getUiContributor(@NotNull TransientCodeStyleSettings settings) {
        CodeStyleSettingsModifier modifier;
        if (settings == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(5);
        }
        return (modifier = settings.getModifier()) != null ? modifier.getStatusBarUiContributor(settings) : null;
    }

    @Nullable
    private static IndentStatusBarUIContributor getUiContributor(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider provider2;
        if (file2 == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(6);
        }
        if (indentOptions == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(7);
        }
        if ((provider2 = CodeStyleStatusBarWidget.findProvider(file2, indentOptions)) != null) {
            return provider2.getIndentStatusBarUiContributor(indentOptions);
        }
        return null;
    }

    @Nullable
    private static FileIndentOptionsProvider findProvider(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider optionsProvider;
        if (file2 == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(8);
        }
        if (indentOptions == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(9);
        }
        if ((optionsProvider = indentOptions.getFileIndentOptionsProvider()) != null) {
            return optionsProvider;
        }
        for (FileIndentOptionsProvider provider2 : (FileIndentOptionsProvider[])FileIndentOptionsProvider.EP_NAME.getExtensions()) {
            IndentStatusBarUIContributor uiContributor = provider2.getIndentStatusBarUiContributor(indentOptions);
            if (uiContributor == null || !uiContributor.areActionsAvailable(file2)) continue;
            return provider2;
        }
        return null;
    }

    private static EditorBasedStatusBarPopup.WidgetState createWidgetState(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable CodeStyleStatusBarUIContributor uiContributor) {
        if (psiFile == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(10);
        }
        if (indentOptions == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(11);
        }
        if (uiContributor != null) {
            return new MyWidgetState(uiContributor.getTooltip(), uiContributor.getStatusText(psiFile), psiFile, indentOptions, uiContributor);
        }
        String indentInfo = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)indentOptions);
        String tooltip = IndentStatusBarUIContributor.createTooltip((String)indentInfo, null);
        return new MyWidgetState(tooltip, indentInfo, psiFile, indentOptions, null);
    }

    @Nullable
    private PsiFile getPsiFile() {
        Editor editor = this.getEditor();
        Project project = this.getProject();
        if (editor != null && !project.isDisposed()) {
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        return null;
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        EditorBasedStatusBarPopup.WidgetState state = this.getWidgetState((VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE));
        Editor editor = this.getEditor();
        PsiFile psiFile = this.getPsiFile();
        if (state instanceof MyWidgetState && editor != null && psiFile != null) {
            CodeStyleStatusBarUIContributor uiContributor = ((MyWidgetState)state).getContributor();
            final AnAction[] actions = CodeStyleStatusBarWidget.getActions(uiContributor, psiFile);
            ActionGroup actionGroup = new ActionGroup(){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    if (actions == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actions;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget$1", "getChildren"));
                }
            };
            return JBPopupFactory.getInstance().createActionGroupPopup(uiContributor != null ? uiContributor.getActionGroupTitle() : null, actionGroup, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }
        return null;
    }

    private static AnAction @NotNull [] getActions(@Nullable CodeStyleStatusBarUIContributor uiContributor, @NotNull PsiFile psiFile) {
        AnAction[] actions;
        if (psiFile == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(12);
        }
        ArrayList<Object> allActions = new ArrayList<Object>();
        if (uiContributor != null && (actions = uiContributor.getActions(psiFile)) != null) {
            allActions.addAll(Arrays.asList(actions));
        }
        if (uiContributor == null || uiContributor instanceof IndentStatusBarUIContributor && ((IndentStatusBarUIContributor)uiContributor).isShowFileIndentOptionsEnabled()) {
            allActions.add(CodeStyleStatusBarWidgetFactory.createDefaultIndentConfigureAction(psiFile));
        }
        if (uiContributor != null) {
            AnAction showAllAction;
            AnAction disabledAction = uiContributor.createDisableAction(psiFile.getProject());
            if (disabledAction != null) {
                allActions.add(disabledAction);
            }
            if ((showAllAction = uiContributor.createShowAllAction(psiFile.getProject())) != null) {
                allActions.add(showAllAction);
            }
        }
        AnAction[] anActionArray = allActions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(13);
        }
        return anActionArray;
    }

    @Override
    protected void registerCustomListeners() {
        Project project = this.getProject();
        ReadAction.nonBlocking(() -> CodeStyleSettingsManager.getInstance((Project)project)).expireWith((Disposable)project).finishOnUiThread(ModalityState.any(), manager2 -> {
            manager2.addListener((CodeStyleSettingsListener)this);
            Disposer.register((Disposable)this, () -> CodeStyleSettingsManager.removeListener((Project)project, (CodeStyleSettingsListener)this));
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (event == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(14);
        }
        this.update();
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        if (project == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(15);
        }
        return new CodeStyleStatusBarWidget(project);
    }

    @NotNull
    public String ID() {
        String string = WIDGET_ID;
        if (string == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    protected JPanel createComponent() {
        this.myPanel = new CodeStyleStatusBarPanel();
        return this.myPanel;
    }

    @Override
    protected void updateComponent(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        if (state == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(17);
        }
        this.myPanel.setIcon(state.getIcon());
        this.myPanel.setText(state.getText());
        this.myPanel.setToolTipText(state.getToolTip());
    }

    @Override
    protected boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myPanel.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUiContributor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createWidgetState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        @NotNull
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
        @Nullable
        private final CodeStyleStatusBarUIContributor myContributor;
        @NotNull
        private final PsiFile myPsiFile;

        protected MyWidgetState(@NlsContexts.Tooltip String toolTip, @NlsContexts.StatusBarText String text2, @NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable CodeStyleStatusBarUIContributor uiContributor) {
            if (psiFile == null) {
                MyWidgetState.$$$reportNull$$$0(0);
            }
            if (indentOptions == null) {
                MyWidgetState.$$$reportNull$$$0(1);
            }
            super(toolTip, text2, true);
            this.myIndentOptions = indentOptions;
            this.myContributor = uiContributor;
            this.myPsiFile = psiFile;
            if (uiContributor != null) {
                this.setIcon(uiContributor.getIcon());
            }
        }

        @Nullable
        public CodeStyleStatusBarUIContributor getContributor() {
            return this.myContributor;
        }

        @NotNull
        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myIndentOptions;
            if (indentOptions == null) {
                MyWidgetState.$$$reportNull$$$0(2);
            }
            return indentOptions;
        }

        @NotNull
        public PsiFile getPsiFile() {
            PsiFile psiFile = this.myPsiFile;
            if (psiFile == null) {
                MyWidgetState.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentOptions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget$MyWidgetState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget$MyWidgetState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndentOptions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

