/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.PlatformUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PlatformProjectViewOpener
implements DirectoryProjectConfigurator {
    PlatformProjectViewOpener() {
        if (PlatformUtils.isPyCharmEducational()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        if (project == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(2);
        }
        PlatformProjectViewOpener.openToolWindow(project, "Project");
        if (PlatformUtils.isDataGrip()) {
            PlatformProjectViewOpener.openToolWindow(project, "Database");
        }
    }

    private static void openToolWindow(@NotNull Project project, @NotNull String toolWindowId) {
        ToolWindow toolWindow;
        if (project == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(3);
        }
        if (toolWindowId == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(4);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId)) == null) {
            MyListener listener2 = new MyListener(project, toolWindowId);
            Disposer.register((Disposable)project, (Disposable)listener2);
            project.getMessageBus().connect((Disposable)listener2).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener2);
        } else {
            StartupManager.getInstance((Project)project).runAfterOpened(() -> PlatformProjectViewOpener.activateProjectToolWindow(project, toolWindow));
        }
    }

    private static void activateProjectToolWindow(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(5);
        }
        if (toolWindow == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            if (toolWindow.getType() != ToolWindowType.SLIDING) {
                toolWindow.activate(null);
            }
        }, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/PlatformProjectViewOpener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openToolWindow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "activateProjectToolWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyListener
    implements ToolWindowManagerListener,
    Disposable {
        private final Project myProject;
        private final String myToolWindowId;

        MyListener(@NotNull Project project, @NotNull String toolWindowId) {
            if (project == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            if (toolWindowId == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myToolWindowId = toolWindowId;
        }

        @Override
        public void toolWindowsRegistered(@NotNull List<String> id2, @NotNull ToolWindowManager toolWindowManager) {
            if (id2 == null) {
                MyListener.$$$reportNull$$$0(2);
            }
            if (toolWindowManager == null) {
                MyListener.$$$reportNull$$$0(3);
            }
            if (id2.contains(this.myToolWindowId)) {
                Disposer.dispose((Disposable)this);
                PlatformProjectViewOpener.activateProjectToolWindow(this.myProject, toolWindowManager.getToolWindow(this.myToolWindowId));
            }
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowManager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/PlatformProjectViewOpener$MyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toolWindowsRegistered";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

