/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarWidgetsOptionProvider
implements SearchTopHitProvider {
    public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (pattern == null) {
            StatusBarWidgetsOptionProvider.$$$reportNull$$$0(0);
        }
        if (collector == null) {
            StatusBarWidgetsOptionProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            return;
        }
        StatusBarWidgetsManager manager2 = (StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class));
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar == null) {
            return;
        }
        WordPrefixMatcher matcher = new WordPrefixMatcher(pattern);
        for (StatusBarWidgetFactory factory2 : manager2.getWidgetFactories()) {
            String name;
            if (!factory2.isConfigurable() || !factory2.isAvailable(project) || !manager2.canBeEnabledOnStatusBar(factory2, statusBar) || !matcher.matches(name = IdeBundle.message((String)"label.show.status.bar.widget", (Object[])new Object[]{factory2.getDisplayName()}))) continue;
            collector.accept((Object)new StatusBarWidgetOption(factory2, name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "collector";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsOptionProvider";
        objectArray[2] = "consumeTopHits";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StatusBarWidgetOption
    extends BooleanOptionDescription {
        private final StatusBarWidgetFactory myWidgetFactory;

        private StatusBarWidgetOption(StatusBarWidgetFactory factory2, @Nls String name) {
            super(name, "statusBar.show.widget." + factory2.getId());
            this.myWidgetFactory = factory2;
        }

        public boolean isOptionEnabled() {
            return ((StatusBarWidgetSettings)((Object)ApplicationManager.getApplication().getService(StatusBarWidgetSettings.class))).isEnabled(this.myWidgetFactory);
        }

        public void setOptionState(boolean enabled) {
            ((StatusBarWidgetSettings)((Object)ApplicationManager.getApplication().getService(StatusBarWidgetSettings.class))).setEnabled(this.myWidgetFactory, enabled);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(this.myWidgetFactory);
            }
        }
    }
}

