/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentFS
extends ManagingFS {
    public static PersistentFS getInstance() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    @NotNull
    protected <P, R> Function<P, R> accessDiskWithCheckCanceled(Function<? super P, ? extends R> function) {
        Function<Object, Object> function2 = new DiskQueryRelay<P, R>(function)::accessDiskWithCheckCanceled;
        if (function2 == null) {
            PersistentFS.$$$reportNull$$$0(0);
        }
        return function2;
    }

    public abstract void clearIdCache();

    public abstract String @NotNull [] listPersisted(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    @NotNull
    public abstract List<? extends ChildInfo> listAll(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    public abstract ChildInfo findChildInfo(@NotNull VirtualFile var1, @NotNull String var2, @NotNull NewVirtualFileSystem var3);

    public abstract String getName(int var1);

    public abstract long getLastRecordedLength(@NotNull VirtualFile var1);

    public abstract boolean isHidden(@NotNull VirtualFile var1);

    public abstract @Attributes int getFileAttributes(int var1);

    public static boolean isDirectory(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)2);
    }

    public static boolean isWritable(@Attributes int attributes) {
        return !BitUtil.isSet((int)attributes, (int)4);
    }

    public static boolean isSymLink(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)16);
    }

    public static boolean isSpecialFile(@Attributes int attributes) {
        return !PersistentFS.isDirectory(attributes) && BitUtil.isSet((int)attributes, (int)32);
    }

    public static boolean isHidden(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)64);
    }

    @NotNull
    public static FileAttributes.CaseSensitivity areChildrenCaseSensitive(@Attributes int attributes) {
        if (!PersistentFS.isDirectory(attributes)) {
            throw new IllegalArgumentException("CHILDREN_CASE_SENSITIVE flag defined for directories only but got file: 0b" + Integer.toBinaryString(attributes));
        }
        if (!BitUtil.isSet((int)attributes, (int)512)) {
            FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
            if (caseSensitivity == null) {
                PersistentFS.$$$reportNull$$$0(1);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity caseSensitivity = BitUtil.isSet((int)attributes, (int)256) ? FileAttributes.CaseSensitivity.SENSITIVE : FileAttributes.CaseSensitivity.INSENSITIVE;
        if (caseSensitivity == null) {
            PersistentFS.$$$reportNull$$$0(2);
        }
        return caseSensitivity;
    }

    @Nullable
    public abstract NewVirtualFile findFileByIdIfCached(int var1);

    public abstract int storeUnlinkedContent(byte @NotNull [] var1);

    public abstract byte @NotNull [] contentsToByteArray(int var1) throws IOException;

    public abstract byte @NotNull [] contentsToByteArray(@NotNull VirtualFile var1, boolean var2) throws IOException;

    public abstract int acquireContent(@NotNull VirtualFile var1);

    public abstract void releaseContent(int var1);

    public abstract int getCurrentContentId(@NotNull VirtualFile var1);

    public abstract void processEvents(@NotNull List<? extends VFileEvent> var1);

    @NotNull
    public static NewVirtualFileSystem replaceWithNativeFS(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFS.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isWindows && !(fs instanceof Win32LocalFileSystem) && fs.getProtocol().equals("file") && Win32LocalFileSystem.isAvailable()) {
            Win32LocalFileSystem win32LocalFileSystem = Win32LocalFileSystem.getWin32Instance();
            if (win32LocalFileSystem == null) {
                PersistentFS.$$$reportNull$$$0(4);
            }
            return win32LocalFileSystem;
        }
        NewVirtualFileSystem newVirtualFileSystem = fs;
        if (newVirtualFileSystem == null) {
            PersistentFS.$$$reportNull$$$0(5);
        }
        return newVirtualFileSystem;
    }

    public abstract boolean mayHaveChildren(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFS";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "accessDiskWithCheckCanceled";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "areChildrenCaseSensitive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFS";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithNativeFS";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithNativeFS";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Target(value={ElementType.TYPE_USE})
    public static @interface Attributes {
    }

    static class Flags {
        static final int CHILDREN_CACHED = 1;
        static final int IS_DIRECTORY = 2;
        static final int IS_READ_ONLY = 4;
        static final int MUST_RELOAD_CONTENT = 8;
        static final int IS_SYMLINK = 16;
        static final int IS_SPECIAL = 32;
        static final int IS_HIDDEN = 64;
        static final int MUST_RELOAD_LENGTH = 128;
        static final int CHILDREN_CASE_SENSITIVE = 256;
        static final int CHILDREN_CASE_SENSITIVITY_CACHED = 512;
        static final int ALL_VALID_FLAGS = 1023;

        Flags() {
        }
    }
}

