/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.FilePartNodeRoot;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePartNode {
    public static final FilePartNode[] EMPTY_ARRAY = new FilePartNode[0];
    static final int JAR_SEPARATOR_NAME_ID = -2;
    private final int nameId;
    FilePartNode @NotNull [] children;
    private Object leaves;
    @NotNull
    volatile Object myFileOrUrl;
    final NewVirtualFileSystem myFS;

    FilePartNode(int nameId, @NotNull Object fileOrUrl, @NotNull NewVirtualFileSystem fs) {
        if (fileOrUrl == null) {
            FilePartNode.$$$reportNull$$$0(0);
        }
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(1);
        }
        this.children = EMPTY_ARRAY;
        this.myFS = fs;
        assert (nameId > 0 || nameId == -2) : nameId + "; " + this.getClass();
        this.nameId = nameId;
        this.myFileOrUrl = fileOrUrl;
        if (fileOrUrl instanceof VirtualFile) {
            assert (this.myFile().getFileSystem() == this.myFS) : "myFs=" + this.myFS + "; myFile().getFileSystem()=" + this.myFile().getFileSystem() + "; " + fileOrUrl;
            if (this.myFile().getParent() == null && fs instanceof ArchiveFileSystem) assert (nameId == -2) : nameId;
        }
    }

    private VirtualFile myFile() {
        return FilePartNode.myFile(this.myFileOrUrl);
    }

    void addLeaf(@NotNull VirtualFilePointerImpl pointer) {
        Object leaves;
        if (pointer == null) {
            FilePartNode.$$$reportNull$$$0(2);
        }
        Object[] newLeaves = (leaves = this.leaves) == null ? pointer : (leaves instanceof VirtualFilePointerImpl ? new VirtualFilePointerImpl[]{(VirtualFilePointerImpl)leaves, pointer} : ArrayUtil.append((Object[])((VirtualFilePointerImpl[])leaves), (Object)pointer));
        this.associate(newLeaves);
    }

    int removeLeaf(@NotNull VirtualFilePointerImpl pointer) {
        Object leaves;
        if (pointer == null) {
            FilePartNode.$$$reportNull$$$0(3);
        }
        if ((leaves = this.leaves) == null) {
            return 0;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            if (leaves == pointer) {
                this.leaves = null;
                return 0;
            }
            return 1;
        }
        VirtualFilePointerImpl[] newLeaves = (VirtualFilePointerImpl[])ArrayUtil.remove((Object[])((VirtualFilePointerImpl[])leaves), (Object)pointer);
        if (newLeaves.length == 0) {
            newLeaves = null;
        }
        this.leaves = newLeaves;
        return newLeaves == null ? 0 : newLeaves.length;
    }

    static VirtualFile myFile(@NotNull Object fileOrUrl) {
        if (fileOrUrl == null) {
            FilePartNode.$$$reportNull$$$0(4);
        }
        return fileOrUrl instanceof VirtualFile ? (VirtualFile)fileOrUrl : null;
    }

    @NotNull
    private String myUrl() {
        return FilePartNode.myUrl(this.myFileOrUrl);
    }

    @NotNull
    static String myUrl(Object fileOrUrl) {
        String string = fileOrUrl instanceof VirtualFile ? ((VirtualFile)fileOrUrl).getUrl() : (String)fileOrUrl;
        if (string == null) {
            FilePartNode.$$$reportNull$$$0(5);
        }
        return string;
    }

    FilePartNode(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(6);
        }
        this.children = EMPTY_ARRAY;
        this.nameId = -1;
        this.myFileOrUrl = "";
        this.myFS = fs;
    }

    @NotNull
    static CharSequence fromNameId(int nameId) {
        CharSequence charSequence = nameId == -2 ? "!/" : FileNameCache.getVFileName(nameId);
        if (charSequence == null) {
            FilePartNode.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    @NotNull
    CharSequence getName() {
        return FilePartNode.fromNameId(this.nameId);
    }

    public String toString() {
        return this.getName() + (String)(this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    static int getNameId(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(8);
        }
        if ((fs = file2.getFileSystem()) instanceof ArchiveFileSystem && file2.getParent() == null) {
            return -2;
        }
        return ((VirtualFileSystemEntry)file2).getNameId();
    }

    @Contract(value="_, _, true, _ -> !null")
    FilePartNode findChildByNameId(@Nullable VirtualFile file2, int nameId, boolean createIfNotFound, @NotNull NewVirtualFileSystem childFs) {
        if (childFs == null) {
            FilePartNode.$$$reportNull$$$0(9);
        }
        if (nameId <= 0 && nameId != -2) {
            throw new IllegalArgumentException("invalid argument nameId: " + nameId);
        }
        for (FilePartNode child2 : this.children) {
            if (!child2.nameEqualTo(nameId)) continue;
            return child2;
        }
        if (createIfNotFound) {
            int index;
            CharSequence name = FilePartNode.fromNameId(nameId);
            int n = index = this.children.length == 0 ? -1 : this.binarySearchChildByName(name);
            if (!$assertionsDisabled && index >= 0) {
                FilePartNode child3 = this.children[index];
                throw new AssertionError((Object)(index + " : child= '" + child3 + "'; child.nameEqualTo(nameId)=" + child3.nameEqualTo(nameId) + "; child.getClass()=" + child3.getClass() + "; child.nameId=" + child3.nameId + "; child.getName()='" + child3.getName() + "'; nameId=" + nameId + "; name='" + name + "'; compare(child) = " + StringUtil.compare((CharSequence)child3.getName(), (CharSequence)name, (!this.isCaseSensitive() ? 1 : 0) != 0) + "; UrlPart.nameEquals: " + FileUtil.PATH_CHAR_SEQUENCE_HASHING_STRATEGY.equals((Object)child3.getName(), (Object)FilePartNode.fromNameId(nameId)) + "; name.equals(child.getName())=" + child3.getName().equals(name) + "; file=" + file2 + "; this.isCaseSensitive()=" + this.isCaseSensitive()));
            }
            Object fileOrUrl = file2;
            if (fileOrUrl == null) {
                fileOrUrl = this.nameId == -1 ? name.toString() : FilePartNode.childUrl(this.myUrl(), name, childFs);
            }
            FilePartNode child4 = new FilePartNode(nameId, fileOrUrl, childFs);
            this.children = (FilePartNode[])ArrayUtil.insert((Object[])this.children, (int)(-index - 1), (Object)child4);
            return child4;
        }
        return null;
    }

    boolean nameEqualTo(int nameId) {
        return this.nameId == nameId;
    }

    int binarySearchChildByName(@NotNull CharSequence name) {
        if (name == null) {
            FilePartNode.$$$reportNull$$$0(10);
        }
        return ObjectUtils.binarySearch((int)0, (int)this.children.length, i2 -> {
            FilePartNode child2 = this.children[i2];
            CharSequence childName = child2.getName();
            return StringUtil.compare((CharSequence)childName, (CharSequence)name, (!child2.isCaseSensitive() ? 1 : 0) != 0);
        });
    }

    void addRecursiveDirectoryPtrTo(@NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers) {
        if (toFirePointers == null) {
            FilePartNode.$$$reportNull$$$0(11);
        }
        this.processPointers(pointer -> {
            if (pointer.isRecursive()) {
                toFirePointers.putValue((Object)pointer.myListener, pointer);
            }
        });
    }

    void doCheckConsistency(@Nullable VirtualFile parent, @NotNull String name, @NotNull String urlFromRoot) {
        if (name == null) {
            FilePartNode.$$$reportNull$$$0(12);
        }
        if (urlFromRoot == null) {
            FilePartNode.$$$reportNull$$$0(13);
        }
        VirtualFile myFile = this.myFile();
        if (!(this instanceof FilePartNodeRoot)) {
            if (myFile == null) {
                String myUrl = this.myUrl();
                String expectedUrl = StringUtil.trimEnd((String)urlFromRoot, (char)'/');
                String actualUrl = StringUtil.trimEnd((String)myUrl, (char)'/');
                assert (FileUtil.namesEqual((String)actualUrl, (String)expectedUrl)) : "Expected url: '" + expectedUrl + "' but got: '" + actualUrl + "'";
            } else assert (Comparing.equal((Object)FilePartNode.getParentThroughJar(myFile, this.myFS), (Object)parent)) : "parent: " + parent + "\n myFile: " + myFile + "\n getParentThroughJar(myFile, myFS): " + FilePartNode.getParentThroughJar(myFile, this.myFS) + "\n myFS: " + this.myFS + "\n myFile.getParent(): " + myFile.getParent() + "\n this: " + this;
        }
        assert (!"..".equals(name) && !".".equals(name)) : "url must not contain '.' or '..' but got: " + this;
        String prevChildName = "";
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            String childUrlFromRoot;
            FilePartNode child2 = this.children[i2];
            String childName = child2.getName().toString();
            boolean needSeparator = !urlFromRoot.isEmpty() && !urlFromRoot.endsWith("/") && !childName.equals("!/");
            String string = childUrlFromRoot = needSeparator ? urlFromRoot + "/" + childName : urlFromRoot + childName;
            if (child2.myFS != this.myFS) {
                childUrlFromRoot = child2.myFS.getProtocol() + StringUtil.trimStart((String)childUrlFromRoot, (String)this.myFS.getProtocol());
            }
            child2.doCheckConsistency(myFile, childName, childUrlFromRoot);
            if (i2 != 0) assert (StringUtil.compare((String)prevChildName, (String)childName, (!child2.isCaseSensitive() ? 1 : 0) != 0) < 0) : "child[" + i2 + "] = " + child2 + "; [-1] = " + this.children[i2 - 1];
            assert (this.myFS instanceof LocalFileSystem && (child2.myFS instanceof ArchiveFileSystem || child2.myFS instanceof LocalFileSystem) || this.myFS instanceof ArchiveFileSystem && child2.myFS instanceof ArchiveFileSystem) : "this: " + this + "; fs=" + this.myFS + "; child[" + i2 + "] = " + child2 + "; fs=" + child2.myFS;
            assert (!(this instanceof UrlPartNode) || child2 instanceof UrlPartNode) : "this: " + this + "; fs=" + this.myFS + "; child[" + i2 + "] = " + child2 + "; fs=" + child2.myFS;
            prevChildName = childName;
        }
        int[] leafNumber = new int[1];
        this.processPointers(p -> {
            assert (p.myNode == this);
            leafNumber[0] = leafNumber[0] + 1;
        });
        int useCount = leafNumber[0];
        assert (useCount == 0 == (this.leaves == null)) : useCount + " - " + (this.leaves instanceof VirtualFilePointerImpl ? this.leaves : Arrays.toString((VirtualFilePointerImpl[])this.leaves));
        if (this.myFileOrUrl instanceof String) {
            String nameFromPath;
            String myPath = VfsUtilCore.urlToPath((String)this.myUrl());
            String string = nameFromPath = this.nameId == -2 || myPath.endsWith("!/") ? "!/" : PathUtil.getFileName((String)myPath);
            if (!myPath.isEmpty() && nameFromPath.isEmpty()) {
                nameFromPath = "/";
            }
            assert (StringUtilRt.equal((CharSequence)nameFromPath, (CharSequence)name, (boolean)this.isCaseSensitive())) : "fileAndUrl: " + this.myFileOrUrl + "; but this: " + this + "; nameFromPath: " + nameFromPath + "; name: " + name + "; myPath: " + myPath + "; url: " + this.myUrl() + ";";
            if (myFile != null) {
                String fileName;
                String string2 = fileName = myFile.getParent() == null && myFile.getFileSystem() instanceof ArchiveFileSystem ? "!/" : myFile.getName();
                assert (fileName.equals(name)) : "fileAndUrl: " + this.myFileOrUrl + "; but this: " + this;
                assert (myFile.getFileSystem() == this.myFS);
            }
        }
    }

    void update(@NotNull FilePartNode parent, @NotNull FilePartNodeRoot root, @NotNull String debugSource, @Nullable Object debugInvalidationReason) {
        if (parent == null) {
            FilePartNode.$$$reportNull$$$0(14);
        }
        if (root == null) {
            FilePartNode.$$$reportNull$$$0(15);
        }
        if (debugSource == null) {
            FilePartNode.$$$reportNull$$$0(16);
        }
        Object fileOrUrl = this.myFileOrUrl;
        VirtualFile file2 = FilePartNode.myFile(fileOrUrl);
        boolean changed2 = false;
        boolean nameChanged = false;
        boolean fileIsValid = false;
        if (file2 != null) {
            fileIsValid = file2.isValid();
            if (fileIsValid && file2.getParent() == null && file2.getFileSystem() instanceof ArchiveFileSystem) {
                VirtualFile local = ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2);
                boolean bl = fileIsValid = local != null;
            }
            if (!fileIsValid) {
                file2 = null;
                changed2 = true;
            }
        }
        Object parentFileOrUrl = parent.myFileOrUrl;
        String myName = this.getName().toString();
        Object url = null;
        String parentUrl = null;
        VirtualFile parentFile = FilePartNode.myFile(parentFileOrUrl);
        if (file2 == null) {
            VirtualFile virtualFile = file2 = parentFile == null || !parentFile.isValid() ? null : FilePartNode.findChildThroughJar(parentFile, myName, this.myFS);
            if (file2 == null) {
                parentUrl = FilePartNode.myUrl(parentFileOrUrl);
                url = FilePartNode.childUrl(parentUrl, myName, this.myFS);
                nameChanged = !Comparing.strEqual((String)url, (String)FilePartNode.myUrl(fileOrUrl));
                changed2 |= nameChanged;
            } else {
                changed2 = true;
            }
            boolean bl = fileIsValid = file2 != null && file2.isValid();
        }
        if (parent.nameId != -1 && !(parentFileOrUrl instanceof VirtualFile) && file2 != null) {
            file2 = null;
            fileIsValid = false;
            url = FilePartNode.myUrl(fileOrUrl);
        }
        if (file2 != null) {
            if (fileIsValid) {
                nameChanged = !StringUtil.equals((CharSequence)file2.getNameSequence(), (CharSequence)myName);
                changed2 |= nameChanged;
            } else {
                file2 = null;
                changed2 = true;
                url = FilePartNode.myUrl(fileOrUrl);
            }
        }
        VirtualFile result2 = file2 == null ? url : file2;
        boolean bl = !Objects.equals(fileOrUrl, result2);
        FilePartNode thisNode = this;
        if (changed2 |= bl) {
            VirtualFile oldFile = FilePartNode.myFile(fileOrUrl);
            if (oldFile != null && file2 == null && debugInvalidationReason != null) {
                ((VirtualFileSystemEntry)oldFile).appendInvalidationReason(debugSource, debugInvalidationReason);
            }
            this.myFileOrUrl = result2;
            if (file2 != null && (this instanceof UrlPartNode || nameChanged)) {
                thisNode = this.replaceWithFPPN(file2, parent);
            }
        }
        if (file2 != null && !Objects.equals(FilePartNode.getParentThroughJar(file2, this.myFS), parentFile)) {
            FilePartNode newNode = root.findOrCreateByFile((VirtualFile)file2).node;
            this.processPointers(p -> newNode.addLeaf((VirtualFilePointerImpl)p));
            newNode.children = this.children;
            this.children = EMPTY_ARRAY;
            changed2 = true;
            parentUrl = FilePartNode.myUrl(parentFileOrUrl);
            String myOldPath = VfsUtilCore.urlToPath((String)FilePartNode.childUrl(parentUrl, myName, this.myFS));
            root.removeEmptyNodesByPath(FilePartNodeRoot.splitNames(myOldPath));
            thisNode = newNode;
            nameChanged = true;
        }
        if (nameChanged) {
            String myOldPath = VfsUtilCore.urlToPath((String)FilePartNode.childUrl(parentUrl == null ? FilePartNode.myUrl(parentFileOrUrl) : parentUrl, myName, this.myFS));
            String myNewPath = VfsUtilCore.urlToPath((String)FilePartNode.myUrl(result2));
            thisNode.fixUrlPartNodes(myOldPath, myNewPath);
        }
        FilePartNode[] children2 = thisNode.children;
        VirtualFile toReplaceParent = null;
        for (int i2 = 0; i2 < children2.length; ++i2) {
            VirtualFile childFile;
            FilePartNode child2 = children2[i2];
            if (changed2) {
                child2.update(thisNode, root, debugSource, debugInvalidationReason);
                if (i2 >= thisNode.children.length) break;
                child2 = thisNode.children[i2];
            }
            if (file2 != null || (childFile = child2.myFile()) == null) continue;
            toReplaceParent = FilePartNode.getParentThroughJar(childFile, child2.myFS);
        }
        if (toReplaceParent != null) {
            this.replaceWithFPPN(toReplaceParent, parent);
        }
    }

    private void fixUrlPartNodes(@NotNull String oldPath, @NotNull String newPath) {
        if (oldPath == null) {
            FilePartNode.$$$reportNull$$$0(17);
        }
        if (newPath == null) {
            FilePartNode.$$$reportNull$$$0(18);
        }
        if (this instanceof UrlPartNode) {
            String protocol = this.myFS.getProtocol();
            String myUrl = this.myUrl();
            if (StringUtil.startsWith((CharSequence)myUrl, (int)(protocol.length() + "://".length()), (CharSequence)oldPath)) {
                this.myFileOrUrl = protocol + "://" + newPath + myUrl.substring(protocol.length() + "://".length() + oldPath.length());
            }
        }
        for (FilePartNode child2 : this.children) {
            child2.fixUrlPartNodes(oldPath, newPath);
        }
    }

    @NotNull
    FilePartNode replaceWithFPPN(@NotNull VirtualFile file2, @NotNull FilePartNode parent) {
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            FilePartNode.$$$reportNull$$$0(20);
        }
        int nameId = FilePartNode.getNameId(file2);
        parent.children = (FilePartNode[])ArrayUtil.remove((Object[])parent.children, (Object)this);
        FilePartNode newNode = parent.findChildByNameId(file2, nameId, true, (NewVirtualFileSystem)file2.getFileSystem());
        assert (newNode.nameId == nameId);
        newNode.children = this.children;
        this.processPointers(pointer -> newNode.addLeaf((VirtualFilePointerImpl)pointer));
        this.leaves = null;
        FilePartNode filePartNode = newNode;
        if (filePartNode == null) {
            FilePartNode.$$$reportNull$$$0(21);
        }
        return filePartNode;
    }

    @NotNull
    static String childUrl(@NotNull String parentUrl, @NotNull CharSequence childName, @NotNull NewVirtualFileSystem fs) {
        if (parentUrl == null) {
            FilePartNode.$$$reportNull$$$0(22);
        }
        if (childName == null) {
            FilePartNode.$$$reportNull$$$0(23);
        }
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(24);
        }
        if (childName.equals("!/") && fs instanceof ArchiveFileSystem) {
            String string = VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)parentUrl), (char)'/')) + childName;
            if (string == null) {
                FilePartNode.$$$reportNull$$$0(25);
            }
            return string;
        }
        Object object = parentUrl.isEmpty() ? VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)childName.toString()) : VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)parentUrl), (char)'/')) + "/" + childName;
        if (object == null) {
            FilePartNode.$$$reportNull$$$0(26);
        }
        return object;
    }

    private void associate(@Nullable Object leaves) {
        this.leaves = leaves;
        if (leaves != null) {
            if (leaves instanceof VirtualFilePointerImpl) {
                ((VirtualFilePointerImpl)leaves).myNode = this;
            } else {
                for (VirtualFilePointerImpl pointer : (VirtualFilePointerImpl[])leaves) {
                    pointer.myNode = this;
                }
            }
        }
    }

    VirtualFilePointerImpl getPointer(@Nullable VirtualFilePointerListener listener2) {
        VirtualFilePointerImpl[] array2;
        Object leaves = this.leaves;
        if (leaves == null) {
            return null;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            VirtualFilePointerImpl leaf = (VirtualFilePointerImpl)leaves;
            return leaf.myListener == listener2 ? leaf : null;
        }
        for (VirtualFilePointerImpl pointer : array2 = (VirtualFilePointerImpl[])leaves) {
            if (pointer.myListener != listener2) continue;
            return pointer;
        }
        return null;
    }

    void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> outList) {
        if (outList == null) {
            FilePartNode.$$$reportNull$$$0(27);
        }
        this.processPointers(p -> {
            if (p.myNode != null) {
                outList.add((VirtualFilePointerImpl)p);
            }
        });
    }

    void processPointers(@NotNull Consumer<? super VirtualFilePointerImpl> processor2) {
        VirtualFilePointerImpl[] pointers;
        Object leaves;
        if (processor2 == null) {
            FilePartNode.$$$reportNull$$$0(28);
        }
        if ((leaves = this.leaves) == null) {
            return;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            processor2.accept((VirtualFilePointerImpl)leaves);
            return;
        }
        for (VirtualFilePointerImpl pointer : pointers = (VirtualFilePointerImpl[])leaves) {
            processor2.accept(pointer);
        }
    }

    static VirtualFile getParentThroughJar(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs) {
        VirtualFile parent;
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(29);
        }
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(30);
        }
        if ((parent = file2.getParent()) == null && fs instanceof ArchiveFileSystem) {
            parent = ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return parent;
    }

    static VirtualFile findChildThroughJar(@NotNull VirtualFile file2, @NotNull String name, @NotNull NewVirtualFileSystem childFs) {
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(31);
        }
        if (name == null) {
            FilePartNode.$$$reportNull$$$0(32);
        }
        if (childFs == null) {
            FilePartNode.$$$reportNull$$$0(33);
        }
        VirtualFile child2 = name.equals("!/") && childFs instanceof ArchiveFileSystem ? ((ArchiveFileSystem)childFs).getRootByLocal(file2) : file2.findChild(name);
        return child2;
    }

    boolean removeEmptyNodesByFile(@NotNull List<VirtualFile> parts) {
        if (parts == null) {
            FilePartNode.$$$reportNull$$$0(34);
        }
        if (parts.isEmpty()) {
            return this.children.length == 0;
        }
        VirtualFile file2 = parts.remove(parts.size() - 1);
        FilePartNode child2 = this.findChildByNameId(null, FilePartNode.getNameId(file2), false, (NewVirtualFileSystem)file2.getFileSystem());
        if (child2 == null) {
            return false;
        }
        boolean toRemove2 = child2.removeEmptyNodesByFile(parts);
        if (toRemove2) {
            this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (Object)child2);
            return this.children.length == 0 && this.leaves == null;
        }
        return false;
    }

    boolean removeEmptyNodesByPath(@NotNull List<String> parts) {
        if (parts == null) {
            FilePartNode.$$$reportNull$$$0(35);
        }
        if (parts.isEmpty()) {
            return this.children.length == 0;
        }
        String name = parts.remove(parts.size() - 1);
        int index = this.binarySearchChildByName(name);
        if (index < 0) {
            return false;
        }
        FilePartNode child2 = this.children[index];
        boolean toRemove2 = child2.removeEmptyNodesByPath(parts);
        if (toRemove2) {
            this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (Object)child2);
            return this.children.length == 0 && this.leaves == null;
        }
        return false;
    }

    private boolean isCaseSensitive() {
        VirtualFile file2 = this.myFile();
        return file2 == null ? this.myFS.isCaseSensitive() : file2.isCaseSensitive();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrUrl";
                break;
            }
            case 1: 
            case 6: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/FilePartNode";
                break;
            }
            case 8: 
            case 19: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childFs";
                break;
            }
            case 10: 
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFirePointers";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlFromRoot";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/FilePartNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "myUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNameId";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithFPPN";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "childUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeLeaf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "myFile";
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findChildByNameId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "binarySearchChildByName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRecursiveDirectoryPtrTo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doCheckConsistency";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixUrlPartNodes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithFPPN";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "childUrl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersTo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processPointers";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getParentThroughJar";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findChildThroughJar";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyNodesByFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyNodesByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 21: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

