/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileEncodingConfigurable
extends PerFileConfigurableBase<Charset> {
    private JPanel myPanel;
    private JCheckBox myTransparentNativeToAsciiCheckBox;
    private JPanel myPropertiesFilesEncodingCombo;
    private JPanel myTablePanel;
    private ComboBox<EncodingProjectManagerImpl.BOMForNewUTF8Files> myBOMForUTF8Combo;
    private HyperlinkLabel myExplanationLabel;
    private Charset myPropsCharset;
    private final Trinity<String, Supplier<Charset>, Consumer<Charset>> myProjectMapping;
    private final Trinity<String, Supplier<Charset>, Consumer<Charset>> myGlobalMapping;

    FileEncodingConfigurable(@NotNull Project project) {
        if (project == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(0);
        }
        super(project, FileEncodingConfigurable.createMappings(project));
        this.$$$setupUI$$$();
        this.myBOMForUTF8Combo.setModel((ComboBoxModel)new EnumComboBoxModel(EncodingProjectManagerImpl.BOMForNewUTF8Files.class));
        this.myBOMForUTF8Combo.addItemListener(e -> this.updateExplanationLabelText());
        this.myExplanationLabel.setHyperlinkTarget("https://en.wikipedia.org/wiki/Byte_order_mark#UTF-8");
        EncodingManager app = EncodingManager.getInstance();
        EncodingProjectManagerImpl prj = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        this.myProjectMapping = Trinity.create((Object)IdeBundle.message((String)"file.encoding.option.global.encoding", (Object[])new Object[0]), () -> app.getDefaultCharsetName().isEmpty() ? null : app.getDefaultCharset(), o -> app.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o)));
        this.myGlobalMapping = Trinity.create((Object)IdeBundle.message((String)"file.encoding.option.project.encoding", (Object[])new Object[0]), prj::getConfiguredDefaultCharset, o -> prj.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o)));
    }

    @Override
    protected boolean isGlobalMapping(Trinity<@NlsContexts.Label String, Supplier<Charset>, Consumer<Charset>> prop) {
        return prop == this.myGlobalMapping || super.isGlobalMapping(prop);
    }

    @Override
    protected boolean isProjectMapping(Trinity<@NlsContexts.Label String, Supplier<Charset>, Consumer<Charset>> prop) {
        return prop == this.myProjectMapping || super.isProjectMapping(prop);
    }

    private void updateExplanationLabelText() {
        EncodingProjectManagerImpl.BOMForNewUTF8Files item = (EncodingProjectManagerImpl.BOMForNewUTF8Files)((Object)this.myBOMForUTF8Combo.getSelectedItem());
        String I = ApplicationNamesInfo.getInstance().getProductName();
        if (item != null) {
            switch (item) {
                case ALWAYS: {
                    this.myExplanationLabel.setHtmlText(IdeBundle.message((String)"file.encoding.option.warning.always", (Object[])new Object[]{I}));
                    break;
                }
                case NEVER: {
                    this.myExplanationLabel.setHtmlText(IdeBundle.message((String)"file.encoding.option.warning.never", (Object[])new Object[]{I}));
                    break;
                }
                case WINDOWS_ONLY: {
                    this.myExplanationLabel.setHtmlText(IdeBundle.message((String)"file.encoding.option.warning.windows.only", (Object[])new Object[]{I}));
                }
            }
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"file.encodings.configurable", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.project.file.encodings";
    }

    @Override
    @NotNull
    public String getId() {
        return "File.Encoding";
    }

    @Override
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(1);
        }
        if (key == DESCRIPTION) {
            return IdeBundle.message((String)"encodings.dialog.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        }
        if (key == MAPPING_TITLE) {
            return IdeBundle.message((String)"file.encoding.option.encoding.column", (Object[])new Object[0]);
        }
        if (key == TARGET_TITLE) {
            return IdeBundle.message((String)"file.encoding.option.path.column", (Object[])new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return null;
        }
        if (key == OVERRIDE_TITLE) {
            return null;
        }
        if (key == EMPTY_TEXT) {
            return IdeBundle.message((String)"file.encodings.not.configured", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    protected void renderValue(@Nullable Object target2, @NotNull Charset t, @NotNull ColoredTextContainer renderer2) {
        if (t == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(2);
        }
        if (renderer2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(3);
        }
        VirtualFile file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        EncodingUtil.FailReason result2 = file2 == null || file2.isDirectory() ? null : EncodingUtil.checkCanConvertAndReload(file2);
        @NlsSafe String encodingText = t.displayName();
        SimpleTextAttributes attributes = result2 == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        renderer2.append(encodingText + (String)(result2 == null ? "" : " (" + EncodingUtil.reasonToString(result2, file2) + ")"), attributes);
    }

    @Override
    @NotNull
    protected ActionGroup createActionListGroup(@Nullable Object target2, final @NotNull Consumer<? super Charset> onChosen) {
        if (onChosen == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(4);
        }
        VirtualFile file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        byte[] b = null;
        try {
            b = file2 == null || file2.isDirectory() ? null : file2.contentsToByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bytes = b;
        Document document = file2 == null ? null : FileDocumentManager.getInstance().getDocument(file2);
        DefaultActionGroup defaultActionGroup = new ChangeFileEncodingAction(true){

            @Override
            protected boolean chosen(Document document, Editor editor, VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
                if (charset == null) {
                    1.$$$reportNull$$$0(0);
                }
                onChosen.consume((Object)charset);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$1", "chosen"));
            }
        }.createActionGroup(file2, null, document, bytes, this.getClearValueText(target2));
        if (defaultActionGroup == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    @Override
    @NlsActions.ActionText
    @Nullable
    protected String getClearValueText(@Nullable Object target2) {
        return target2 != null ? super.getClearValueText(target2) : LangBundle.message((String)"action.set.system.default.encoding.text", (Object[])new Object[0]);
    }

    @Override
    @NlsActions.ActionText
    @Nullable
    protected String getNullValueText(@Nullable Object target2) {
        return target2 != null ? super.getNullValueText(target2) : IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()});
    }

    @Override
    @NotNull
    protected Collection<Charset> getValueVariants(@Nullable Object target2) {
        List<Charset> list2 = Arrays.asList(CharsetToolkit.getAvailableCharsets());
        if (list2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        this.myTablePanel.add((Component)super.createComponent(), "Center");
        JPanel p = this.createActionPanel(null, new PerFileConfigurableBase.Value<Charset>(){

            @Override
            public void commit() {
            }

            public Charset get() {
                return FileEncodingConfigurable.this.myPropsCharset;
            }

            public void set(Charset value2) {
                FileEncodingConfigurable.this.myPropsCharset = value2;
            }
        });
        this.myPropertiesFilesEncodingCombo.add((Component)p, "Center");
        JPanel jPanel2 = this.myPanel;
        if (jPanel2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(7);
        }
        return jPanel2;
    }

    @Override
    @NotNull
    protected List<Trinity<String, Supplier<Charset>, Consumer<Charset>>> getDefaultMappings() {
        List<Trinity<String, Supplier<Charset>, Consumer<Charset>>> list2 = Arrays.asList(this.myProjectMapping, this.myGlobalMapping);
        if (list2 == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    protected Charset adjustChosenValue(@Nullable Object target2, Charset chosen) {
        return chosen == ChooseFileEncodingAction.NO_ENCODING ? null : chosen;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        boolean same = Comparing.equal((Object)encodingManager.getDefaultCharsetForPropertiesFiles(null), (Object)this.myPropsCharset) && encodingManager.isNative2AsciiForPropertiesFiles() == this.myTransparentNativeToAsciiCheckBox.isSelected() && encodingManager.getBOMForNewUTF8Files() == this.myBOMForUTF8Combo.getSelectedItem();
        return !same;
    }

    @NotNull
    private static String getCharsetName(@Nullable Charset c) {
        String string = c == null ? "" : c.name();
        if (string == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        encodingManager.setDefaultCharsetForPropertiesFiles(null, this.myPropsCharset);
        encodingManager.setNative2AsciiForPropertiesFiles(null, this.myTransparentNativeToAsciiCheckBox.isSelected());
        EncodingProjectManagerImpl.BOMForNewUTF8Files option2 = (EncodingProjectManagerImpl.BOMForNewUTF8Files)((Object)ObjectUtils.notNull((Object)((Object)((EncodingProjectManagerImpl.BOMForNewUTF8Files)((Object)this.myBOMForUTF8Combo.getSelectedItem()))), (Object)((Object)EncodingProjectManagerImpl.BOMForNewUTF8Files.NEVER)));
        encodingManager.setBOMForNewUtf8Files(option2);
    }

    @Override
    public void reset() {
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        this.myTransparentNativeToAsciiCheckBox.setSelected(encodingManager.isNative2AsciiForPropertiesFiles());
        this.myPropsCharset = encodingManager.getDefaultCharsetForPropertiesFiles(null);
        this.myBOMForUTF8Combo.setSelectedItem((Object)encodingManager.getBOMForNewUTF8Files());
        super.reset();
    }

    @Override
    protected boolean canEditTarget(@Nullable Object target2, Charset value2) {
        return target2 == null || target2 instanceof VirtualFile && (((VirtualFile)target2).isDirectory() || EncodingUtil.checkCanConvertAndReload((VirtualFile)target2) == null);
    }

    @NotNull
    private static PerFileMappingsEx<Charset> createMappings(@NotNull Project project) {
        if (project == null) {
            FileEncodingConfigurable.$$$reportNull$$$0(10);
        }
        final EncodingProjectManagerImpl prjManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)project);
        return new PerFileMappingsEx<Charset>(){

            @Override
            @NotNull
            public Map<VirtualFile, Charset> getMappings() {
                return new HashMap<VirtualFile, Charset>(prjManager.getAllMappings());
            }

            @Override
            public void setMappings(@NotNull Map<VirtualFile, Charset> mappings) {
                if (mappings == null) {
                    3.$$$reportNull$$$0(0);
                }
                prjManager.setMapping(mappings);
            }

            public void setMapping(@Nullable VirtualFile file2, Charset value2) {
                throw new UnsupportedOperationException();
            }

            public Charset getMapping(@Nullable VirtualFile file2) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public Charset getDefaultMapping(@Nullable VirtualFile file2) {
                return prjManager.getEncoding(file2, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable$3", "setMappings"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/FileEncodingConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActionListGroup";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        ComboBox comboBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/IdeBundle", FileEncodingConfigurable.class).getString("file.encoding.option.properties.files"), (int)0, (int)0, null, null));
        this.myPropertiesFilesEncodingCombo = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", FileEncodingConfigurable.class).getString("editbox.default.encoding.for.properties.files"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransparentNativeToAsciiCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", FileEncodingConfigurable.class).getString("checkbox.transparent.native.to.ascii.conversion"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTablePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/IdeBundle", FileEncodingConfigurable.class).getString("file.encoding.option.BOM"), (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", FileEncodingConfigurable.class).getString("file.encoding.option.create.utf8.files"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBOMForUTF8Combo = comboBox2 = new ComboBox();
        jPanel6.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myExplanationLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel6.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

