/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteThread;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBlockOperations;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 f*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004fghiB\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J\b\u00105\u001a\u000202H\u0007J\u0017\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u0017\u0010=\u001a\u0004\u0018\u00018\u00002\u0006\u0010>\u001a\u00020;H\u0016\u00a2\u0006\u0002\u0010?J\u0017\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010>\u001a\u00020;H\u0016\u00a2\u0006\u0002\u0010?J\u0017\u0010A\u001a\u0004\u0018\u00018\u00002\u0006\u0010>\u001a\u00020;H\u0016\u00a2\u0006\u0002\u0010?J\u0010\u0010B\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013H\u0016J\u0018\u0010C\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020!H\u0014J\b\u0010G\u001a\u00020!H\u0015J\u0010\u0010H\u001a\u00020!2\u0006\u0010>\u001a\u00020;H\u0016J\b\u0010I\u001a\u00020!H\u0016J\u0018\u0010J\u001a\u00020!2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0016J\b\u0010K\u001a\u00020!H\u0016J!\u0010L\u001a\u0002HM\"\u0004\b\u0001\u0010M2\f\u00103\u001a\b\u0012\u0004\u0012\u0002HM0NH\u0016\u00a2\u0006\u0002\u0010OJ\u0006\u0010P\u001a\u000202J\u0010\u0010Q\u001a\u0002022\u0006\u00107\u001a\u00020\u0002H\u0017J\u0010\u0010Q\u001a\u0002022\u0006\u0010D\u001a\u00020EH\u0017J\u001c\u0010R\u001a\u0002022\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020!0TH\u0005J \u0010U\u001a\u0002022\u0006\u0010V\u001a\u00020W2\u000e\u0010X\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010NH\u0005J\u0015\u0010Y\u001a\u00028\u00002\u0006\u0010Z\u001a\u00020\u000fH$\u00a2\u0006\u0002\u0010[J\b\u0010\\\u001a\u00020]H\u0016J\u0018\u0010^\u001a\u00020;2\u0006\u0010>\u001a\u00020;2\u0006\u0010_\u001a\u00020!H\u0016J\u0018\u0010`\u001a\u00020;2\u0006\u0010>\u001a\u00020;2\u0006\u0010_\u001a\u00020!H\u0016J$\u0010a\u001a\u00020!2\u0006\u0010b\u001a\u00020c2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020TH\u0005J.\u0010a\u001a\u00020!2\u0006\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010]2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002020TH\u0005J\b\u0010e\u001a\u000202H\u0004R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020!2\u0006\u0010 \u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0012\u0010'\u001a\u00020(X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001bR\u0016\u0010-\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006j"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerI;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "getLOCK$intellij_platform_diff_impl", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "blockOperations", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getBlockOperations", "()Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "blocks", "", "getBlocks", "()Ljava/util/List;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "documentTracker", "Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "getDocumentTracker", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "<set-?>", "", "isInitialized", "()Z", "isReleased", "getProject", "()Lcom/intellij/openapi/project/Project;", "renderer", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "vcsDocument", "getVcsDocument", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "doFrozen", "", "task", "Ljava/lang/Runnable;", "dropBaseRevision", "findRange", "range", "(Lcom/intellij/openapi/vcs/ex/Range;)Lcom/intellij/openapi/vcs/ex/Range;", "fireLinesUnchanged", "startLine", "", "endLine", "getNextRange", "line", "(I)Lcom/intellij/openapi/vcs/ex/Range;", "getPrevRange", "getRangeForLine", "getRanges", "getRangesForLines", "lines", "Ljava/util/BitSet;", "isClearLineModificationFlagOnRollback", "isDetectWhitespaceChangedLines", "isLineModified", "isOperational", "isRangeModified", "isValid", "readLock", "T", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "release", "rollbackChanges", "runBulkRollback", "condition", "Lkotlin/Function1;", "setBaseRevision", "vcsContent", "", "beforeUnfreeze", "toRange", "block", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/Range;", "toString", "", "transferLineFromVcs", "approximate", "transferLineToVcs", "updateDocument", "side", "Lcom/intellij/diff/util/Side;", "commandName", "updateHighlighters", "Companion", "InnerRangesDocumentTrackerHandler", "MyBlockOperations", "MyDocumentTrackerHandler", "intellij.platform.diff.impl"})
public abstract class LineStatusTrackerBase<R extends Range>
implements LineStatusTrackerI<R> {
    @NotNull
    private final Document vcsDocument;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final DocumentTracker.Lock LOCK;
    @NotNull
    private final LineStatusTrackerBlockOperations<R, DocumentTracker.Block> blockOperations;
    @NotNull
    private final DocumentTracker documentTracker;
    private boolean isReleased;
    private boolean isInitialized;
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private static final Logger LOG;
    private static final Key<Boolean> VCS_DOCUMENT_KEY;
    public static final Companion Companion;

    @Override
    @NotNull
    public final Document getVcsDocument() {
        return this.vcsDocument;
    }

    @Override
    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final DocumentTracker.Lock getLOCK$intellij_platform_diff_impl() {
        return this.LOCK;
    }

    @NotNull
    protected final LineStatusTrackerBlockOperations<R, DocumentTracker.Block> getBlockOperations() {
        return this.blockOperations;
    }

    @NotNull
    protected final DocumentTracker getDocumentTracker() {
        return this.documentTracker;
    }

    @NotNull
    protected abstract LineStatusMarkerRenderer getRenderer();

    @Override
    public final boolean isReleased() {
        return this.isReleased;
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    protected final List<DocumentTracker.Block> getBlocks() {
        return this.documentTracker.getBlocks();
    }

    @RequiresEdt
    protected boolean isDetectWhitespaceChangedLines() {
        return false;
    }

    protected boolean isClearLineModificationFlagOnRollback() {
        return false;
    }

    @NotNull
    protected abstract R toRange(@NotNull DocumentTracker.Block var1);

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Override
    @Nullable
    public List<R> getRanges() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.blockOperations.getRanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    protected final void setBaseRevision(@NotNull CharSequence vcsContent, @Nullable Function0<Unit> beforeUnfreeze) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isReleased) {
            return;
        }
        DocumentTracker documentTracker = this.documentTracker;
        Side side$iv = Side.LEFT;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side$iv);
        try {
            boolean bl = false;
            this.updateDocument(Side.LEFT, (Function1<Document, Unit>)((Function1)new Function1<Document, Unit>(this, vcsContent, beforeUnfreeze){
                final /* synthetic */ LineStatusTrackerBase this$0;
                final /* synthetic */ CharSequence $vcsContent$inlined;
                final /* synthetic */ Function0 $beforeUnfreeze$inlined;
                {
                    this.this$0 = lineStatusTrackerBase;
                    this.$vcsContent$inlined = charSequence;
                    this.$beforeUnfreeze$inlined = function0;
                    super(1);
                }

                public final void invoke(@NotNull Document it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.getVcsDocument().setText(this.$vcsContent$inlined);
                }
            }));
            Function0<Unit> function0 = beforeUnfreeze;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
        }
        finally {
            this_$iv.unfreeze(side$iv);
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.updateHighlighters();
        }
    }

    @RequiresEdt
    public final void dropBaseRevision() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isReleased) {
            return;
        }
        this.isInitialized = false;
        this.updateHighlighters();
    }

    public final void release() {
        Runnable runnable2 = new Runnable(this){
            final /* synthetic */ LineStatusTrackerBase this$0;

            public final void run() {
                if (this.this$0.isReleased()) {
                    return;
                }
                LineStatusTrackerBase.access$setReleased$p(this.this$0, true);
                Disposer.dispose((Disposable)this.this$0.getDisposable());
            }
            {
                this.this$0 = lineStatusTrackerBase;
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isDispatchThread() || this.LOCK.isHeldByCurrentThread()) {
            Intrinsics.checkNotNullExpressionValue((Object)WriteThread.submit((Runnable)runnable2), (String)"WriteThread.submit(runnable)");
        } else {
            runnable2.run();
        }
    }

    @RequiresEdt
    protected final boolean updateDocument(@NotNull Side side, @NotNull Function1<? super Document, Unit> task2) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        return this.updateDocument(side, null, task2);
    }

    @RequiresEdt
    protected final boolean updateDocument(@NotNull Side side, @Nullable String commandName2, @NotNull Function1<? super Document, Unit> task2) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Document affectedDocument = side.isLeft() ? this.vcsDocument : this.document;
        return Companion.updateDocument(this.getProject(), affectedDocument, commandName2, task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void doFrozen(@NotNull Runnable task2) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        DocumentTracker this_$iv = this.documentTracker;
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                task2.run();
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    @Override
    public <T> T readLock(@NotNull Function0<? extends T> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        return this.documentTracker.readLock(task2);
    }

    protected final void updateHighlighters() {
        this.getRenderer().scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOperational() {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock2 = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            boolean bl4 = this.isInitialized && !this.isReleased;
            return bl4;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock2 = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            boolean bl4 = this.isOperational() && !this.documentTracker.isFrozen();
            return bl4;
        }
        finally {
            lock2.unlock();
        }
    }

    @Override
    @Nullable
    public R findRange(@NotNull Range range2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        return this.blockOperations.findRange(range2);
    }

    @Override
    @Nullable
    public R getNextRange(int line) {
        return this.blockOperations.getNextRange(line);
    }

    @Override
    @Nullable
    public R getPrevRange(int line) {
        return this.blockOperations.getPrevRange(line);
    }

    @Override
    @Nullable
    public List<R> getRangesForLines(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return this.blockOperations.getRangesForLines(lines);
    }

    @Override
    @Nullable
    public R getRangeForLine(int line) {
        return this.blockOperations.getRangeForLine(line);
    }

    @Override
    public boolean isLineModified(int line) {
        return this.blockOperations.isLineModified(line);
    }

    @Override
    public boolean isRangeModified(int startLine, int endLine) {
        return this.blockOperations.isRangeModified(startLine, endLine);
    }

    @Override
    public int transferLineFromVcs(int line, boolean approximate) {
        return this.blockOperations.transferLineFromVcs(line, approximate);
    }

    @Override
    public int transferLineToVcs(int line, boolean approximate) {
        return this.blockOperations.transferLineToVcs(line, approximate);
    }

    @Override
    @RequiresEdt
    public void rollbackChanges(@NotNull Range range2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        DocumentTracker.Block newRange = this.blockOperations.findBlock(range2);
        if (newRange != null) {
            this.runBulkRollback((Function1<DocumentTracker.Block, Boolean>)((Function1)new Function1<DocumentTracker.Block, Boolean>(newRange){
                final /* synthetic */ DocumentTracker.Block $newRange;

                public final boolean invoke(@NotNull DocumentTracker.Block it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$newRange);
                }
                {
                    this.$newRange = block;
                    super(1);
                }
            }));
        }
    }

    @Override
    @RequiresEdt
    public void rollbackChanges(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        this.runBulkRollback((Function1<DocumentTracker.Block, Boolean>)((Function1)new Function1<DocumentTracker.Block, Boolean>(lines){
            final /* synthetic */ BitSet $lines;

            public final boolean invoke(@NotNull DocumentTracker.Block it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LineStatusTrackerBlockOperations.Companion.isSelectedByLine((BlockI)it, this.$lines);
            }
            {
                this.$lines = bitSet;
                super(1);
            }
        }));
    }

    @RequiresEdt
    protected final void runBulkRollback(@NotNull Function1<? super DocumentTracker.Block, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        if (!this.isValid()) {
            return;
        }
        this.updateDocument(Side.RIGHT, DiffBundle.message((String)"rollback.change.command.name", (Object[])new Object[0]), (Function1<Document, Unit>)((Function1)new Function1<Document, Unit>(this, condition){
            final /* synthetic */ LineStatusTrackerBase this$0;
            final /* synthetic */ Function1 $condition;

            public final void invoke(@NotNull Document it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getDocumentTracker().partiallyApplyBlocks(Side.RIGHT, (Function1<? super DocumentTracker.Block, Boolean>)this.$condition, (Function2<? super DocumentTracker.Block, ? super Integer, Unit>)((Function2)new Function2<DocumentTracker.Block, Integer, Unit>(this){
                    final /* synthetic */ runBulkRollback.1 this$0;

                    public final void invoke(@NotNull DocumentTracker.Block block, int shift) {
                        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                        LineStatusTrackerBase.access$fireLinesUnchanged(this.this$0.this$0, block.getStart() + shift, block.getStart() + shift + (block.getVcsEnd() - block.getVcsStart()));
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
            }
            {
                this.this$0 = lineStatusTrackerBase;
                this.$condition = function1;
                super(1);
            }
        }));
    }

    private final void fireLinesUnchanged(int startLine, int endLine) {
        if (!this.isClearLineModificationFlagOnRollback()) {
            return;
        }
        if (this.document.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        Document document = this.document;
        if (document == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        }
        ((DocumentImpl)document).clearLineModificationFlags(startLine, endLine);
    }

    @NotNull
    public String toString() {
        VirtualFile virtualFile = this.getVirtualFile();
        return this.getClass().getName() + "(file=" + (virtualFile != null ? virtualFile.getPath() : null) + ", isReleased=" + this.isReleased + ")@" + Integer.toHexString(this.hashCode());
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public LineStatusTrackerBase(@Nullable Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.document = document;
        this.vcsDocument = Companion.createVcsDocument(this.document);
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        this.disposable = disposable2;
        this.LOCK = new DocumentTracker.Lock();
        this.blockOperations = new MyBlockOperations(this.LOCK);
        this.documentTracker = new DocumentTracker(this.vcsDocument, this.document, this.LOCK);
        Disposer.register((Disposable)this.disposable, (Disposable)this.documentTracker);
        this.documentTracker.addHandler(new MyDocumentTrackerHandler());
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LineStatusTrackerBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(LineS\u2026sTrackerBase::class.java)");
        LOG = logger;
        Key key = Key.create((String)"LineStatusTrackerBase.VCS_DOCUMENT_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"LineStatusTr\u2026erBase.VCS_DOCUMENT_KEY\")");
        VCS_DOCUMENT_KEY = key;
    }

    public static final /* synthetic */ boolean access$isReleased$p(LineStatusTrackerBase $this) {
        return $this.isReleased;
    }

    public static final /* synthetic */ void access$setReleased$p(LineStatusTrackerBase $this, boolean bl) {
        $this.isReleased = bl;
    }

    public static final /* synthetic */ void access$fireLinesUnchanged(LineStatusTrackerBase $this, int startLine, int endLine) {
        $this.fireLinesUnchanged(startLine, endLine);
    }

    @NotNull
    protected static final Logger getLOG() {
        Companion companion = Companion;
        return LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0007H\u0014J\u0011\u0010\b\u001a\u00028\u0000*\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$MyBlockOperations;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "lock", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "getBlocks", "", "toRange", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/Range;", "intellij.platform.diff.impl"})
    private final class MyBlockOperations
    extends LineStatusTrackerBlockOperations<R, DocumentTracker.Block> {
        @Override
        @Nullable
        protected List<DocumentTracker.Block> getBlocks() {
            return LineStatusTrackerBase.this.isValid() ? LineStatusTrackerBase.this.getBlocks() : null;
        }

        @Override
        @NotNull
        protected R toRange(@NotNull DocumentTracker.Block $this$toRange) {
            Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"$this$toRange");
            return LineStatusTrackerBase.this.toRange($this$toRange);
        }

        public MyBlockOperations(DocumentTracker.Lock lock2) {
            Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
            super(lock2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$MyDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;)V", "afterBulkRangeChange", "", "isDirty", "", "onUnfreeze", "side", "Lcom/intellij/diff/util/Side;", "intellij.platform.diff.impl"})
    private final class MyDocumentTrackerHandler
    implements DocumentTracker.Handler {
        @Override
        public void afterBulkRangeChange(boolean isDirty) {
            LineStatusTrackerBase.this.updateHighlighters();
        }

        @Override
        public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            LineStatusTrackerBase.this.updateHighlighters();
        }

        @Override
        public void onUnfreeze() {
            DocumentTracker.Handler.DefaultImpls.onUnfreeze(this);
        }

        @Override
        public void onRangeRefreshed(@NotNull DocumentTracker.Block before, @NotNull List<DocumentTracker.Block> after2) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after2, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangeRefreshed(this, before, after2);
        }

        @Override
        public void onRangesChanged(@NotNull List<DocumentTracker.Block> before, @NotNull DocumentTracker.Block after2) {
            Intrinsics.checkNotNullParameter(before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangesChanged(this, before, after2);
        }

        @Override
        public void onRangeShifted(@NotNull DocumentTracker.Block before, @NotNull DocumentTracker.Block after2) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangeShifted(this, before, after2);
        }

        @Override
        public boolean mergeRanges(@NotNull DocumentTracker.Block block1, @NotNull DocumentTracker.Block block2, @NotNull DocumentTracker.Block merged) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            return DocumentTracker.Handler.DefaultImpls.mergeRanges(this, block1, block2, merged);
        }

        @Override
        public void onFreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            DocumentTracker.Handler.DefaultImpls.onFreeze(this, side);
        }

        @Override
        public void onFreeze() {
            DocumentTracker.Handler.DefaultImpls.onFreeze(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\b\u0010\u0011\u001a\u00020\u000eH&J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0007J\b\u0010\u0019\u001a\u00020\fH\u0002R$\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0006X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$InnerRangesDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;)V", "innerRanges", "", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Ljava/util/List;", "setInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "afterBulkRangeChange", "", "isDirty", "", "calcInnerRanges", "block", "isDetectWhitespaceChangedLines", "onRangeShifted", "before", "after", "onUnfreeze", "side", "Lcom/intellij/diff/util/Side;", "resetInnerRanges", "updateMissingInnerRanges", "intellij.platform.diff.impl"})
    protected abstract class InnerRangesDocumentTrackerHandler
    implements DocumentTracker.Handler {
        @Nullable
        public abstract List<Range.InnerRange> getInnerRanges(@NotNull DocumentTracker.Block var1);

        public abstract void setInnerRanges(@NotNull DocumentTracker.Block var1, @Nullable List<Range.InnerRange> var2);

        public abstract boolean isDetectWhitespaceChangedLines();

        @Override
        public void onRangeShifted(@NotNull DocumentTracker.Block before, @NotNull DocumentTracker.Block after2) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
            this.setInnerRanges(after2, this.getInnerRanges(before));
        }

        @Override
        public void afterBulkRangeChange(boolean isDirty) {
            if (!isDirty) {
                this.updateMissingInnerRanges();
            }
        }

        @Override
        public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.updateMissingInnerRanges();
        }

        private final void updateMissingInnerRanges() {
            if (!this.isDetectWhitespaceChangedLines()) {
                return;
            }
            if (LineStatusTrackerBase.this.getDocumentTracker().isFrozen()) {
                return;
            }
            for (DocumentTracker.Block block : LineStatusTrackerBase.this.getBlocks()) {
                if (this.getInnerRanges(block) != null) continue;
                this.setInnerRanges(block, this.calcInnerRanges(block));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        public final void resetInnerRanges() {
            DocumentTracker.Lock this_$iv = LineStatusTrackerBase.this.getLOCK$intellij_platform_diff_impl();
            boolean $i$f$write = false;
            Lock lock2 = this_$iv.getMyLock();
            boolean bl = false;
            boolean bl2 = false;
            lock2.lock();
            try {
                boolean bl3 = false;
                if (this.isDetectWhitespaceChangedLines()) {
                    for (DocumentTracker.Block block : LineStatusTrackerBase.this.getBlocks()) {
                        this.setInnerRanges(block, this.calcInnerRanges(block));
                    }
                } else {
                    for (DocumentTracker.Block block : LineStatusTrackerBase.this.getBlocks()) {
                        this.setInnerRanges(block, null);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        private final List<Range.InnerRange> calcInnerRanges(DocumentTracker.Block block) {
            if (block.getStart() == block.getEnd() || block.getVcsStart() == block.getVcsEnd()) {
                return null;
            }
            com.intellij.diff.util.Range range2 = block.getRange();
            CharSequence charSequence = LineStatusTrackerBase.this.getVcsDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"vcsDocument.immutableCharSequence");
            CharSequence charSequence2 = LineStatusTrackerBase.this.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document.immutableCharSequence");
            return RangesBuilder.createInnerRanges(range2, charSequence, charSequence2, RangesBuilder.getLineOffsets(LineStatusTrackerBase.this.getVcsDocument()), RangesBuilder.getLineOffsets(LineStatusTrackerBase.this.getDocument()));
        }

        @Override
        public void onUnfreeze() {
            DocumentTracker.Handler.DefaultImpls.onUnfreeze(this);
        }

        @Override
        public void onRangeRefreshed(@NotNull DocumentTracker.Block before, @NotNull List<DocumentTracker.Block> after2) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after2, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangeRefreshed(this, before, after2);
        }

        @Override
        public void onRangesChanged(@NotNull List<DocumentTracker.Block> before, @NotNull DocumentTracker.Block after2) {
            Intrinsics.checkNotNullParameter(before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangesChanged(this, before, after2);
        }

        @Override
        public boolean mergeRanges(@NotNull DocumentTracker.Block block1, @NotNull DocumentTracker.Block block2, @NotNull DocumentTracker.Block merged) {
            Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
            Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
            return DocumentTracker.Handler.DefaultImpls.mergeRanges(this, block1, block2, merged);
        }

        @Override
        public void onFreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            DocumentTracker.Handler.DefaultImpls.onFreeze(this, side);
        }

        @Override
        public void onFreeze() {
            DocumentTracker.Handler.DefaultImpls.onFreeze(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ=\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\r\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u0016H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "VCS_DOCUMENT_KEY", "Lcom/intellij/openapi/util/Key;", "", "createVcsDocument", "Lcom/intellij/openapi/editor/Document;", "originalDocument", "updateDocument", "project", "Lcom/intellij/openapi/project/Project;", "document", "commandName", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "task", "Lkotlin/Function1;", "", "intellij.platform.diff.impl"})
    public static final class Companion {
        @JvmStatic
        protected static /* synthetic */ void getLOG$annotations() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final Document createVcsDocument(@NotNull Document originalDocument) {
            Intrinsics.checkNotNullParameter((Object)originalDocument, (String)"originalDocument");
            DocumentImpl result2 = new DocumentImpl(originalDocument.getImmutableCharSequence(), true);
            result2.putUserData(UndoConstants.DONT_RECORD_UNDO, true);
            result2.putUserData(VCS_DOCUMENT_KEY, true);
            result2.setReadOnly(true);
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        public final boolean updateDocument(@Nullable Project project, @NotNull Document document, @Nullable String commandName2, @NotNull Function1<? super Document, Unit> task2) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(task2, (String)"task");
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)VCS_DOCUMENT_KEY, (UserDataHolder)document)) {
                document.setReadOnly(false);
                try {
                    CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(task2, document){
                        final /* synthetic */ Function1 $task;
                        final /* synthetic */ Document $document;

                        public final void run() {
                            this.$task.invoke((Object)this.$document);
                        }
                        {
                            this.$task = function1;
                            this.$document = document;
                        }
                    });
                    boolean bl = true;
                    return bl;
                }
                finally {
                    document.setReadOnly(true);
                }
            }
            return DiffUtil.executeWriteCommand(document, project, commandName2, new Runnable(task2, document){
                final /* synthetic */ Function1 $task;
                final /* synthetic */ Document $document;

                public final void run() {
                    this.$task.invoke((Object)this.$document);
                }
                {
                    this.$task = function1;
                    this.$document = document;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

