/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.keyGestures;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.keyGestures.KeyGestureState;
import com.intellij.openapi.keymap.impl.keyGestures.StateContext;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public final class KeyboardGestureProcessor {
    IdeKeyEventDispatcher myDispatcher;
    StateContext myContext = new StateContext();
    final KeyGestureState myWaitForStart = new KeyGestureState.WaitForStart(this);
    final KeyGestureState myModifierPressed = new KeyGestureState.ModifierPressed(this);
    final KeyGestureState myWaitForDblClick = new KeyGestureState.WaitForDblClick(this);
    final KeyGestureState myWaitForAction = new KeyGestureState.WaitForAction(this);
    final KeyGestureState myWaitForActionEnd = new KeyGestureState.WaitForActionEnd(this);
    final KeyGestureState myFinish = new KeyGestureState.ProcessFinish(this);
    KeyGestureState myState = this.myWaitForStart;
    final Timer myHoldTimer = TimerUtil.createNamedTimer((String)"Keyboard hold", (int)1200, e -> {});
    final Timer myDblClickTimer = TimerUtil.createNamedTimer((String)"Double click", (int)SystemProperties.getIntProperty((String)"actionSystem.keyGestureDblClickTime", (int)650), (ActionListener)new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardGestureProcessor.this.myState.processDblClickTimer();
        }
    });
    private final ActionProcessor myActionProcessor = new MyActionProcessor();

    public KeyboardGestureProcessor(IdeKeyEventDispatcher dispatcher) {
        this.myDispatcher = dispatcher;
    }

    public boolean process() {
        boolean wasNotInWaitState;
        boolean bl = wasNotInWaitState = this.myState != this.myWaitForStart;
        if (Boolean.getBoolean("ide.debugMode") && wasNotInWaitState) {
            System.out.println("-- key gesture context: before process, state=" + this.myState);
            System.out.println(this.myContext);
        }
        this.myContext.keyToProcess = this.myDispatcher.getContext().getInputEvent();
        this.myContext.isModal = this.myDispatcher.getContext().isModalContext();
        this.myContext.dataContext = this.myDispatcher.getContext().getDataContext();
        boolean result2 = this.myState.process();
        if (Boolean.getBoolean("ide.debugMode") && (wasNotInWaitState || this.myState != this.myWaitForStart)) {
            System.out.println("-- key gesture context: after process, state=" + this.myState);
            System.out.println(this.myContext);
        }
        return result2;
    }

    public boolean processInitState() {
        if (!Boolean.getBoolean("actionSystem.keyGestures.enabled")) {
            return false;
        }
        this.myContext.focusOwner = this.myDispatcher.getContext().getFocusOwner();
        return this.process();
    }

    void executeAction() {
        this.myDispatcher.updateCurrentContext(this.myContext.focusOwner, this.getCurrentShortcut());
        this.myDispatcher.processAction(this.myContext.keyToProcess, this.myActionProcessor);
    }

    @NotNull
    private Shortcut getCurrentShortcut() {
        Shortcut shortcut = KeyboardModifierGestureShortcut.newInstance((KeyboardGestureAction.ModifierType)this.myContext.modifierType, (KeyStroke)this.myContext.actionShortcut);
        if (shortcut == null) {
            KeyboardGestureProcessor.$$$reportNull$$$0(0);
        }
        return shortcut;
    }

    void setState(KeyGestureState state) {
        boolean isGestureProcessingState;
        boolean bl = isGestureProcessingState = this.myDispatcher.getState() == KeyState.STATE_KEY_GESTURE_PROCESSOR;
        if (state == this.myWaitForStart) {
            this.myContext.actionKey = null;
            if (isGestureProcessingState) {
                this.myDispatcher.setState(KeyState.STATE_INIT);
            }
        } else if (state == this.myWaitForAction) {
            this.myDispatcher.setState(KeyState.STATE_KEY_GESTURE_PROCESSOR);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor", "getCurrentShortcut"));
    }

    private class MyActionProcessor
    implements ActionProcessor {
        private MyActionProcessor() {
        }

        @Override
        @NotNull
        public AnActionEvent createEvent(InputEvent inputEvent, @NotNull DataContext context, @NotNull String place, @NotNull Presentation presentation2, @NotNull ActionManager manager2) {
            if (context == null) {
                MyActionProcessor.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyActionProcessor.$$$reportNull$$$0(1);
            }
            if (presentation2 == null) {
                MyActionProcessor.$$$reportNull$$$0(2);
            }
            if (manager2 == null) {
                MyActionProcessor.$$$reportNull$$$0(3);
            }
            KeyboardGestureProcessor.this.myContext.actionPresentation = presentation2;
            KeyboardGestureProcessor.this.myContext.actionPlace = place;
            AnActionEvent anActionEvent = KeyboardGestureProcessor.this.myState.createActionEvent();
            if (anActionEvent == null) {
                MyActionProcessor.$$$reportNull$$$0(4);
            }
            return anActionEvent;
        }

        @Override
        public void onUpdatePassed(InputEvent inputEvent, @NotNull AnAction action2, @NotNull AnActionEvent actionEvent) {
            if (action2 == null) {
                MyActionProcessor.$$$reportNull$$$0(5);
            }
            if (actionEvent == null) {
                MyActionProcessor.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void performAction(final InputEvent e, final @NotNull AnAction action2, @NotNull AnActionEvent actionEvent) {
            if (action2 == null) {
                MyActionProcessor.$$$reportNull$$$0(7);
            }
            if (actionEvent == null) {
                MyActionProcessor.$$$reportNull$$$0(8);
            }
            final boolean isGestureAction = action2 instanceof KeyboardGestureAction;
            actionEvent.accept(new AnActionEventVisitor(){

                public void visitGestureInitEvent(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (isGestureAction) {
                        MyActionProcessor.this.execute(anActionEvent, action2, e);
                    }
                }

                public void visitGesturePerformedEvent(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MyActionProcessor.this.execute(anActionEvent, action2, e);
                }

                public void visitGestureFinishEvent(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (isGestureAction) {
                        MyActionProcessor.this.execute(anActionEvent, action2, e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "anActionEvent";
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor$MyActionProcessor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitGestureInitEvent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitGesturePerformedEvent";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitGestureFinishEvent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private void execute(AnActionEvent anActionEvent, AnAction action2, InputEvent e) {
            action2.actionPerformed(anActionEvent);
            e.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor$MyActionProcessor";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor$MyActionProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createEvent";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onUpdatePassed";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

