/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate;

import com.intellij.openapi.fileTypes.impl.associate.SystemFileTypeAssociator;
import com.intellij.openapi.fileTypes.impl.associate.linux.LinuxFileTypeAssociator;
import com.intellij.openapi.fileTypes.impl.associate.macos.MacOSFileTypeAssociator;
import com.intellij.openapi.fileTypes.impl.associate.win.WinFileTypeAssociator;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.Nullable;

public final class SystemAssociatorFactory {
    private static final SystemFileTypeAssociator FILE_TYPE_ASSOCIATOR = SystemAssociatorFactory.createAssociator();

    @Nullable
    private static SystemFileTypeAssociator createAssociator() {
        if (SystemInfo.isLinux) {
            return new LinuxFileTypeAssociator();
        }
        if (SystemInfo.isWindows) {
            return new WinFileTypeAssociator();
        }
        if (SystemInfo.isMac) {
            return new MacOSFileTypeAssociator();
        }
        return null;
    }

    private SystemAssociatorFactory() {
    }

    @Nullable
    public static SystemFileTypeAssociator getAssociator() {
        return FILE_TYPE_ASSOCIATOR;
    }
}

