/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private final WolfTheProblemSolver myProblemSolver;

    public PsiAwareFileEditorManagerImpl(@NotNull Project project) {
        if (project == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProblemSolver = WolfTheProblemSolver.getInstance((Project)project);
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                });
            }
        });
        connection.subscribe(ProblemListener.TOPIC, (Object)new MyProblemListener());
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(1);
        }
        return this.myProblemSolver.isProblemFile(file2);
    }

    @Override
    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        Module module;
        if (file2 == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(2);
        }
        @NlsSafe StringBuilder tooltipText = new StringBuilder();
        if (Registry.is((String)"ide.tab.tooltip.module") && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.getProject())) != null && ModuleManager.getInstance((Project)this.getProject()).getModules().length > 1) {
            tooltipText.append('[');
            tooltipText.append(module.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(super.getFileTooltipText(file2));
        String string = tooltipText.toString();
        if (string == null) {
            PsiAwareFileEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProblem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTooltipText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyProblemListener
    implements ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(0);
            }
            this.updateFile(file2);
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(1);
            }
            this.updateFile(file2);
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(2);
            }
            this.updateFile(file2);
        }

        private void updateFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(3);
            }
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsAppeared";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsDisappeared";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

