/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectsStructure
extends SimpleTreeStructure
implements Disposable {
    private final Project myProject;
    private final Tree myTree;
    private ExternalProjectsView myExternalProjectsView;
    private StructureTreeModel<ExternalProjectsStructure> myTreeModel;
    private RootNode myRoot;
    private final Map<String, ExternalSystemNode> myNodeMapping = new THashMap();
    private AsyncTreeModel myAsyncTreeModel;

    public ExternalProjectsStructure(Project project, Tree tree) {
        this.myProject = project;
        this.myTree = tree;
        ExternalProjectsStructure.configureTree(tree);
    }

    public void init(ExternalProjectsView externalProjectsView) {
        this.myExternalProjectsView = externalProjectsView;
        this.myRoot = new RootNode();
        this.myTreeModel = new StructureTreeModel<ExternalProjectsStructure>(this, this);
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), this);
        this.myTree.setModel((TreeModel)((Object)this.myAsyncTreeModel));
        TreeUtil.expand((JTree)this.myTree, (int)1);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void updateFrom(SimpleNode node) {
        if (node != null) {
            this.myTreeModel.invalidate(node, true);
        }
    }

    public void updateUpTo(SimpleNode node) {
        for (SimpleNode each = node; each != null; each = each.getParent()) {
            this.myTreeModel.invalidate(each, false);
        }
    }

    @NotNull
    public Object getRootElement() {
        RootNode rootNode = this.myRoot;
        if (rootNode == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(0);
        }
        return rootNode;
    }

    public void cleanupCache() {
        this.myRoot.cleanUpCache();
        this.myNodeMapping.clear();
        this.myTreeModel.invalidate();
    }

    private static void configureTree(Tree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
    }

    public void select(@NotNull SimpleNode node) {
        if (node == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(1);
        }
        this.myTreeModel.select(node, (JTree)this.myTree, path -> {});
    }

    public void expand(@NotNull SimpleNode node) {
        if (node == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(2);
        }
        this.myTreeModel.expand(node, (JTree)this.myTree, path -> {});
    }

    protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
        return null;
    }

    public void updateProjects(Collection<? extends DataNode<ProjectData>> toImport) {
        List orphanProjects = ContainerUtil.mapNotNull(this.myNodeMapping.entrySet(), entry -> entry.getValue() instanceof ProjectNode ? (String)entry.getKey() : null);
        for (DataNode<ProjectData> dataNode : toImport) {
            ProjectData projectData2 = (ProjectData)dataNode.getData();
            String projectPath = projectData2.getLinkedExternalProjectPath();
            orphanProjects.remove(projectPath);
            ExternalSystemNode projectNode = this.findNodeFor(projectPath);
            if (projectNode instanceof ProjectNode) {
                this.doMergeChildrenChanges(projectNode, dataNode, new ProjectNode(this.myExternalProjectsView, dataNode));
            } else {
                SimpleNode parent;
                ExternalSystemNode node = this.myNodeMapping.remove(projectPath);
                if (node != null && (parent = node.getParent()) instanceof ExternalSystemNode) {
                    ((ExternalSystemNode)parent).remove(projectNode);
                }
                projectNode = new ProjectNode(this.myExternalProjectsView, dataNode);
                this.myNodeMapping.put(projectPath, projectNode);
            }
            if (toImport.size() == 1) {
                TreeUtil.expand((JTree)this.myTree, (int)1);
            }
            this.doUpdateProject((ProjectNode)projectNode);
        }
        for (String string : orphanProjects) {
            SimpleNode parent;
            ExternalSystemNode projectNode = this.myNodeMapping.remove(string);
            if (!(projectNode instanceof ProjectNode) || !((parent = projectNode.getParent()) instanceof ExternalSystemNode)) continue;
            ((ExternalSystemNode)parent).remove(projectNode);
            this.updateUpTo(projectNode);
        }
    }

    private void doMergeChildrenChanges(ExternalSystemNode currentNode, DataNode<?> newDataNode, ExternalSystemNode newNode) {
        ExternalSystemNode<?>[] cached = currentNode.getCached();
        if (cached != null) {
            Object key;
            ArrayList duplicates = new ArrayList();
            LinkedHashMap oldDataMap = new LinkedHashMap();
            for (ExternalSystemNode<?> node : cached) {
                Object key2 = node.getData() != null ? node.getData() : node.getName();
                ExternalSystemNode<?> externalSystemNode = oldDataMap.put(key2, node);
                if (externalSystemNode == null) continue;
                duplicates.add(key2);
            }
            LinkedHashMap newDataMap = new LinkedHashMap();
            LinkedHashMap unchangedNewDataMap = new LinkedHashMap();
            for (ExternalSystemNode<?> externalSystemNode : newNode.getChildren()) {
                Object object = key = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
                if (oldDataMap.remove(key) == null) {
                    newDataMap.put(key, externalSystemNode);
                    continue;
                }
                unchangedNewDataMap.put(key, externalSystemNode);
            }
            for (Object duplicate : duplicates) {
                newDataMap.remove(duplicate);
            }
            currentNode.removeAll(oldDataMap.values());
            for (ExternalSystemNode<?> externalSystemNode : currentNode.getChildren()) {
                key = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
                ExternalSystemNode unchangedNewNode = (ExternalSystemNode)unchangedNewDataMap.get(key);
                if (unchangedNewNode == null) continue;
                this.doMergeChildrenChanges(externalSystemNode, unchangedNewNode.myDataNode, unchangedNewNode);
            }
            this.updateFrom(currentNode);
            currentNode.mergeWith(newNode);
            currentNode.addAll(newDataMap.values());
        } else {
            currentNode.mergeWith(newNode);
        }
    }

    private void doUpdateProject(ProjectNode node) {
        RootNode newParentNode = this.myRoot;
        if (!node.isVisible()) {
            newParentNode.remove(node);
        } else {
            node.updateProject();
            ExternalProjectsStructure.reconnectNode(node, newParentNode);
        }
    }

    private static void reconnectNode(ProjectNode node, ExternalSystemNode newParentNode) {
        ExternalSystemNode oldParentNode = node.getGroup();
        if (oldParentNode == null || !oldParentNode.equals(newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node);
            }
            newParentNode.add(node);
        }
    }

    private ExternalSystemNode findNodeFor(String projectPath) {
        return this.myNodeMapping.get(projectPath);
    }

    public <T extends ExternalSystemNode> void updateNodesAsync(@NotNull Collection<Class<? extends T>> nodeClasses) {
        if (nodeClasses == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(3);
        }
        this.updateNodesAsync(nodeClasses, false);
    }

    public <T extends ExternalSystemNode> void updateNodesAsync(@NotNull Collection<Class<? extends T>> nodeClasses, boolean structure) {
        if (nodeClasses == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(4);
        }
        LinkedList<TreePath> nodes = new LinkedList<TreePath>();
        this.myAsyncTreeModel.accept(new CollectingVisitor<T>(nodes, nodeClasses), false).onSuccess(p -> this.invalidatePaths(nodes, structure));
    }

    private void invalidatePaths(@NotNull Collection<TreePath> paths, boolean structure) {
        if (paths == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(5);
        }
        if (paths.isEmpty()) {
            return;
        }
        paths.forEach(p -> this.myTreeModel.invalidate((TreePath)p, structure));
    }

    public <T extends ExternalSystemNode> void visitNodes(@NotNull Class<? extends T> nodeClass, @NotNull Consumer<? super T> consumer2) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(6);
        }
        if (consumer2 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(7);
        }
        for (ExternalSystemNode node : this.getNodes(nodeClass)) {
            consumer2.consume((Object)node);
        }
    }

    public void dispose() {
        this.myExternalProjectsView = null;
        this.myNodeMapping.clear();
        this.myRoot = null;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getNodes(@NotNull Class<T> nodeClass) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(8);
        }
        return ExternalProjectsStructure.doGetNodes(nodeClass, this.myRoot.getChildren(), new SmartList());
    }

    @NotNull
    private static <T extends ExternalSystemNode> List<T> doGetNodes(@NotNull Class<T> nodeClass, SimpleNode[] nodes, @NotNull List<T> result2) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(10);
        }
        if (nodes == null) {
            List<T> list2 = result2;
            if (list2 == null) {
                ExternalProjectsStructure.$$$reportNull$$$0(11);
            }
            return list2;
        }
        for (SimpleNode node : nodes) {
            if (nodeClass.isInstance(node)) {
                result2.add((ExternalSystemNode)node);
            }
            ExternalProjectsStructure.doGetNodes(nodeClass, node.getChildren(), result2);
        }
        List<T> list3 = result2;
        if (list3 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        List list2 = TreeUtil.collectSelectedObjectsOfType((JTree)tree, nodeClass);
        if (list2 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(13);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClasses";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetNodes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateNodesAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidatePaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitNodes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }

    public class RootNode<T>
    extends ExternalSystemNode<T> {
        public RootNode() {
            super(ExternalProjectsStructure.this.myExternalProjectsView, null, null);
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    private static class CollectingVisitor<T extends ExternalSystemNode>
    implements TreeVisitor {
        private final List<TreePath> myCollector;
        private final Collection<Class<? extends T>> myNodeClasses;

        public CollectingVisitor(List<TreePath> nodeCollector, Collection<Class<? extends T>> nodeClasses) {
            this.myCollector = nodeCollector;
            this.myNodeClasses = nodeClasses;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            Object object;
            if (path == null) {
                CollectingVisitor.$$$reportNull$$$0(0);
            }
            if ((object = TreeUtil.getLastUserObject((TreePath)path)) != null && this.anyAssignableFrom(object.getClass())) {
                this.myCollector.add(path);
            }
            TreeVisitor.Action action2 = TreeVisitor.Action.CONTINUE;
            if (action2 == null) {
                CollectingVisitor.$$$reportNull$$$0(1);
            }
            return action2;
        }

        boolean anyAssignableFrom(Class<?> classParam) {
            for (Class<T> aClass : this.myNodeClasses) {
                if (!aClass.isAssignableFrom(classParam)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure$CollectingVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure$CollectingVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

