/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.tools.state";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        Set usages = new LinkedHashSet();
        for (ExternalSystemManager manager2 : ExternalSystemApiUtil.getAllManagers()) {
            Collection projects;
            ProjectSystemId projectSystemId = manager2.getSystemId();
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"manager.getSystemId()");
            String systemId2 = ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId);
            Function1<MetricEvent, Unit> $fun$addWithSystemId$1 = new Function1<MetricEvent, Unit>(systemId2, usages){
                final /* synthetic */ String $systemId;
                final /* synthetic */ Set $usages;

                public final void invoke(@NotNull MetricEvent desc) {
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    desc.getData().addData("externalSystemId", this.$systemId);
                    this.$usages.add(desc);
                }
                {
                    this.$systemId = string;
                    this.$usages = set2;
                    super(1);
                }
            };
            Intrinsics.checkNotNullExpressionValue((Object)((AbstractExternalSystemSettings)manager2.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings(), (String)"manager.getSettingsProvi\u2026tLinkedProjectsSettings()");
            $fun$addWithSystemId$1.invoke(MetricEventFactoryKt.newCounterMetric((String)"numberOfLinkedProject", (int)projects.size()));
            Iterator iterator2 = projects.iterator();
            while (iterator2.hasNext()) {
                ExternalProjectSettings projectsSetting;
                ExternalProjectSettings externalProjectSettings = projectsSetting = (ExternalProjectSettings)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)externalProjectSettings, (String)"projectsSetting");
                $fun$addWithSystemId$1.invoke(MetricEventFactoryKt.newBooleanMetric((String)"useQualifiedModuleNames", (boolean)externalProjectSettings.isUseQualifiedModuleNames()));
                $fun$addWithSystemId$1.invoke(MetricEventFactoryKt.newCounterMetric((String)"modules.count", (int)projectsSetting.getModules().size()));
            }
        }
        return usages;
    }
}

