/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
extends EditorFontCacheImpl
implements EditorColorsScheme,
SerializableScheme {
    public static final TextAttributes INHERITED_ATTRS_MARKER = new TextAttributes();
    public static final Color INHERITED_COLOR_MARKER = ColorUtil.marker((String)"INHERITED_COLOR_MARKER");
    public static final Color NULL_COLOR_MARKER = ColorUtil.marker((String)"NULL_COLOR_MARKER");
    public static final int CURR_VERSION = 142;
    public static final String NAME_BUNDLE_PROPERTY = "lcNameBundle";
    public static final String NAME_KEY_PROPERTY = "lcNameKey";
    protected EditorColorsScheme myParentScheme;
    @NotNull
    private FontPreferences myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
    @NotNull
    private FontPreferences myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String mySchemeName;
    private boolean myIsSaveNeeded;
    private boolean myCanBeDeleted = true;
    private int myVersion = 142;
    Map<ColorKey, Color> myColorsMap = new HashMap<ColorKey, Color>();
    Map<@NonNls String, TextAttributes> myAttributesMap = new HashMap<String, TextAttributes>();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String FONT_SCALE = "FONT_SCALE";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            AbstractColorsScheme.$$$reportNull$$$0(0);
        }
        return color;
    }

    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            AbstractColorsScheme.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        AbstractColorsScheme original;
        if (!(this instanceof ReadOnlyColorsScheme) && (original = this.getOriginal()) instanceof ReadOnlyColorsScheme) {
            String string = original.getDisplayName();
            if (string == null) {
                AbstractColorsScheme.$$$reportNull$$$0(3);
            }
            return string;
        }
        String baseName = Scheme.getBaseName((String)this.getName());
        String string = (String)ObjectUtils.chooseNotNull((Object)this.getLocalizedName(), (Object)baseName);
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    @Nls
    protected String getLocalizedName() {
        String bundlePath = this.getMetaProperties().getProperty(NAME_BUNDLE_PROPERTY);
        String bundleKey = this.getMetaProperties().getProperty(NAME_KEY_PROPERTY);
        if (bundlePath != null && bundleKey != null) {
            ResourceBundle bundle = DynamicBundle.INSTANCE.getResourceBundle(bundlePath, this.getClass().getClassLoader());
            return AbstractBundle.message((ResourceBundle)bundle, (String)bundleKey, (Object[])new Object[0]);
        }
        return null;
    }

    public void setFont(EditorFontType key, Font font) {
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        if (this.myConsoleFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseEditorFontPreferencesInConsole();
        } else {
            newScheme.setConsoleFontPreferences(this.myConsoleFontPreferences);
        }
        if (this.myFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseAppFontPreferencesInEditor();
        } else {
            newScheme.setFontPreferences(this.myFontPreferences);
        }
        newScheme.myAttributesMap = new HashMap<String, TextAttributes>(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap<ColorKey, Color>(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    @NotNull
    public Set<ColorKey> getColorKeys() {
        Set<ColorKey> set2 = this.myColorsMap.keySet();
        if (set2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(5);
        }
        return set2;
    }

    public @NotNull Map<@NonNls String, TextAttributes> getDirectlyDefinedAttributes() {
        return new HashMap<String, TextAttributes>(this.myAttributesMap);
    }

    public void setEditorFontName(String fontName) {
        ModifiableFontPreferences currPreferences = this.ensureEditableFontPreferences();
        boolean useLigatures = currPreferences.useLigatures();
        int editorFontSize = this.getEditorFontSize();
        currPreferences.clear();
        currPreferences.register(fontName, editorFontSize);
        currPreferences.setUseLigatures(useLigatures);
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.ensureEditableFontPreferences().register(this.myFontPreferences.getFontFamily(), fontSize);
        this.initFonts();
    }

    public void setUseAppFontPreferencesInEditor() {
        this.myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
        this.initFonts();
    }

    public boolean isUseAppFontPreferencesInEditor() {
        return this.myFontPreferences instanceof DelegatingFontPreferences;
    }

    public void setLineSpacing(float lineSpacing) {
        this.ensureEditableFontPreferences().setLineSpacing(lineSpacing);
    }

    @Override
    @NotNull
    public Font getFont(EditorFontType key) {
        Font font = this.myFontPreferences instanceof DelegatingFontPreferences ? EditorFontCache.getInstance().getFont(key) : super.getFont(key);
        if (font == null) {
            AbstractColorsScheme.$$$reportNull$$$0(6);
        }
        return font;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(7);
        }
        this.mySchemeName = name;
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(8);
        }
        return fontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(9);
        }
        preferences.copyTo((FontPreferences)this.ensureEditableFontPreferences());
        this.initFonts();
    }

    @NlsSafe
    public String getEditorFontName() {
        return this.getFont(EditorFontType.PLAIN).getFamily();
    }

    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.myFontPreferences.getFontFamily());
    }

    public float getLineSpacing() {
        return this.myFontPreferences.getLineSpacing();
    }

    protected void initFonts() {
        this.reset();
    }

    @Override
    protected EditorColorsScheme getFontCacheScheme() {
        return this;
    }

    @NonNls
    public String toString() {
        return this.getName();
    }

    public void readExternal(@NotNull Element parentNode) {
        UISettings settings;
        if (parentNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(10);
        }
        ColorBlindness blindness = (settings = UISettings.getInstanceOrNull()) == null ? null : settings.getColorBlindness();
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            List children2 = parentNode.getChildren(SCHEME_ELEMENT);
            if (children2.isEmpty()) {
                throw new InvalidDataException("Scheme is not valid");
            }
            for (Element element2 : children2) {
                this.readScheme(element2);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        Ref fontScale = Ref.create();
        boolean clearEditorFonts = true;
        boolean clearConsoleFonts = true;
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault, (Ref<Float>)fontScale);
                    break;
                }
                case "font": {
                    this.readFontSettings(this.ensureEditableFontPreferences(), childNode, isDefault, (Float)fontScale.get(), clearEditorFonts);
                    clearEditorFonts = false;
                    break;
                }
                case "console-font": {
                    this.readFontSettings(this.ensureEditableConsoleFontPreferences(), childNode, isDefault, (Float)fontScale.get(), clearConsoleFonts);
                    clearConsoleFonts = false;
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT.getExternalName());
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT.getExternalName(), textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        DefaultColorSchemesManager manager2;
        EditorColorsScheme defaultScheme;
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(11);
        }
        if ((defaultScheme = (manager2 = DefaultColorSchemesManager.getInstance()).getScheme(name)) == null) {
            defaultScheme = new TemporaryParent(name);
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(12);
        }
        return editorColorsScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            AbstractColorsScheme.$$$reportNull$$$0(13);
        }
        this.myMetaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(14);
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = e.getAttributeValue("name");
            Element valueElement = e.getChild(VALUE_ELEMENT);
            Object attr = valueElement != null ? this.myValueReader.read(TextAttributes.class, valueElement) : (e.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null ? INHERITED_ATTRS_MARKER : null);
            if (attr == null) continue;
            this.myAttributesMap.put(keyName, (TextAttributes)attr);
        }
    }

    public void readColors(@NotNull Element childNode) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(15);
        }
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = colorElement.getAttributeValue("name");
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            if (valueColor == null && colorElement.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null) {
                valueColor = INHERITED_COLOR_MARKER;
            }
            if (BACKGROUND_COLOR_NAME.equals(keyName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)keyName);
            this.myColorsMap.put(name, (Color)ObjectUtils.notNull((Object)valueColor, (Object)NULL_COLOR_MARKER));
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault, @NotNull Ref<Float> fontScale) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(16);
        }
        if (fontScale == null) {
            AbstractColorsScheme.$$$reportNull$$$0(17);
        }
        switch (childNode.getAttributeValue("name")) {
            case "FONT_SCALE": {
                fontScale.set((Object)this.myValueReader.read(Float.class, childNode));
                break;
            }
            case "LINE_SPACING": {
                Float value2 = this.myValueReader.read(Float.class, childNode);
                if (value2 == null) break;
                this.setLineSpacing(value2.floatValue());
                break;
            }
            case "EDITOR_FONT_SIZE": {
                int value3 = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (value3 <= 0) break;
                this.setEditorFontSize(value3);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value4 = this.myValueReader.read(String.class, childNode);
                if (value4 == null) break;
                this.setEditorFontName(value4);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value5 = this.myValueReader.read(Float.class, childNode);
                if (value5 == null) break;
                this.setConsoleLineSpacing(value5.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                int value6 = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (value6 <= 0) break;
                this.setConsoleFontSize(value6);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value7 = this.myValueReader.read(String.class, childNode);
                if (value7 == null) break;
                this.setConsoleFontName(value7);
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value8 = this.myValueReader.read(Boolean.class, childNode);
                if (value8 == null) break;
                this.ensureEditableFontPreferences().setUseLigatures(value8.booleanValue());
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value9 = this.myValueReader.read(Boolean.class, childNode);
                if (value9 == null) break;
                this.ensureEditableConsoleFontPreferences().setUseLigatures(value9.booleanValue());
                break;
            }
        }
    }

    private int readFontSize(Element element2, boolean isDefault, Float fontScale) {
        if (isDefault) {
            return UISettings.getDefFontSize();
        }
        Integer intSize = this.myValueReader.read(Integer.class, element2);
        if (intSize == null) {
            return -1;
        }
        return UISettings.restoreFontSize((int)intSize, (Float)fontScale);
    }

    private void readFontSettings(@NotNull ModifiableFontPreferences preferences, @NotNull Element element2, boolean isDefaultScheme, @Nullable Float fontScale, boolean clearFonts) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(18);
        }
        if (element2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(19);
        }
        if (clearFonts) {
            preferences.clearFonts();
        }
        List children2 = element2.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child2 : children2) {
            Element e = (Element)child2;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme, fontScale);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences) || !(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag((Element)parentNode, (String)FONT_SCALE, (String)String.valueOf(UISettings.getDefFontScale()));
        }
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag((Element)parentNode, (String)LINE_SPACING, (String)String.valueOf(this.getLineSpacing()));
            if (useOldFontFormat) {
                JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_SIZE, (String)String.valueOf(this.getEditorFontSize()));
                JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_NAME, (String)this.myFontPreferences.getFontFamily());
            } else {
                AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        }
        if (!(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_NAME, (String)this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_SIZE, (String)Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
            if (this.myFontPreferences instanceof DelegatingFontPreferences || this.getConsoleLineSpacing() != this.getLineSpacing()) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_LINE_SPACING, (String)Float.toString(this.getConsoleLineSpacing()));
            }
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag((Element)parentNode, (String)optionName, (String)String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            AbstractColorsScheme.$$$reportNull$$$0(21);
        }
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(22);
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element2 = new Element(key);
            JdomKt.addOptionTag((Element)element2, (String)EDITOR_FONT_NAME, (String)fontFamily);
            JdomKt.addOptionTag((Element)element2, (String)EDITOR_FONT_SIZE, (String)String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element2);
        }
    }

    private void writeAttributes(@NotNull Element attrElements) {
        if (attrElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(23);
        }
        ArrayList<Map.Entry<String, TextAttributes>> list2 = new ArrayList<Map.Entry<String, TextAttributes>>(this.myAttributesMap.entrySet());
        list2.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : list2) {
            String keyName = (String)entry.getKey();
            TextAttributes attributes = (TextAttributes)entry.getValue();
            this.writeAttribute(attrElements, TextAttributesKey.find((String)keyName), attributes);
        }
    }

    private void writeAttribute(@NotNull Element attrElements, @NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (attrElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(24);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(25);
        }
        if (attributes == null) {
            AbstractColorsScheme.$$$reportNull$$$0(26);
        }
        if (attributes == INHERITED_ATTRS_MARKER) {
            boolean parentOverwritingInheritance;
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            TextAttributes parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
            boolean bl = parentOverwritingInheritance = parentAttributes != null && parentAttributes != INHERITED_ATTRS_MARKER;
            if (parentOverwritingInheritance) {
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey != null ? baseKey.getExternalName() : ""));
            }
            return;
        }
        if (this.myParentScheme != null) {
            TextAttributes parentAttributes;
            TextAttributes textAttributes = parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : this.myParentScheme.getAttributes(key);
            if (attributes.equals((Object)parentAttributes)) {
                return;
            }
        }
        Element valueElement = new Element(VALUE_ELEMENT);
        attributes.writeExternal(valueElement);
        attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).addContent(valueElement));
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.myParentScheme;
        if (parentScheme == null) {
            return;
        }
        this.myAttributesMap.entrySet().removeIf(entry -> {
            String keyName = (String)entry.getKey();
            TextAttributes attrs = (TextAttributes)entry.getValue();
            TextAttributesKey key = TextAttributesKey.find((String)keyName);
            if (attrs == INHERITED_ATTRS_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedAttributes(parentScheme, key);
            }
            TextAttributes parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes(key, false) : parentScheme.getAttributes(key);
            return Comparing.equal((Object)parent, (Object)attrs);
        });
        this.myColorsMap.keySet().removeAll(JBIterable.from(this.myColorsMap.keySet()).filter(key -> {
            Color color = this.myColorsMap.get(key);
            if (color == INHERITED_COLOR_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedColors(parentScheme, key);
            }
            Color parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getColor((ColorKey)key, false) : parentScheme.getColor(key);
            return Comparing.equal((Object)parent, (Object)(color == NULL_COLOR_MARKER ? null : color));
        }).toList());
    }

    private static boolean hasExplicitlyDefinedAttributes(@NotNull EditorColorsScheme scheme, @NotNull TextAttributesKey key) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(27);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(28);
        }
        TextAttributes directAttrs = scheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme).getDirectlyDefinedAttributes(key) : null;
        return directAttrs != null && directAttrs != INHERITED_ATTRS_MARKER;
    }

    private static boolean hasExplicitlyDefinedColors(@NotNull EditorColorsScheme scheme, @NotNull ColorKey key) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(29);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(30);
        }
        Color directColor = scheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme).getDirectlyDefinedColor(key) : null;
        return directColor != null && directColor != INHERITED_COLOR_MARKER;
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value2 = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value2);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element2 = metaInfoElement;
        if (element2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(31);
        }
        return element2;
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list2 = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        list2.sort(null);
        for (ColorKey key : list2) {
            this.writeColor(colorElements, key);
        }
    }

    private void writeColor(@NotNull Element colorElements, @NotNull ColorKey key) {
        Color color;
        if (colorElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(32);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(33);
        }
        if ((color = this.myColorsMap.get(key)) == INHERITED_COLOR_MARKER) {
            boolean parentOverwritingInheritance;
            ColorKey fallbackKey = key.getFallbackColorKey();
            Color parentFallback = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : null;
            boolean bl = parentOverwritingInheritance = parentFallback != null && parentFallback != INHERITED_COLOR_MARKER;
            if (fallbackKey != null && parentOverwritingInheritance) {
                colorElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, fallbackKey.getExternalName()));
            }
            return;
        }
        if (this.myParentScheme != null) {
            Color parent;
            Color color2 = parent = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : this.myParentScheme.getColor(key);
            if (parent != null && AbstractColorsScheme.colorsEqual(color, parent)) {
                return;
            }
        }
        Object rgb = "";
        if (color != NULL_COLOR_MARKER) {
            rgb = Integer.toString(0xFFFFFF & color.getRGB(), 16);
            int alpha = 0xFF & color.getAlpha();
            if (alpha != 255) {
                rgb = (String)rgb + Integer.toString(alpha, 16);
            }
        }
        JdomKt.addOptionTag((Element)colorElements, (String)key.getExternalName(), (String)rgb);
    }

    protected static boolean colorsEqual(@Nullable Color c1, @Nullable Color c2) {
        if (c1 == NULL_COLOR_MARKER) {
            return c1 == c2;
        }
        return Comparing.equal((Object)c1, (Object)(c2 == NULL_COLOR_MARKER ? null : c2));
    }

    private ModifiableFontPreferences ensureEditableFontPreferences() {
        if (!(this.myFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myFontPreferences.copyTo((FontPreferences)editablePrefs);
            this.myFontPreferences = editablePrefs;
            ((FontPreferencesImpl)this.myFontPreferences).setChangeListener(() -> this.initFonts());
        }
        return (ModifiableFontPreferences)this.myFontPreferences;
    }

    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(34);
        }
        return fontPreferences;
    }

    public void setUseEditorFontPreferencesInConsole() {
        this.myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
        this.initFonts();
    }

    public boolean isUseEditorFontPreferencesInConsole() {
        return this.myConsoleFontPreferences instanceof DelegatingFontPreferences;
    }

    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(35);
        }
        preferences.copyTo((FontPreferences)this.ensureEditableConsoleFontPreferences());
        this.initFonts();
    }

    @NotNull
    @NlsSafe
    public String getConsoleFontName() {
        String string = this.myConsoleFontPreferences.getFontFamily();
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(36);
        }
        return string;
    }

    private ModifiableFontPreferences ensureEditableConsoleFontPreferences() {
        if (!(this.myConsoleFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myConsoleFontPreferences.copyTo((FontPreferences)editablePrefs);
            this.myConsoleFontPreferences = editablePrefs;
        }
        return (ModifiableFontPreferences)this.myConsoleFontPreferences;
    }

    public void setConsoleFontName(String fontName) {
        ModifiableFontPreferences consolePreferences = this.ensureEditableConsoleFontPreferences();
        int consoleFontSize = this.getConsoleFontSize();
        consolePreferences.clear();
        consolePreferences.register(fontName, consoleFontSize);
    }

    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if ((uiSettings == null || !uiSettings.getPresentationMode()) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    public void setConsoleFontSize(int fontSize) {
        ModifiableFontPreferences consoleFontPreferences = this.ensureEditableConsoleFontPreferences();
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        consoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    public float getConsoleLineSpacing() {
        return this.myConsoleFontPreferences.getLineSpacing();
    }

    public void setConsoleLineSpacing(float lineSpacing) {
        this.ensureEditableConsoleFontPreferences().setLineSpacing(lineSpacing);
    }

    @Nullable
    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            AbstractColorsScheme.$$$reportNull$$$0(37);
        }
        TextAttributesKey cur = fallbackKey;
        while (true) {
            TextAttributes attrs = this.getDirectlyDefinedAttributes(cur);
            TextAttributesKey next = cur.getFallbackAttributeKey();
            if (attrs != null && (attrs != INHERITED_ATTRS_MARKER || next == null)) {
                return attrs;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
    }

    @Nullable
    protected Color getFallbackColor(@NotNull ColorKey fallbackKey) {
        if (fallbackKey == null) {
            AbstractColorsScheme.$$$reportNull$$$0(38);
        }
        ColorKey cur = fallbackKey;
        Color color;
        while ((color = this.getDirectlyDefinedColor(cur)) != NULL_COLOR_MARKER) {
            ColorKey next = cur.getFallbackColorKey();
            if (color != null && (color != INHERITED_COLOR_MARKER || next == null)) {
                return color;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
        return null;
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        TextAttributes attributes;
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(39);
        }
        return (attributes = this.myAttributesMap.get(key.getExternalName())) != null ? attributes : (this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null);
    }

    @Nullable
    public Color getDirectlyDefinedColor(@NotNull ColorKey key) {
        Color color;
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(40);
        }
        return (color = this.myColorsMap.get(key)) != null ? color : (this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : null);
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = this.myIsSaveNeeded ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        if (schemeState == null) {
            AbstractColorsScheme.$$$reportNull$$$0(41);
        }
        return schemeState;
    }

    public void setSaveNeeded(boolean value2) {
        this.myIsSaveNeeded = value2;
    }

    public boolean isReadOnly() {
        return false;
    }

    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.myMetaInfo;
        if (properties == null) {
            AbstractColorsScheme.$$$reportNull$$$0(42);
        }
        return properties;
    }

    public boolean canBeDeleted() {
        return this.myCanBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.myCanBeDeleted = canBeDeleted;
    }

    public boolean isVisible() {
        return true;
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(43);
        }
        return !(scheme instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme).isVisible();
    }

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = EditorColorsManager.getInstance().getScheme(originalSchemeName)) instanceof AbstractColorsScheme && originalScheme != this) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    public EditorColorsScheme getParentScheme() {
        return this.myParentScheme;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        Element element2 = root;
        if (element2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(44);
        }
        return element2;
    }

    public boolean settingsEqual(Object other) {
        return this.settingsEqual(other, null);
    }

    public boolean settingsEqual(Object other, @Nullable Predicate<? super ColorKey> colorKeyFilter) {
        if (!(other instanceof AbstractColorsScheme)) {
            return false;
        }
        AbstractColorsScheme otherScheme = (AbstractColorsScheme)other;
        if (AbstractColorsScheme.getBaseDefaultScheme(this) != AbstractColorsScheme.getBaseDefaultScheme(otherScheme)) {
            return false;
        }
        for (String propertyName : this.myMetaInfo.stringPropertyNames()) {
            if (propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Objects.equals(this.myMetaInfo.getProperty(propertyName), otherScheme.myMetaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return AbstractColorsScheme.areDelegatingOrEqual(this.myFontPreferences, otherScheme.getFontPreferences()) && AbstractColorsScheme.areDelegatingOrEqual(this.myConsoleFontPreferences, otherScheme.getConsoleFontPreferences()) && this.attributesEqual(otherScheme) && this.colorsEqual(otherScheme, colorKeyFilter);
    }

    protected static boolean areDelegatingOrEqual(@NotNull FontPreferences preferences1, @NotNull FontPreferences preferences2) {
        if (preferences1 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(45);
        }
        if (preferences2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(46);
        }
        boolean isDelegating1 = preferences1 instanceof DelegatingFontPreferences;
        boolean isDelegating2 = preferences2 instanceof DelegatingFontPreferences;
        return isDelegating1 || isDelegating2 ? isDelegating1 && isDelegating2 : preferences1.equals(preferences2);
    }

    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.myAttributesMap.equals(otherScheme.myAttributesMap);
    }

    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<? super ColorKey> colorKeyFilter) {
        if (this.myColorsMap.size() != otherScheme.myColorsMap.size()) {
            return false;
        }
        for (Map.Entry<ColorKey, Color> entry : this.myColorsMap.entrySet()) {
            ColorKey key;
            Color c2;
            Color c1 = entry.getValue();
            if (AbstractColorsScheme.colorsEqual(c1, c2 = otherScheme.myColorsMap.get(key = entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static EditorColorsScheme getBaseDefaultScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(47);
        }
        if (!(scheme instanceof AbstractColorsScheme)) {
            return null;
        }
        if (scheme instanceof DefaultColorsScheme) {
            return scheme;
        }
        EditorColorsScheme parent = ((AbstractColorsScheme)scheme).myParentScheme;
        return parent != null ? AbstractColorsScheme.getBaseDefaultScheme(parent) : null;
    }

    public void setParent(@NotNull EditorColorsScheme newParent) {
        if (newParent == null) {
            AbstractColorsScheme.$$$reportNull$$$0(48);
        }
        assert (newParent instanceof ReadOnlyColorsScheme) : "New parent scheme must be read-only";
        this.myParentScheme = newParent;
    }

    void resolveParent(@NotNull Function<? super String, ? extends EditorColorsScheme> nameResolver2) {
        if (nameResolver2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(49);
        }
        if (this.myParentScheme instanceof TemporaryParent) {
            String parentName = ((TemporaryParent)this.myParentScheme).getParentName();
            EditorColorsScheme newParent = nameResolver2.apply(parentName);
            if (!(newParent instanceof ReadOnlyColorsScheme)) {
                throw new InvalidDataException(parentName);
            }
            this.myParentScheme = newParent;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 18: 
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaInfoElement";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontScale";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 33: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrElements";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTES_ELEMENT;
                break;
            }
            case 27: 
            case 29: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCHEME_ELEMENT;
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorElements";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackKey";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences1";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBackground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "metaInfoToElement";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleFontPreferences";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleFontName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeState";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaProperties";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFontPreferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultScheme";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readMetaInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readColors";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readFontSettings";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeFontPreferences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributes";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDefinedAttributes";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDefinedColors";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writeColor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleFontPreferences";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackAttributes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackColor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyDefinedAttributes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyDefinedColor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areDelegatingOrEqual";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDefaultScheme";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TemporaryParent
    extends EditorColorsSchemeImpl {
        private final String myParentName;

        TemporaryParent(@NotNull String parentName) {
            if (parentName == null) {
                TemporaryParent.$$$reportNull$$$0(0);
            }
            super(EmptyColorScheme.INSTANCE);
            this.myParentName = parentName;
        }

        @NonNls
        public String getParentName() {
            return this.myParentName;
        }

        @Override
        public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
            return super.getAttributes(key);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            return super.getColor(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentName", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme$TemporaryParent", "<init>"));
        }
    }
}

